#include <string.h>
#include <sys/types.h>

size_t strlcpy( char *dst, const char *src, size_t size )
{
    size_t length, copy;

    length = strlen( src );
    if( size > 0 ) {
        copy = ( length >= size ) ? size - 1 : length;
        memcpy( dst, src, copy );
        dst[ copy ] = '\0';
    }
    
    return( length );
}

