#include <string.h>

static char __unknown[] = "Unknown error";

char *_sys_errlist[] = {
    "No error",
    "Unknown system call",
    "No such directory",
    "No such path",
    "Too many open files",
    "Permission denied",
    "Bad file number",
    "MCB destroyed",
    "Not enough memory",
    "Bad address",
    "Environment invalid",
    "Format invalid",
    "Address invalid",
    "Invalid argument",
    "Arg list too big",
    "No such device",
    "Attempt to remove current directory",
    "Not same device",
    "No more files",
    "Read-only file system",
    "No such device or address",
    "Device or resource busy",
    "I/O error",
    "Bad struct length",
    "Seek error",
    "Unknown media type",
    "Sector not found",
    "Printer out of paper",
    "Write error",
    "Read error",
    "General failure",
    "Sharing violation",
    "No locks available on system",
    "Disk change invalid",
    "Resource unavailable, try again",
    "Sharing buffer overflow",
    "Exec format error",
    "Dead-lock occured",
    "No space left on device",
    "Argument too large",
    "Result too large",
    "Resource deadlock would occur",
    "Child does not exist",
    "Device or resource busy",
    "File too large",
    "File table overflow",
    "Is a directory",
    "Not a directory",
    "Too many links",
    "Block device required",
    "No such device or address",
    "Not owner",
    "Broken pipe",
    "No such process",
    "Text file busy",
    "Directory not empty",
    "Illegal multibyte sequence",
    "SYMLOOP_MAX was reached",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "File exists",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL,
    "System call interrupted",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL,
    "Filename too long",
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    "Illegal seek"
};

char *strerror( int errnum )
{
    return( ( errnum > 0 && errnum < 133 ) ? ( _sys_errlist[ errnum ] ) ?
                                            _sys_errlist[ errnum ] :
                                            __unknown :
                                            __unknown );
}

