#include <string.h>

void far *_fmemmove( void far *dest, const void far *source, size_t length)
{
    char far *d = dest;
    const char far *s = source;

    if( s < d ) {
        /* Moving from low mem to hi mem; start at end.  */
        for( s += length, d += length; length; --length)
            *d-- = *s--;
    } else if( s != d ) {
        /* Moving from hi mem to low mem; start at beginning.  */
        for( ; length; length-- )
            *d++ = *s++;
    }
    
    return( d );
}
