#include <stdlib.h>

#define a 16807         /* multiplier */
#define m 2147483647L   /* 2**31 - 1 */
#define q 127773L       /* m div a */
#define r 2836          /* m mod a */

static long __nextrand( long seed )
{
    unsigned long lo, hi;

    lo = a * ( long )( seed & 0xFFFF );
    hi = a * ( long )( ( unsigned long )seed >> 16 );
    lo += ( hi & 0x7FFF ) << 16;
    if( lo > m ) {
        lo &= m;
        ++lo;
    }
    lo += hi >> 15;
    if( lo > m ) {
        lo &= m;
        ++lo;
    }
    return( ( long )lo );
}

static long __randomnum = 1;

int rand( void )
{
      return( ( int )( __randomnum = __nextrand( __randomnum ) ) & 0xFFFF );
}

void srand( unsigned seed )
{
      __randomnum = seed ? ( seed & m ) : 1;
}

