#include <stdlib.h>

unsigned short __rand48buf[ 3 ];

#define A_0 0xE66D
#define A_1 0xDEEC
#define A_2 0x5
#define C   0xB

static unsigned short a[ 3 ] = { A_0, A_1, A_2 };
static unsigned short c = C;

void __calc_next( unsigned short buf[ 3 ] )
{
    unsigned short tmp[ 3 ];
    long t;

    t = buf[ 0 ] * a[ 0 ] + c;
    tmp[ 0 ] = t & 0xffff;
    tmp[ 1 ] = ( t >> 16 ) & 0xffff;
    t = buf[ 1 ] * a[ 0 ] + buf[ 0 ] * a[ 1 ] + tmp[ 1 ];
    tmp[ 1 ] = t & 0xffff;
    tmp[ 2 ] = ( t >> 16 ) & 0xffff;
    t = buf[ 2 ] * a[ 0 ] + buf[ 1 ] * a[ 1 ] + buf[ 0 ] * a[ 2 ] + tmp[ 2 ];
    tmp[ 2 ] = t & 0xffff;
    buf[ 0 ] = tmp[ 0 ];
    buf[ 1 ] = tmp[ 1 ];
    buf[ 2 ] = tmp[ 2 ];
}

long lrand48( void )
{
    return( nrand48( __rand48buf ) );
}

long mrand48( void )
{
    return( jrand48( __rand48buf ) );
}

void srand48( long seed )
{
    __rand48buf[ 1 ] = ( seed >> 16 ) & 0xffff;
    __rand48buf[ 2 ] = seed & 0xffff;
    __rand48buf[ 0 ] = 0x330e;
    a[ 0 ] = A_0;
    a[ 1 ] = A_1;
    a[ 2 ] = A_2;
    c = C;
}

unsigned short *seed48( unsigned short buf[ 3 ] )
{
    static unsigned short oldx[ 3 ];
    int i;

    for( i = 0; i < 3; i++ ) {
        oldx[ i ] = __rand48buf[ i ];
        __rand48buf[ i ] = buf[ i ];
    }

    a[ 0 ] = A_0;
    a[ 1 ] = A_1;
    a[ 2 ] = A_2;
    c = C;

    return( ( unsigned short * )&oldx );
}

void lcong48( unsigned short param[ 7 ] )
{
    int i;

    for( i = 0; i < 3; i++ ) {
        __rand48buf[ i ] = param[ i ];
        a[ i ] = param[ i + 3 ];
    }

    c = param[ 6 ];
}

long jrand48( unsigned short buf[ 3 ] )
{
    long ret;

    ret = ( long )buf[ 2 ] << 16 | buf[ 1 ];
    __calc_next( buf );

    return( ret );
}

long nrand48( unsigned short buf[ 3 ] )
{
    return( jrand48( buf ) & 0x7FFFFFFFL );
}

