#include <stdlib.h>
#include <string.h>

#define m   ( unsigned long )2147483647
#define q   ( unsigned long )127773
#define a   ( unsigned int  )16807
#define r   ( unsigned int  )2836

static unsigned long rseed = 1;
static char          rstate[ 256 ];
static char          oldstate[ 256 ];
static size_t        rstatesize = 128;

char *initstate( unsigned seed, char *state, size_t size )
{
    if( size > 256 || size < 8 ) return( NULL );
    rseed = seed;
    memcpy( oldstate, rstate, rstatesize );
    rstatesize = size;
    memcpy( state, oldstate, rstatesize );

    return( oldstate );
}

char *setstate( const char *state )
{
    memcpy( oldstate, rstate, rstatesize );
    memcpy( rstate, state, rstatesize );

    return( oldstate );
}

void srandom( unsigned seed )
{
    rseed = seed;
}

long random( void )
{
    register int lo, hi, test;
    int i = 0, j = 0;
    
    hi   = rseed / q;
    lo   = rseed % q;
    test = a * lo - r * hi;
    
    if( test > 0 ) rseed = test;
    else           rseed = test + m;

    for( ; i < rstatesize; i++ ) {
        if( j == 0 ) hi = rseed / rstate[ i ];
        else         hi = rseed * rstate[ i ];
        lo = rseed % rstate[ i ];
    }

    test = a * lo - r * hi;

    if( test > 0 ) rseed = test;
    else           rseed = test + m;
    
    return( rseed );
}

