#include <dir.h>
#include <dos.h>
#include <string.h>
#include <stddef.h>
#include <malloc.h>
#include <errno.h>

int __dogetfn( const char *relpath, char *destpath );
#ifdef __CLIB_LFN__
#pragma aux __dogetfn = \
    "mov ax, 0x7160"    \
    "mov cx, 0x0002"    \
    "int 0x21"          \
    "jnc finish"        \
    "mov ah, 0x60"      \
    "int 0x21"          \
    "finish:"           \
    "sbb ax, ax"        \
    parm [si] [di]      \
    value [ax]          \
    modify [ax cx si di];
#else
#pragma aux __dogetfn = \
    "mov ah, 0x60"      \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [si] [di]      \
    value [ax]          \
    modify [ax si di];
#endif

char *_fullpath( char *pathbuf, const char *relpath, size_t length )
{
    char *buf = pathbuf;
    register int retval;

    if( length == 0 ) length = _MAX_PATH;
    if( length < _MAX_PATH ) return( NULL );

    if( buf == NULL && ( buf = malloc( length ) ) == NULL ) {
        return( NULL );
    }

    if( ( retval = __dogetfn( __retsfn( relpath ), buf ) ) < 0 ) {
        errno = _doserrno = -retval;
        return( NULL );
    }

    return( buf );
}

