#include <stdio.h>
#include <_printf.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>

static char *__prntnstrng;
static int __maxlen;

int __putsnchar( int ch )
{
    char *p = __prntnstrng;

    while( *p ) p++;

    if( strlen( __prntnstrng ) >= __maxlen ) return( EOF );
    if( realloc( __prntnstrng, strlen( __prntnstrng ) + 1 ) == NULL )
        return( EOF );
    *p = ch;
    p++;
    *p = '\0';

    return( ch );
}

int vasnprintf( char **string, int maxlen, const char *fmt, va_list args )
{
    __prntnstrng = *string;
    __maxlen = maxlen;

    if( __maxlen < 2 ) /* Need one for one character, and another for NULL */
        return( 0 );

    __prntnstrng = malloc( 2 ); /* Start out with 2 bytes, alloc as we go */
    *__prntnstrng = '\0';

    return( __vfnprintf( __putsnchar, fmt, args ) );
}

int asnprintf( char **string, int maxlen, const char *fmt, ... )
{
    va_list args;

    va_start( args, fmt );

    return( vasnprintf( string, maxlen, fmt, args ) );
}

