#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <process.h>

extern int __errorlevel;
static const char *__omode, *__command;
static int __err;

FILE *popen( const char *command, const char *mode )
{
    FILE *retval = tmpfile();

    __omode = mode;
    __command = command;

    if( retval == NULL ) return( NULL );

    if( mode[ 1 ] != '\0' || ( mode[ 0 ] != 'r' && mode[ 0 ] != 'w' ) ) {
        errno = EINVAL;

        return( NULL );
    }

    if( *mode == 'r' ) {
        int dupl = dup( 1 );
        dup2( retval->fd, 1 );
        if( system( command ) == -1 ) {
            fclose( retval );
            dup2( dupl, 1 );

            return( NULL );
        }
        __err = __errorlevel;

        dup2( dupl, 1 );
    }
    
    return( retval );
}

int pclose( FILE *fp )
{
    if( fp == NULL ) return( -1 );

    if( *__omode == 'w' ) {
        int dupl = dup( 0 );

        dup2( fp->fd, 0 );
        if( system( __command ) == -1 ) {
            fclose( fp );
            dup2( dupl, 0 );

            return( -1 );
        }
        __err = __errorlevel;

        dup2( dupl, 0 );
    }

    fclose( fp );

    return( __err );
}

