#include <stdio.h>
#include <fcntl.h>

int __getomode( const char *mode )
{
    const char *m = mode;
    int tmpmode = 0;

    while( *m ) {
        switch( *m ) {
            case 'r':
                tmpmode = 0;
                if( *( m + 1 ) == '+' || *( m + 2 ) == '+' ) tmpmode |= O_RDWR;
                else tmpmode |= O_RDONLY;
                break;
            case 'w':
                tmpmode = 0;
                if( *( m + 1 ) == '+' || *( m + 2 ) == '+' )
                    tmpmode |= ( O_RDWR | O_CREAT | O_TRUNC );
                else
                    tmpmode |= ( O_WRONLY | O_CREAT | O_TRUNC );
                break;
            case 'a':
                tmpmode = 0;
                if( *( m + 1 ) == '+' || *( m + 2 ) == '+' )
                    tmpmode |= ( O_RDWR | O_APPEND | O_CREAT );
                else tmpmode |= ( O_WRONLY | O_APPEND | O_CREAT );
                break;
            case 't':
                tmpmode &= ~O_BINARY;
                tmpmode |= O_TEXT;
                break;
            case 'b':
                tmpmode &= ~O_TEXT;
                tmpmode |= O_BINARY;
                break;
        }
        m++;
    }

    return( tmpmode );
}

