#include <sys/stat.h>
#include <dir.h>
#include <time.h>
#include <io.h>
#include "h2name.h"

struct __lfnhandleinfo {
    long attrs;
    long hicrtime;
    long locrtime;
    long hiactime;
    long loactime;
    long himdtime;
    long lomdtime;
    long serialnum;
    long hisize;
    long losize;
    long nlinks;
    long hiino;
    long loino;
};

int __gethinf( int fildes, struct __lfnhandleinfo *buf );
#pragma aux __gethinf = \
    "mov ax, 0x71A6"    \
    "stc"               \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [bx] [dx]      \
    value [ax]          \
    modify [ax bx dx];

int fstat( int fildes, struct stat *buf )
{
    struct __lfnhandleinfo info;
    unsigned dosdate, dostime;
//    char *filename = __h2name( fildes );

    if( __gethinf( fildes, &info ) >= 0 ) {
        buf->st_attr = ( mode_t )info.attrs;
        buf->st_dev = ( dev_t )info.serialnum;
        buf->st_mode = buf->st_attr;
        if( !( buf->st_attr & FA_RDONLY ) ) buf->st_mode |= S_IWRITE;
        buf->st_nlink = ( nlink_t )info.nlinks;
        buf->st_uid = buf->st_gid = 1;
        buf->st_size = info.losize;
        buf->st_ino = info.loino;
        buf->st_ctime = 0;
        buf->st_atime = 0;
        _dos_getftime( fildes, &dosdate, &dostime );
        buf->st_mtime = ( ( time_t )dosdate << 16 ) | ( dostime );
        return( 0 );
    }

    return( -1 );
}

