#include <signal.h>
#include <dos.h>
#include <errno.h>
#include <stdlib.h>
#include <io.h>

extern void interrupt far ( *__oldhandlers[ 5 ] )( void );

void ( *__handlers[ 7 ] )( int sig ) = {
    SIG_DFL,
    SIG_DFL,
    SIG_DFL,
    SIG_DFL,
    SIG_DFL,
    SIG_DFL,
    SIG_DFL
};

void __sigdfl( int sig )
{
    if( sig == SIGABRT ) _exit( 3 );
    _exit( 1 );
}

void __sigerr( int sig )
{
    write( 2, "An error occurred\n", 18 );
}

void __sigign( int sig )
{
    return;
}

int interrupt __siginthandler( void )
{
    ( __handlers[ SIGINT ] )( SIGINT );

    return( 1 );
}

void interrupt __sig6handler( void )
{
    ( __handlers[ SIGILL ] )( SIGILL );
}

void interrupt __sig0handler( void )
{
    ( __handlers[ SIGFPE ] )( SIGFPE );
}

void interrupt __sig5handler( void )
{
    ( __handlers[ SIGSEGV ] )( SIGSEGV );
}

void ( *signal( int sig, void ( *func )( int sig ) ) )( int sig )
{
    void ( *retfunc )( int sig ) = __handlers[ sig ];

    if( sig > 6 ) {
        errno = EINVAL;

        return( SIG_ERR );
    }

    __handlers[ sig ] = func;
    if( sig == SIGINT ) {
        if( __oldhandlers[ 0 ] == NULL ) __oldhandlers[ 0 ] = getvect( 0x23 );
        setvect( 0x23, ( void interrupt far ( * )() )__siginthandler );
    }
    if( sig == SIGILL ) {
        if( __oldhandlers[ 1 ] == NULL ) __oldhandlers[ 1 ] = getvect( 0x06 );
        setvect( 0x06, ( void interrupt far ( * )() )__sig6handler );
    }
    if( sig == SIGFPE ) {
        if( __oldhandlers[ 2 ] == NULL ) __oldhandlers[ 2 ] = getvect( 0x00 );
        if( __oldhandlers[ 3 ] == NULL ) __oldhandlers[ 3 ] = getvect( 0x04 );
        setvect( 0x00, ( void interrupt far ( * )() )__sig0handler );
        setvect( 0x04, ( void interrupt far ( * )() )__sig0handler );
    }
    if( sig == SIGSEGV ) {
        if( __oldhandlers[ 4 ] == NULL ) __oldhandlers[ 4 ] = getvect( 0x05 );
        setvect( 0x05, ( void interrupt far ( * )() )__sig5handler );
    }

    return( retfunc );
}
