#include <stdlib.h>
#include <dos.h>
#include <errno.h>
#include <process.h>
#include <string.h>
#include <dir.h>
#include <io.h>
#include <limits.h>

static const char __exe[] = ".EXE";
static const char __com[] = ".COM";
static const char __bat[] = ".BAT";

int spawnvpe( int mode, const char *path, char **argv, char **envp )
{
    char fullpath[ PATH_MAX ], *f, *p;

    strcpy( fullpath, path );

    f = strrchr( fullpath, '\\' );
    if( f == NULL ) f = fullpath;
    while( *f != '.' && *f ) f++;

    if( strcmpi( f, __com ) == 0 ||
        strcmpi( f, __exe ) == 0 ||
        strcmpi( f, __bat ) == 0 ) {
        p = searchpath( fullpath );
        if( p == NULL ){
            free( fullpath );

            return( -1 );
        }
        goto end;
    }
    strcpy( f, __com );
    if( ( p = searchpath( fullpath ) ) != NULL ) goto end;
    strcpy( f, __exe );
    if( ( p = searchpath( fullpath ) ) != NULL ) goto end;
    strcpy( f, __bat );
    if( ( p = searchpath( fullpath ) ) == NULL ) {
        free( fullpath );

        return( -1 );
    }
end:

    return( spawnve( mode, p, argv, envp ) );
}

