#include <dos.h>
#include <malloc.h>
#include <string.h>
#include <errno.h>

unsigned __getds( void );
#pragma aux __getds = "mov ax, ds" value [ax];

void *malloc( size_t size )
{
    unsigned seg;
    void *retval;

    if( _dos_allocmem( ( size / 16 ) + 1, &seg ) != 0 ) {
        errno = ENOMEM;

        return( NULL );
    }

    if( ( unsigned long )( ( seg - __getds() ) * 16 ) > 0xFFFF ) {
        _dos_freemem( seg );
        errno = ENOMEM;

        return( NULL );
    }

    return( ( void * )( ( seg - __getds() ) * 16 ) );
}

void free( void *ptr )
{
    _dos_freemem( ( ( unsigned )ptr / 16 ) + __getds() );
}

