#include <dos.h>
#include <fcntl.h>
#include <errno.h>
#include <io.h>

ssize_t read( int handle, void *rdbuf, unsigned rdlen )
{
    int retval = 1, len = rdlen;
    char *buf = rdbuf;

    while( len ) {
        retval = _read( __oshandle( handle ), buf, 1 );

        if( retval == 0 || retval == -1 ) break;

        if( ( handle & O_TEXT ) && *buf == '\r' ) continue;
        if( ( handle & O_TEXT ) && *buf == 26 ) break; /* CtrlZ - EOF */

        buf++;
        len--;
    }

    return( len == rdlen ? -1 : rdlen - len );
}

