#include <io.h>
#include <sys/locking.h>
#include <dos.h>
#include <errno.h>

int __doflocg( unsigned char func, int handle, long *offset, long *length );
#pragma aux __doflock = \
    "mov ah, 0x5C"      \
    "int 0x21"          \
    "sbb ax, ax"        \
    parm [al] [bx] [dx] [di]\
    value [ax]          \
    modify [ax bx dx di];

int locking( int handle, int cmd, long length )
{
    register int retval;
    long offset = 0L;

    if( cmd == LK_LOCK ) {
        int count = 0;

        while( ( retval = __doflocg( 0x00, handle, &offset, &length ) ) < 0 &&
               count < 10 ) {
            count++;
            sleep( 1 );
        }

        if( retval < 0 ) {
            errno = EDEADLOCK;
            return( -1 );
        }
    } else if( cmd == LK_NBLCK ) {
        if( ( retval = __doflocg( 0x00, handle, &offset, &length ) ) < 0 ) {
            errno = EBADF;
            return( -1 );
        }
    } else if( cmd == LK_UNLCK ) {
        if( ( retval = __doflocg( 0x01, handle, &offset, &length ) ) < 0 ) {
            errno = EBADF;
            return( -1 );
        }
    }

    return( 0 );
}
