#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

int __dlcrnew( const char *path, int attr );
#pragma aux __dlcrnew = \
    "mov ax, 0x716C"    \
    "mov dx, 0x10"      \
    "mov bx, 0x0002"    \
    "stc"               \
    "int 0x21"          \
    "jnc finish"        \
    "mov errno, ax"     \
    "sbb ax, ax"        \
    "finish:"           \
    parm [si] [cx]      \
    value [ax]          \
    modify [ax bx cx dx si];

int __docrnew( const char *path, int attr );
#pragma aux __docrnew = \
    "mov ah, 0x5B"      \
    "int 0x21"          \
    "jnc end"           \
    "mov errno, ax"     \
    "sbb ax, ax"        \
    "end:"              \
    parm [dx] [cx]      \
    value [ax]          \
    modify [ax bx cx dx];

int creatnew( const char *path, int attr )
{
#ifndef __CLIB_LFN__
    register int retval = __docrnew( path, attr );

    if( retval < 0 ) {
        errno = ( -retval );
        
        return( -1 );
    }

    return( retval );
#else
    register int oldstderr = dup( 2 );
    register int retval = __dlcrnew( path, attr );

    if( retval < 0 ) __docrnew( path, attr );
    if( retval < 0 ) {
        _close( oldstderr );
        errno = ( -retval );
        return( -1 );
    }

    _close( 2 );
    dup2( oldstderr, 2 );
    _close( oldstderr );
    _close( retval );

    return( _open( path, O_WRONLY ) );
#endif
}

