#ifndef __TERMIOS_H
#define __TERMIOS_H

#include <_defs.h>
#include <sys/types.h>

#define NCCS            32

typedef unsigned char   cc_t;
typedef unsigned        speed_t;
typedef unsigned        tcflag_t;

struct termios {
    tcflag_t            c_iflag;        /* Input flags */
    tcflag_t            c_oflag;        /* Output flags */
    tcflag_t            c_cflag;        /* Control flags */
    tcflag_t            c_lflag;        /* Local flags */
    cc_t                c_cc[ NCCS ];   /* Control characters */
};

#define VEOF            0
#define VEOL            1
#define VERASE          2
#define VINTR           3
#define VKILL           4
#define VMIN            5
#define VQUIT           6
#define VSTART          7
#define VSTOP           8
#define VSUSP           9
#define VTIME           10

#define BRKINT          0x0001
#define ICRNL           0x0002
#define IGNBRK          0x0004
#define IGNCR           0x0008
#define IGNPAR          0x0010
#define INLCR           0x0020
#define INPCK           0x0040
#define ISTRIP          0x0080
#define IXANY           0x0100
#define IXOFF           0x0200
#define IXON            0x0400
#define PARMRK          0x0800

#define OPOST           0x0001
#define ONLCR           0x0002
#define OCRNL           0x0004
#define ONOCR           0x0008
#define ONLRET          0x0010
#define OFILL           0x0020
#define NLDLY           0x0040
#define CRDLY           0x0080
#define TABDLY          0x0100
#define BSDLY           0x0200
#define VTDLY           0x0400
#define FFDLY           0x0800

#define B0              0
#define B50             1
#define B75             2
#define B110            3
#define B134            4
#define B150            5
#define B200            6
#define B300            7
#define B600            8
#define B1200           9
#define B1800           10
#define B2400           11
#define B4800           12
#define B9600           13
#define B19200          14
#define B38400          15

#define CSIZE           0x0001
#define CSTOPB          0x0002
#define CREAD           0x0004
#define PARENB          0x0008
#define PARODD          0x0010
#define HUPCL           0x0020
#define CLOCAL          0x0040

#define CS5             0
#define CS6             1
#define CS7             2
#define CS8             3

#define ECHO            0x0001
#define ECHOE           0x0002
#define ECHOK           0x0004
#define ECHONL          0x0008
#define ICANON          0x0010
#define IEXTEN          0x0020
#define ISIG            0x0040
#define NOFLSH          0x0080
#define TOSTOP          0x0100

#endif

