#ifndef __SYS_UIO_H
#define __SYS_UIO_H

#include <sys/types.h>

struct iovec {
    void * iov_base; /* Buffer to read/write to/from */
    size_t iov_len;  /* Lenth to read/write */
};

ssize_t readv( int handle, const struct iovec *iov, int iovcnt );
ssize_t writev( int handle, const struct iovec *iov, int iovcnt );

#define UIO_MAXIOV  32767

#endif

