#ifndef __STATVFS_H
#define __STATVFS_H

#include <sys/types.h>

struct statvfs {
    unsigned long   f_bsize;    /* Block size */
    unsigned long   f_frsize;   /* Fundamental block size */
    fsblkcnt_t      f_blocks;   /* Number of blocks on file system */
    fsblkcnt_t      f_bfree;    /* Total number of free blocks */
    fsblkcnt_t      f_bavail;   /* Number of free blocks for all processes */
    fsfilcnt_t      f_files;    /* Number of file serial numbers */
    fsfilcnt_t      f_ffree;    /* Number of free file serial numbers */
    fsfilcnt_t      f_favail;   /* Number of free file serial numbers (all) */
    unsigned long   f_fsid;     /* File system ID */
    unsigned long   f_flag;     /* Bit mask of f_flag values */
    unsigned long   f_namemax;  /* Maximum filename length */
};

extern int statvfs( const char * restrict path, struct statvfs * restrict buf );
extern int fstatvfs( int fildes, struct statvfs * buf );

#define ST_READONLY 0x01
#define ST_NOSUID   0x02

#endif

