#ifndef __STDLIB_H
#define __STDLIB_H

#include <_defs.h>
#include <stddef.h>
#include <sys/types.h>
#include <errno.h>
#include <malloc.h>
#include <stdint.h>

extern void ( * __userexit[] )( void );
extern char **  environ;

extern void     abort( void );
extern long     a64l( const char *s );
extern int      abs( int num );
extern int      atexit( void ( *func )( void ) );
extern void *   bsearch( const void *key, const void *base, size_t nmemb,
                         size_t size,
                         int( *compar )( const void *m1, const void *m2 ) );
extern int      clearenv( void );
extern clock_t  clock( void );
extern div_t    div( int num, int denom );
extern double   drand48( void );
extern double   erand48( unsigned short buf[ 3 ] );
extern void     _exit( int retval );
extern void     exit( int retval );
extern char *   _fullpath( char *pathbuf, const char *relpath, size_t length );
extern char *   getenv( const char *name );
extern char *   initstate( unsigned seed, char *state, size_t size );
extern long     jrand48( unsigned short buf[ 3 ] );
extern char *   l64a( long value );
extern long     labs( long num );
extern void     lcong48( unsigned short param[ 7 ] );
extern ldiv_t   ldiv( long num, long denom );
extern int64_t  llabs( long long num );
#ifdef __HAVE_LONG_LONG__
extern lldiv_t  lldiv( long long num, long long denom );
#endif
extern char *   lltoa( long long val, char *buf, int base );
extern long     lrand48( void );
extern char *   ltoa( long val, char *buf, int base );
extern void     _makepath( char *p, const char *dr, const char *d,
                           const char *f, const char *e );
extern long     mrand48( void );
extern long     nrand48( unsigned short buf[ 3 ] );
extern char *   ptsname( int fildes );
extern int      putenv( char *entry );
extern void     qsort( void *basep, size_t nelems, size_t size,
                       int( *comp )( const void *m1, const void *m2 ) );
extern int      rand( void );
extern int      rand_r( unsigned *seed );
extern long     random( void );
extern uint16_t*seed48( unsigned short buf[ 3 ] );
extern int      setenv( const char *name, const char *value, int overwrite );
extern char *   setstate( const char *state );
extern void     srand( unsigned seed );
extern void     srand48( long seed );
extern void     srandom( unsigned seed );
extern void     swab( const void *src, void *dest, ssize_t num );
extern int      system( const char *cmdline );
extern char *   realpath( const char *relpath, char *pathbuf );
extern char *   _searchenv( const char *filename, const char *varname,
                            char *fullpath );
extern void     _splitpath( const char *p, char *d, char *di,
                                           char *n, char *e );
extern long     strtol( const char *nptr, char **endptr, int base );
extern int64_t  strtoll( const char *nptr, char **endptr, int base );
extern uint32_t strtoul( const char *nptr, char **endptr, int base );
extern uint64_t strtoull( const char *nptr, char **endptr, int base );
extern char *   ultoa( uint32_t val, char *buf, int base );
extern char *   ulltoa( uint64_t val, char *buf, int base );
extern int      unsetenv( const char *name );

#define atoi( x )       ( ( int )strtol( x, NULL, 10 ) )
#define atol( x )       ( strtol( x, NULL, 10 ) )
#define atoll( x )      ( strtoll( x, NULL, 10 ) )
#define grantpt( x )    0
#define itoa( x, y, z ) ltoa( ( long )x, y, z )
#define min( x, y )     ( ( ( x ) <= ( y ) ) ? ( x ) : ( y ) )
#define max( x, y )     ( ( ( x ) >= ( y ) ) ? ( x ) : ( y ) )
#ifdef _BORLAND_SOURCE
#define random( x )     ( rand() % x )
#endif
#define randomize()     ( srand( clock() ) )
#define unlockpt( x )   0

#define EXIT_SUCCESS    0
#define EXIT_FAILURE    255
#define RAND_MAX        32767
#define MB_CUR_MAX      1

#endif

