#ifndef __STDARG_H
#define __STDARG_H

#include <_defs.h>

typedef char * va_list;

#define __typewidth( type )     ( ( sizeof( type ) + sizeof( int ) - 1 ) \
                                & ~( sizeof( int ) - 1 ) )

#define va_copy( dest, src )    ( dest = src, ( void )0 )
#define va_start( list, last )  ( list = ( ( char * ) & ( last ) + \
                                __typewidth( last ) ), ( void )0 )
#define va_arg( list, type )    ( list += __typewidth( type ), \
                                ( *( type * )( list - \
                                __typewidth( type ) ) ) )
#define va_end( list )          ( list = NULL )

#if defined( __TURBOC__ ) || defined( __BORLANDC__ )
#define _va_ptr                 ( ... )
#define __va_ptr( last )        _va_ptr
#else
#define __va_ptr( last )        ( void * )( ( char * ) & ( last ) + \
                                __typewidth( last ) )
#endif

#endif

