#ifndef __MALLOC_H
#define __MALLOC_H

#include <_defs.h>
#include <stddef.h>

extern int          brk( void *addr );
extern void *       calloc( size_t items, size_t size );
extern void far *   _fcalloc( size_t items, size_t size );
extern void         _ffree( void far *buf );
extern void far *   _fmalloc( size_t len );
extern void far *   _frealloc( void far *ptr, size_t newlength );
extern void         free( void *buf );
extern void *       malloc( size_t len );
extern void *       realloc( void *ptr, size_t newlength );
extern void *       sbrk( int curbrk );

#define farcalloc   _fcalloc
#define farfree     _ffree
#define farmalloc   _fmalloc
#define farrealloc  _frealloc

#endif

