#ifndef __CONIO_H
#define __CONIO_H

#include <_defs.h>
#include <dos.h> /* outport, etc... */
#include <stdarg.h>

#ifdef __WATCOMC__
#pragma pack( __push, 1 )
#endif

struct text_info {
    unsigned char winleft;        /* left window coordinate */
    unsigned char wintop;         /* top window coordinate */
    unsigned char winright;       /* right window coordinate */
    unsigned char winbottom;      /* bottom window coordinate */
    unsigned char attribute;      /* text attribute */
    unsigned char normattr;       /* normal attribute */
    unsigned char currmode;       /* current video mode */
    unsigned char screenheight;   /* text screen's height */
    unsigned char screenwidth;    /* text screen's width */
    unsigned char curx;           /* x-coordinate in current window */
    unsigned char cury;           /* y-coordinate in current window */
};

#ifdef __WATCOMC__
#pragma pack( __pop )
#endif

extern int  directvideo,
            _wscroll;

extern void __beep( void );
extern void __cgaenablevid( unsigned char status );
extern char *__cgets( char *s );
extern void __gotoxy( unsigned char x, unsigned char y );
extern void __initialize_conio( void );
extern int  __putch( int ch );
extern void __scroll( int t, int l, int b, int r, int a, int d, int n );
extern char *cgets( char *s );
extern void clreol( void );
extern void clrscr( void );
extern int  cprintf( const char *format, ... );
extern int  cputs( const char *str );
extern int  cscanf( char *format, ... );
extern void _setcursortype( unsigned type );
extern void delline( void );
extern int  getch( void );
extern int  getche( void );
extern char *getpass( const char *prompt );
extern int  gettext( int left, int top, int right, int bottom, void *dest );
extern void gettextinfo( struct text_info *t );
extern void gotoxy( int x, int y );
extern void highvideo( void );
extern void insline( void );
extern int  kbhit( void );
extern void lowvideo( void );
extern int  movetext( int l, int top, int r, int bottom, int dl, int dt );
extern void normvideo( void );
extern int  putch( int ch );
extern int  puttext( int left, int top, int right, int bottom, void *dest );
extern void textattr( int newattr );
extern void textbackground( int newattr );
extern void textcolor( int newattr );
extern void textmode( int mode );
extern int  ungetch( int ch );
extern int  vcprintf( const char *format, va_list args );
extern int  wherex( void );
extern int  wherey( void );
extern void window( int left, int top, int right, int bottom );

#define _NOCURSOR     3
#define _HALFCURSOR   2
#define _NORMALCURSOR 0
#define _SOLIDCURSOR  1

typedef enum {
    LASTMODE = -1,
    BW40 = 0,
    CO40 = 1,
    BW80 = 2,
    CO80 = 3,
    MONO = 7,
    C4350 = 64
} text_modes;

enum COLORS {
    BLACK,
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};

#define BLINK 128

#endif

