#include <dirent.h>
#include <stdlib.h>
#include <string.h>

int scandir( char *name, struct dirent ***list,
             int ( *selector )( const struct dirent *dent ),
             int ( *sorter )( const void *m1, const void *m2 ) )
{
    register struct dirent **names, *entp;
    register DIR *dirp;
    register int i, size;

    /* Get initial list space and open directory. */
    size = 20; /* Just to start out */
    names = ( struct dirent ** )malloc( size * sizeof names[ 0 ] );
    if( names == NULL ) return( -1 );
    dirp = opendir( name );
    if( dirp == NULL ) return( -1 );

    /* Read entries in the directory. */
    for( i = 0; entp = readdir( dirp ); )
       if( selector == NULL || ( *selector )( entp ) ) {
           /* User wants them all, or he wants this one. */
           if( ++i >= size ) {
               size <<= 1;
               names = ( struct dirent ** )
                       realloc( ( char * )names, size * sizeof names[ 0 ] );
               if( names == NULL ) {
                   closedir( dirp );
                   return( -1 );
               }
           }

           /* Copy the entry. */
           names[ i - 1 ] = ( struct dirent * )malloc( sizeof( DIR ) );
           if( names[ i - 1 ] == NULL ) {
               closedir( dirp );
               return( -1 );
           }
           memcpy( names[ i - 1 ], entp, sizeof( DIR ) );
       }

    /* Close things off. */
    names[ i ] = NULL;
    *list = names;
    closedir( dirp );

    /* Sort? */
    if( i && sorter ) qsort( ( char * )names, i, sizeof( names[ 0 ] ), sorter );

    return( i );
}

