#include <dirent.h>
#include <malloc.h>
#include <errno.h>
#include <string.h>

DIR *opendir( const char *name )
{
    DIR *dirp;
    char tempfilename[ _MAX_PATH ];

    if( ( dirp = malloc( sizeof( DIR ) ) ) == NULL ) {
        errno = ENOMEM;
        return( NULL );
    }

    strcpy( tempfilename, name );

    if( tempfilename[ strlen( tempfilename ) - 1 ] != '\\' )
        strcat( tempfilename, "\\" );
    strcat( tempfilename, "*.*" );

    if( findfirst( tempfilename, dirp, _A_HIDDEN|_A_SYSTEM|_A_SUBDIR ) ) {
        free( dirp );
        errno = ENOENT;
        return( NULL );
    }

    strcpy( dirp->d_fnamused, tempfilename );
    dirp->d_first = 1;
    dirp->d_loc = 0;
    dirp->d_namlen = strlen( dirp->d_name );
    dirp->d_reclen = sizeof( DIR );

    return( dirp );
}

int closedir( DIR *dirp )
{
    if( findclose( dirp ) ) {
        errno = EBADF;
        return( -1 );
    }
    free( dirp );

    return( 0 );
}
