#include <conio.h>
#include "globals.h"

unsigned __getmode( unsigned char *page );
#pragma aux __getmode = \
    "mov ah, 0x0F"      \
    "int 0x10"          \
    "mov [di], bh"      \
    parm [di]           \
    value [ax]          \
    modify [ax bx di];

void __setmode2( void );
#pragma aux __setmode2 =\
    "mov ax, 0x0002"    \
    "int 0x10"          \
    modify [ax];

void __blinkoff( void );
#pragma aux __blinkoff =\
    "mov ax, 0x1003"    \
    "mov bl, 0"         \
    "int 0x10"          \
    modify [ax bx];

unsigned __getlen( void );
#pragma aux __getlen =  \
    "mov ax, 0x1130"    \
    "mov bh, 0"         \
    "mov dx, 0"         \
    "int 0x10"          \
    "add dx, 1"         \
    value [dx]          \
    modify [ax bx dx];

unsigned char __testvga( void );
#pragma aux __testvga = \
    "mov ax, 0x1200"    \
    "mov bl, 0x32"      \
    "int 0x10"          \
    value [al]          \
    modify [ax bx];

unsigned char __testega( void );
#pragma aux __testega = \
    "mov ah, 0x12"      \
    "mov bl, 0x10"      \
    "int 0x10"          \
    value [bl]          \
    modify [ax bx];

unsigned char __testmda( void );
#pragma aux __testmda = \
    "mov ah, 0x0F"      \
    "int 0x10"          \
    value [al]          \
    modify [ax];

static int __getadapter( void )
{
    if( __testvga() == 0x12 ) return( VGA );
    if( __testega() < 4     ) return( EGA );
    if( __testmda() == 7    ) return( MDA );
    return( CGA );
}

void __initialize_conio( void )
{
    unsigned char page;
    register int mode = __getmode( &__cur_page );
    __putch( '1' );
    __cur_mode = mode & 0xFF;
    __vidtype = __getadapter();
    __putch( '2' );
    __conio_initialized = 1;

    switch( __cur_mode ) {
        case 0:
        case 1:
        case 2:
        case 3:
        case 7:
            break;
        default:
            __setmode2();
            mode = __getmode( &__cur_page );
            __cur_mode = mode & 0xFF;
    }

    __putch( '3' );
    __startx = __starty = 0;
    __baseadr = ( __cur_mode == 7 ) ? 0xB000 : 0xB800;
    __width = ( int )( mode << 8 );
    __curx = wherex();
    __cury = wherey();
    __blinkoff();
    __length = __getlen();
    __putch( '4' );

    if( __length == 1 ) __length = 25;

    __orgmode = __vidmode = __length;
    __startx = __starty = 0;
    __endy = __screenheight = __length - 1;
    __endx = __screenwidth = __width - 1;
}
