{
 * Copyright (c) 2000-2003 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this
 * file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY of ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES of MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 }

{
 * This file is automatically generated
 * DO NOT EDIT!
 }

{
 * Note: For Cocoa/Obj-C/Foundation programs accessing these preference
 *       keys you may want to consider the following:
 *
 *       #define SC_SCHEMA_DECLARATION(x)		extern NSString * x
 *       #import <SystemConfiguration/SystemConfiguration.h>
 }
{	  Pascal Translation:  Peter N Lewis, <peter@stairways.com.au>, 2004 }


{
    Modified for use with Free Pascal
    Version 200
    Please report any bugs to <gpc@microbizz.nl>
}

{$mode macpas}
{$packenum 1}
{$macro on}
{$inline on}
{$CALLING MWPASCAL}

unit SCSchemaDefinitions;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0342}
{$setc GAP_INTERFACES_VERSION := $0200}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}

{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
{$elsec}
	{$error Neither __ppc__ nor __i386__ is defined.}
{$endc}
{$setc TARGET_CPU_PPC_64 := FALSE}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_MAC := TRUE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
uses MacTypes,CFBase;
{$ALIGN MAC68K}

{
 * Reserved Keys
 }
var kSCResvLink: CFStringRef; external name '_kSCResvLink'; (* attribute const *)                             { CFString          "__LINK__"                     }
var kSCResvInactive: CFStringRef; external name '_kSCResvInactive'; (* attribute const *)                         {                   "__INACTIVE__"                 }

{
 * Generic Keys
 }
var kSCPropInterfaceName: CFStringRef; external name '_kSCPropInterfaceName'; (* attribute const *)                    { CFString          "InterfaceName"                }
var kSCPropMACAddress: CFStringRef; external name '_kSCPropMACAddress'; (* attribute const *)                       { CFString          "MACAddress"                   }
var kSCPropUserDefinedName: CFStringRef; external name '_kSCPropUserDefinedName'; (* attribute const *)                  { CFString          "UserDefinedName"              }
var kSCPropVersion: CFStringRef; external name '_kSCPropVersion'; (* attribute const *)                          { CFString          "Version"                      }

{
 * Preference Keys
 }
var kSCPrefCurrentSet: CFStringRef; external name '_kSCPrefCurrentSet'; (* attribute const *)                       { CFString          "CurrentSet"                   }
var kSCPrefNetworkServices: CFStringRef; external name '_kSCPrefNetworkServices'; (* attribute const *)                  { CFDictionary      "NetworkServices"              }
var kSCPrefSets: CFStringRef; external name '_kSCPrefSets'; (* attribute const *)                             { CFDictionary      "Sets"                         }
var kSCPrefSystem: CFStringRef; external name '_kSCPrefSystem'; (* attribute const *)                           { CFDictionary      "System"                       }

{
 * Component Keys
 }
var kSCCompNetwork: CFStringRef; external name '_kSCCompNetwork'; (* attribute const *)                          {                   "Network"                      }
var kSCCompService: CFStringRef; external name '_kSCCompService'; (* attribute const *)                          {                   "Service"                      }
var kSCCompGlobal: CFStringRef; external name '_kSCCompGlobal'; (* attribute const *)                           {                   "Global"                       }
var kSCCompHostNames: CFStringRef; external name '_kSCCompHostNames'; (* attribute const *)                        {                   "HostNames"                    }
var kSCCompInterface: CFStringRef; external name '_kSCCompInterface'; (* attribute const *)                        {                   "Interface"                    }
var kSCCompSystem: CFStringRef; external name '_kSCCompSystem'; (* attribute const *)                           {                   "System"                       }
var kSCCompUsers: CFStringRef; external name '_kSCCompUsers'; (* attribute const *)                            {                   "Users"                        }

{
 * Regex key which matches any component
 }
var kSCCompAnyRegex: CFStringRef; external name '_kSCCompAnyRegex'; (* attribute const *)                         {                   "[^/]+"                        }

{
 * Network Entity Keys
 }
var kSCEntNetAirPort: CFStringRef; external name '_kSCEntNetAirPort'; (* attribute const *)                        { CFDictionary      "AirPort"                      }
var kSCEntNetAppleTalk: CFStringRef; external name '_kSCEntNetAppleTalk'; (* attribute const *)                      { CFDictionary      "AppleTalk"                    }
var kSCEntNetDHCP: CFStringRef; external name '_kSCEntNetDHCP'; (* attribute const *)                           { CFDictionary      "DHCP"                         }
var kSCEntNetDNS: CFStringRef; external name '_kSCEntNetDNS'; (* attribute const *)                            { CFDictionary      "DNS"                          }
var kSCEntNetEthernet: CFStringRef; external name '_kSCEntNetEthernet'; (* attribute const *)                       { CFDictionary      "Ethernet"                     }
var kSCEntNetFireWire: CFStringRef; external name '_kSCEntNetFireWire'; (* attribute const *)                       { CFDictionary      "FireWire"                     }
var kSCEntNetInterface: CFStringRef; external name '_kSCEntNetInterface'; (* attribute const *)                      { CFDictionary      "Interface"                    }
var kSCEntNetIPv4: CFStringRef; external name '_kSCEntNetIPv4'; (* attribute const *)                           { CFDictionary      "IPv4"                         }
var kSCEntNetIPv6: CFStringRef; external name '_kSCEntNetIPv6'; (* attribute const *)                           { CFDictionary      "IPv6"                         }
var kSCEntNetL2TP: CFStringRef; external name '_kSCEntNetL2TP'; (* attribute const *)                           { CFDictionary      "L2TP"                         }
var kSCEntNetLink: CFStringRef; external name '_kSCEntNetLink'; (* attribute const *)                           { CFDictionary      "Link"                         }
var kSCEntNetModem: CFStringRef; external name '_kSCEntNetModem'; (* attribute const *)                          { CFDictionary      "Modem"                        }
var kSCEntNetNetInfo: CFStringRef; external name '_kSCEntNetNetInfo'; (* attribute const *)                        { CFDictionary      "NetInfo"                      }
// extern const CFStringRef kSCEntNetNIS;                         { RESERVED FOR FUTURE USE }
var kSCEntNetPPP: CFStringRef; external name '_kSCEntNetPPP'; (* attribute const *)                            { CFDictionary      "PPP"                          }
var kSCEntNetPPPoE: CFStringRef; external name '_kSCEntNetPPPoE'; (* attribute const *)                          { CFDictionary      "PPPoE"                        }
var kSCEntNetPPPSerial: CFStringRef; external name '_kSCEntNetPPPSerial'; (* attribute const *)                      { CFDictionary      "PPPSerial"                    }
var kSCEntNetPPTP: CFStringRef; external name '_kSCEntNetPPTP'; (* attribute const *)                           { CFDictionary      "PPTP"                         }
var kSCEntNetProxies: CFStringRef; external name '_kSCEntNetProxies'; (* attribute const *)                        { CFDictionary      "Proxies"                      }
var kSCEntNet6to4: CFStringRef; external name '_kSCEntNet6to4'; (* attribute const *)                           { CFDictionary      "6to4"                         }

{
 * kSCCompNetwork Properties
 }
var kSCPropNetOverridePrimary: CFStringRef; external name '_kSCPropNetOverridePrimary'; (* attribute const *)               { CFNumber (0 or 1) "OverridePrimary"              }
var kSCPropNetServiceOrder: CFStringRef; external name '_kSCPropNetServiceOrder'; (* attribute const *)                  { CFArray[CFString] "ServiceOrder"                 }
var kSCPropNetPPPOverridePrimary: CFStringRef; external name '_kSCPropNetPPPOverridePrimary'; (* attribute const *)            { CFNumber (0 or 1) "PPPOverridePrimary"           }

{
 * kSCCompNetworkInterface Properties
 }
var kSCPropNetInterfaces: CFStringRef; external name '_kSCPropNetInterfaces'; (* attribute const *)                    { CFArray[CFString] "Interfaces"                   }

{
 * kSCCompNetworkHostNames Properties
 }
var kSCPropNetLocalHostName: CFStringRef; external name '_kSCPropNetLocalHostName'; (* attribute const *)                 { CFString          "LocalHostName"                }

{
 * kSCEntNetAirPort (Hardware) Entity Keys
 }
var kSCPropNetAirPortAllowNetCreation: CFStringRef; external name '_kSCPropNetAirPortAllowNetCreation'; (* attribute const *)       { CFNumber (0 or 1) "AllowNetCreation"             }
var kSCPropNetAirPortAuthPassword: CFStringRef; external name '_kSCPropNetAirPortAuthPassword'; (* attribute const *)           { CFData            "AuthPassword"                 }
var kSCPropNetAirPortAuthPasswordEncryption: CFStringRef; external name '_kSCPropNetAirPortAuthPasswordEncryption'; (* attribute const *) { CFString          "AuthPasswordEncryption"       }
var kSCPropNetAirPortJoinMode: CFStringRef; external name '_kSCPropNetAirPortJoinMode'; (* attribute const *)               { CFString          "JoinMode"                     }
var kSCPropNetAirPortPowerEnabled: CFStringRef; external name '_kSCPropNetAirPortPowerEnabled'; (* attribute const *)           { CFNumber (0 or 1) "PowerEnabled"                 }
var kSCPropNetAirPortPreferredNetwork: CFStringRef; external name '_kSCPropNetAirPortPreferredNetwork'; (* attribute const *)       { CFString          "PreferredNetwork"             }
var kSCPropNetAirPortSavePasswords: CFStringRef; external name '_kSCPropNetAirPortSavePasswords'; (* attribute const *)          { CFNumber (0 or 1) "SavePasswords"                }

{ kSCPropNetAirPortJoinMode values }
var kSCValNetAirPortJoinModeAutomatic: CFStringRef; external name '_kSCValNetAirPortJoinModeAutomatic'; (* attribute const *)       {                   "Automatic"                    }
var kSCValNetAirPortJoinModePreferred: CFStringRef; external name '_kSCValNetAirPortJoinModePreferred'; (* attribute const *)       {                   "Preferred"                    }
var kSCValNetAirPortJoinModeRecent: CFStringRef; external name '_kSCValNetAirPortJoinModeRecent'; (* attribute const *)          {                   "Recent"                       }
var kSCValNetAirPortJoinModeStrongest: CFStringRef; external name '_kSCValNetAirPortJoinModeStrongest'; (* attribute const *)       {                   "Strongest"                    }

{ kSCPropNetAirPortPasswordEncryption values }
var kSCValNetAirPortAuthPasswordEncryptionKeychain: CFStringRef; external name '_kSCValNetAirPortAuthPasswordEncryptionKeychain'; (* attribute const *) {                   "Keychain"                     }

{
 * kSCEntNetAppleTalk Entity Keys
 }
var kSCPropNetAppleTalkComputerName: CFStringRef; external name '_kSCPropNetAppleTalkComputerName'; (* attribute const *)         { CFString          "ComputerName"                 }
var kSCPropNetAppleTalkComputerNameEncoding: CFStringRef; external name '_kSCPropNetAppleTalkComputerNameEncoding'; (* attribute const *) { CFNumber          "ComputerNameEncoding"         }
var kSCPropNetAppleTalkConfigMethod: CFStringRef; external name '_kSCPropNetAppleTalkConfigMethod'; (* attribute const *)         { CFString          "ConfigMethod"                 }
var kSCPropNetAppleTalkDefaultZone: CFStringRef; external name '_kSCPropNetAppleTalkDefaultZone'; (* attribute const *)          { CFString          "DefaultZone"                  }
var kSCPropNetAppleTalkNetworkID: CFStringRef; external name '_kSCPropNetAppleTalkNetworkID'; (* attribute const *)            { CFNumber          "NetworkID"                    }
var kSCPropNetAppleTalkNetworkRange: CFStringRef; external name '_kSCPropNetAppleTalkNetworkRange'; (* attribute const *)         { CFArray[CFNumber] "NetworkRange"                 }
var kSCPropNetAppleTalkNodeID: CFStringRef; external name '_kSCPropNetAppleTalkNodeID'; (* attribute const *)               { CFNumber          "NodeID"                       }
var kSCPropNetAppleTalkSeedNetworkRange: CFStringRef; external name '_kSCPropNetAppleTalkSeedNetworkRange'; (* attribute const *)     { CFArray[CFNumber] "SeedNetworkRange"             }
var kSCPropNetAppleTalkSeedZones: CFStringRef; external name '_kSCPropNetAppleTalkSeedZones'; (* attribute const *)            { CFArray[CFString] "SeedZones"                    }

{ kSCPropNetAppleTalkConfigMethod values }
var kSCValNetAppleTalkConfigMethodNode: CFStringRef; external name '_kSCValNetAppleTalkConfigMethodNode'; (* attribute const *)      {                   "Node"                         }
var kSCValNetAppleTalkConfigMethodRouter: CFStringRef; external name '_kSCValNetAppleTalkConfigMethodRouter'; (* attribute const *)    {                   "Router"                       }
var kSCValNetAppleTalkConfigMethodSeedRouter: CFStringRef; external name '_kSCValNetAppleTalkConfigMethodSeedRouter'; (* attribute const *) {                   "SeedRouter"                   }

{
 * kSCEntNetDNS Entity Keys
 }
var kSCPropNetDNSDomainName: CFStringRef; external name '_kSCPropNetDNSDomainName'; (* attribute const *)                 { CFString          "DomainName"                   }
var kSCPropNetDNSSearchDomains: CFStringRef; external name '_kSCPropNetDNSSearchDomains'; (* attribute const *)              { CFArray[CFString] "SearchDomains"                }
var kSCPropNetDNSServerAddresses: CFStringRef; external name '_kSCPropNetDNSServerAddresses'; (* attribute const *)            { CFArray[CFString] "ServerAddresses"              }
var kSCPropNetDNSSortList: CFStringRef; external name '_kSCPropNetDNSSortList'; (* attribute const *)                   { CFArray[CFString] "SortList"                     }

{
 * kSCEntNetEthernet (Hardware) Entity Keys
 }
var kSCPropNetEthernetMediaSubType: CFStringRef; external name '_kSCPropNetEthernetMediaSubType'; (* attribute const *)          { CFString          "MediaSubType"                 }
var kSCPropNetEthernetMediaOptions: CFStringRef; external name '_kSCPropNetEthernetMediaOptions'; (* attribute const *)          { CFArray[CFString] "MediaOptions"                 }
var kSCPropNetEthernetMTU: CFStringRef; external name '_kSCPropNetEthernetMTU'; (* attribute const *)                   { CFNumber          "MTU"                          }

{
 * kSCEntNetFireWire (Hardware) Entity Keys
 }
{ RESERVED FOR FUTURE USE }

{
 * kSCEntNetInterface Entity Keys
 }
var kSCPropNetInterfaceDeviceName: CFStringRef; external name '_kSCPropNetInterfaceDeviceName'; (* attribute const *)           { CFString          "DeviceName"                   }
var kSCPropNetInterfaceHardware: CFStringRef; external name '_kSCPropNetInterfaceHardware'; (* attribute const *)             { CFString          "Hardware"                     }
var kSCPropNetInterfaceType: CFStringRef; external name '_kSCPropNetInterfaceType'; (* attribute const *)                 { CFString          "Type"                         }
var kSCPropNetInterfaceSubType: CFStringRef; external name '_kSCPropNetInterfaceSubType'; (* attribute const *)              { CFString          "SubType"                      }
var kSCPropNetInterfaceSupportsModemOnHold: CFStringRef; external name '_kSCPropNetInterfaceSupportsModemOnHold'; (* attribute const *)  { CFNumber (0 or 1) "SupportsModemOnHold"          }

{ kSCPropNetInterfaceType values }
var kSCValNetInterfaceTypeEthernet: CFStringRef; external name '_kSCValNetInterfaceTypeEthernet'; (* attribute const *)          {                   "Ethernet"                     }
var kSCValNetInterfaceTypeFireWire: CFStringRef; external name '_kSCValNetInterfaceTypeFireWire'; (* attribute const *)          {                   "FireWire"                     }
var kSCValNetInterfaceTypePPP: CFStringRef; external name '_kSCValNetInterfaceTypePPP'; (* attribute const *)               {                   "PPP"                          }
var kSCValNetInterfaceType6to4: CFStringRef; external name '_kSCValNetInterfaceType6to4'; (* attribute const *)              {                   "6to4"                         }

{ kSCPropNetServiceSubType values (for PPP) }
var kSCValNetInterfaceSubTypePPPoE: CFStringRef; external name '_kSCValNetInterfaceSubTypePPPoE'; (* attribute const *)          {                   "PPPoE"                        }
var kSCValNetInterfaceSubTypePPPSerial: CFStringRef; external name '_kSCValNetInterfaceSubTypePPPSerial'; (* attribute const *)      {                   "PPPSerial"                    }
var kSCValNetInterfaceSubTypePPTP: CFStringRef; external name '_kSCValNetInterfaceSubTypePPTP'; (* attribute const *)           {                   "PPTP"                         }
var kSCValNetInterfaceSubTypeL2TP: CFStringRef; external name '_kSCValNetInterfaceSubTypeL2TP'; (* attribute const *)           {                   "L2TP"                         }

{
 * kSCEntNetIPv4 Entity Keys
 }
var kSCPropNetIPv4Addresses: CFStringRef; external name '_kSCPropNetIPv4Addresses'; (* attribute const *)                 { CFArray[CFString] "Addresses"                    }
var kSCPropNetIPv4ConfigMethod: CFStringRef; external name '_kSCPropNetIPv4ConfigMethod'; (* attribute const *)              { CFString          "ConfigMethod"                 }
var kSCPropNetIPv4DHCPClientID: CFStringRef; external name '_kSCPropNetIPv4DHCPClientID'; (* attribute const *)              { CFString          "DHCPClientID"                 }
var kSCPropNetIPv4Router: CFStringRef; external name '_kSCPropNetIPv4Router'; (* attribute const *)                    { CFString          "Router"                       }
var kSCPropNetIPv4SubnetMasks: CFStringRef; external name '_kSCPropNetIPv4SubnetMasks'; (* attribute const *)               { CFArray[CFString] "SubnetMasks"                  }
var kSCPropNetIPv4DestAddresses: CFStringRef; external name '_kSCPropNetIPv4DestAddresses'; (* attribute const *)             { CFArray[CFString] "DestAddresses"                }
var kSCPropNetIPv4BroadcastAddresses: CFStringRef; external name '_kSCPropNetIPv4BroadcastAddresses'; (* attribute const *)        { CFArray[CFString] "BroadcastAddresses"           }

{ kSCPropNetIPv4ConfigMethod values }
var kSCValNetIPv4ConfigMethodBOOTP: CFStringRef; external name '_kSCValNetIPv4ConfigMethodBOOTP'; (* attribute const *)          {                   "BOOTP"                        }
var kSCValNetIPv4ConfigMethodDHCP: CFStringRef; external name '_kSCValNetIPv4ConfigMethodDHCP'; (* attribute const *)           {                   "DHCP"                         }
var kSCValNetIPv4ConfigMethodINFORM: CFStringRef; external name '_kSCValNetIPv4ConfigMethodINFORM'; (* attribute const *)         {                   "INFORM"                       }
var kSCValNetIPv4ConfigMethodLinkLocal: CFStringRef; external name '_kSCValNetIPv4ConfigMethodLinkLocal'; (* attribute const *)      {                   "LinkLocal"                    }
var kSCValNetIPv4ConfigMethodManual: CFStringRef; external name '_kSCValNetIPv4ConfigMethodManual'; (* attribute const *)         {                   "Manual"                       }
var kSCValNetIPv4ConfigMethodPPP: CFStringRef; external name '_kSCValNetIPv4ConfigMethodPPP'; (* attribute const *)            {                   "PPP"                          }

{
 * kSCEntNetIPv6 Entity Keys
 }
var kSCPropNetIPv6Addresses: CFStringRef; external name '_kSCPropNetIPv6Addresses'; (* attribute const *)                 { CFArray[CFString] "Addresses"                    }
var kSCPropNetIPv6ConfigMethod: CFStringRef; external name '_kSCPropNetIPv6ConfigMethod'; (* attribute const *)              { CFString          "ConfigMethod"                 }
var kSCPropNetIPv6DestAddresses: CFStringRef; external name '_kSCPropNetIPv6DestAddresses'; (* attribute const *)             { CFArray[CFString] "DestAddresses"                }
var kSCPropNetIPv6Flags: CFStringRef; external name '_kSCPropNetIPv6Flags'; (* attribute const *)                     { CFNumber          "Flags"                        }
var kSCPropNetIPv6PrefixLength: CFStringRef; external name '_kSCPropNetIPv6PrefixLength'; (* attribute const *)              { CFArray[CFNumber] "PrefixLength"                 }
var kSCPropNetIPv6Router: CFStringRef; external name '_kSCPropNetIPv6Router'; (* attribute const *)                    { CFString          "Router"                       }

{ kSCPropNetIPv6ConfigMethod values }
var kSCValNetIPv6ConfigMethodAutomatic: CFStringRef; external name '_kSCValNetIPv6ConfigMethodAutomatic'; (* attribute const *)      {                   "Automatic"                    }
var kSCValNetIPv6ConfigMethodManual: CFStringRef; external name '_kSCValNetIPv6ConfigMethodManual'; (* attribute const *)         {                   "Manual"                       }
var kSCValNetIPv6ConfigMethodRouterAdvertisement: CFStringRef; external name '_kSCValNetIPv6ConfigMethodRouterAdvertisement'; (* attribute const *) {                   "RouterAdvertisement"          }
var kSCValNetIPv6ConfigMethod6to4: CFStringRef; external name '_kSCValNetIPv6ConfigMethod6to4'; (* attribute const *)           {                   "6to4"                         }

{
 * kSCEntNet6to4 Entity Keys
 }
var kSCPropNet6to4Relay: CFStringRef; external name '_kSCPropNet6to4Relay'; (* attribute const *)                     { CFString          "Relay"                        }

{
 * kSCEntNetLink Entity Keys
 }
var kSCPropNetLinkActive: CFStringRef; external name '_kSCPropNetLinkActive'; (* attribute const *)                    { CFBoolean         "Active"                       }
var kSCPropNetLinkDetaching: CFStringRef; external name '_kSCPropNetLinkDetaching'; (* attribute const *)                 { CFBoolean         "Detaching"                    }

{
 * kSCEntNetModem (Hardware) Entity Keys
 }
var kSCPropNetModemConnectionScript: CFStringRef; external name '_kSCPropNetModemConnectionScript'; (* attribute const *)         { CFString          "ConnectionScript"             }
var kSCPropNetModemConnectSpeed: CFStringRef; external name '_kSCPropNetModemConnectSpeed'; (* attribute const *)             { CFNumber          "ConnectSpeed"                 }
var kSCPropNetModemDataCompression: CFStringRef; external name '_kSCPropNetModemDataCompression'; (* attribute const *)          { CFNumber (0 or 1) "DataCompression"              }
var kSCPropNetModemDialMode: CFStringRef; external name '_kSCPropNetModemDialMode'; (* attribute const *)                 { CFString          "DialMode"                     }
var kSCPropNetModemErrorCorrection: CFStringRef; external name '_kSCPropNetModemErrorCorrection'; (* attribute const *)          { CFNumber (0 or 1) "ErrorCorrection"              }
var kSCPropNetModemHoldCallWaitingAudibleAlert: CFStringRef; external name '_kSCPropNetModemHoldCallWaitingAudibleAlert'; (* attribute const *) { CFNumber (0 or 1) "HoldCallWaitingAudibleAlert"  }
var kSCPropNetModemHoldDisconnectOnAnswer: CFStringRef; external name '_kSCPropNetModemHoldDisconnectOnAnswer'; (* attribute const *)   { CFNumber (0 or 1) "HoldDisconnectOnAnswer"       }
var kSCPropNetModemHoldEnabled: CFStringRef; external name '_kSCPropNetModemHoldEnabled'; (* attribute const *)              { CFNumber (0 or 1) "HoldEnabled"                  }
var kSCPropNetModemHoldReminder: CFStringRef; external name '_kSCPropNetModemHoldReminder'; (* attribute const *)             { CFNumber (0 or 1) "HoldReminder"                 }
var kSCPropNetModemHoldReminderTime: CFStringRef; external name '_kSCPropNetModemHoldReminderTime'; (* attribute const *)         { CFNumber          "HoldReminderTime"             }
var kSCPropNetModemNote: CFStringRef; external name '_kSCPropNetModemNote'; (* attribute const *)                     { CFString          "Note"                         }
var kSCPropNetModemPulseDial: CFStringRef; external name '_kSCPropNetModemPulseDial'; (* attribute const *)                { CFNumber (0 or 1) "PulseDial"                    }
var kSCPropNetModemSpeaker: CFStringRef; external name '_kSCPropNetModemSpeaker'; (* attribute const *)                  { CFNumber (0 or 1) "Speaker"                      }
var kSCPropNetModemSpeed: CFStringRef; external name '_kSCPropNetModemSpeed'; (* attribute const *)                    { CFNumber          "Speed"                        }

{ kSCPropNetModemDialMode values }
var kSCValNetModemDialModeIgnoreDialTone: CFStringRef; external name '_kSCValNetModemDialModeIgnoreDialTone'; (* attribute const *)    {                   "IgnoreDialTone"               }
var kSCValNetModemDialModeManual: CFStringRef; external name '_kSCValNetModemDialModeManual'; (* attribute const *)            {                   "Manual"                       }
var kSCValNetModemDialModeWaitForDialTone: CFStringRef; external name '_kSCValNetModemDialModeWaitForDialTone'; (* attribute const *)   {                   "WaitForDialTone"              }

{
 * kSCEntNetNetInfo Entity Keys
 }
var kSCPropNetNetInfoBindingMethods: CFStringRef; external name '_kSCPropNetNetInfoBindingMethods'; (* attribute const *)         { CFString          "BindingMethods"               }
var kSCPropNetNetInfoServerAddresses: CFStringRef; external name '_kSCPropNetNetInfoServerAddresses'; (* attribute const *)        { CFArray[CFString] "ServerAddresses"              }
var kSCPropNetNetInfoServerTags: CFStringRef; external name '_kSCPropNetNetInfoServerTags'; (* attribute const *)             { CFArray[CFString] "ServerTags"                   }
var kSCPropNetNetInfoBroadcastServerTag: CFStringRef; external name '_kSCPropNetNetInfoBroadcastServerTag'; (* attribute const *)     { CFString          "BroadcastServerTag"           }

{ kSCPropNetNetInfoBindingMethods values }
var kSCValNetNetInfoBindingMethodsBroadcast: CFStringRef; external name '_kSCValNetNetInfoBindingMethodsBroadcast'; (* attribute const *) {                   "Broadcast"                    }
var kSCValNetNetInfoBindingMethodsDHCP: CFStringRef; external name '_kSCValNetNetInfoBindingMethodsDHCP'; (* attribute const *)      {                   "DHCP"                         }
var kSCValNetNetInfoBindingMethodsManual: CFStringRef; external name '_kSCValNetNetInfoBindingMethodsManual'; (* attribute const *)    {                   "Manual"                       }

{ kSCPropNetNetInfoBroadcastServerTag default value }
var kSCValNetNetInfoDefaultServerTag: CFStringRef; external name '_kSCValNetNetInfoDefaultServerTag'; (* attribute const *)        {                   "network"                      }

{
 * kSCEntNetNIS Entity Keys
 }
{ RESERVED FOR FUTURE USE }

{
 * kSCEntNetPPP Entity Keys
 }
var kSCPropNetPPPACSPEnabled: CFStringRef; external name '_kSCPropNetPPPACSPEnabled'; (* attribute const *)                { CFNumber (0 or 1) "ACSPEnabled"                  }
var kSCPropNetPPPConnectTime: CFStringRef; external name '_kSCPropNetPPPConnectTime'; (* attribute const *)                { CFNumber          "ConnectTime"                  }
var kSCPropNetPPPDeviceLastCause: CFStringRef; external name '_kSCPropNetPPPDeviceLastCause'; (* attribute const *)            { CFNumber          "DeviceLastCause"              }
var kSCPropNetPPPDialOnDemand: CFStringRef; external name '_kSCPropNetPPPDialOnDemand'; (* attribute const *)               { CFNumber (0 or 1) "DialOnDemand"                 }
var kSCPropNetPPPDisconnectOnIdle: CFStringRef; external name '_kSCPropNetPPPDisconnectOnIdle'; (* attribute const *)           { CFNumber (0 or 1) "DisconnectOnIdle"             }
var kSCPropNetPPPDisconnectOnIdleTimer: CFStringRef; external name '_kSCPropNetPPPDisconnectOnIdleTimer'; (* attribute const *)      { CFNumber          "DisconnectOnIdleTimer"        }
var kSCPropNetPPPDisconnectOnLogout: CFStringRef; external name '_kSCPropNetPPPDisconnectOnLogout'; (* attribute const *)         { CFNumber (0 or 1) "DisconnectOnLogout"           }
var kSCPropNetPPPDisconnectOnSleep: CFStringRef; external name '_kSCPropNetPPPDisconnectOnSleep'; (* attribute const *)          { CFNumber (0 or 1) "DisconnectOnSleep"            }
var kSCPropNetPPPDisconnectTime: CFStringRef; external name '_kSCPropNetPPPDisconnectTime'; (* attribute const *)             { CFNumber          "DisconnectTime"               }
var kSCPropNetPPPIdleReminderTimer: CFStringRef; external name '_kSCPropNetPPPIdleReminderTimer'; (* attribute const *)          { CFNumber          "IdleReminderTimer"            }
var kSCPropNetPPPIdleReminder: CFStringRef; external name '_kSCPropNetPPPIdleReminder'; (* attribute const *)               { CFNumber (0 or 1) "IdleReminder"                 }
var kSCPropNetPPPLastCause: CFStringRef; external name '_kSCPropNetPPPLastCause'; (* attribute const *)                  { CFNumber          "LastCause"                    }
var kSCPropNetPPPLogfile: CFStringRef; external name '_kSCPropNetPPPLogfile'; (* attribute const *)                    { CFString          "Logfile"                      }
var kSCPropNetPPPPlugins: CFStringRef; external name '_kSCPropNetPPPPlugins'; (* attribute const *)                    { CFArray[CFString] "Plugins"                      }
var kSCPropNetPPPRetryConnectTime: CFStringRef; external name '_kSCPropNetPPPRetryConnectTime'; (* attribute const *)           { CFNumber          "RetryConnectTime"             }
var kSCPropNetPPPSessionTimer: CFStringRef; external name '_kSCPropNetPPPSessionTimer'; (* attribute const *)               { CFNumber          "SessionTimer"                 }
var kSCPropNetPPPStatus: CFStringRef; external name '_kSCPropNetPPPStatus'; (* attribute const *)                     { CFNumber          "Status"                       }
var kSCPropNetPPPUseSessionTimer: CFStringRef; external name '_kSCPropNetPPPUseSessionTimer'; (* attribute const *)            { CFNumber (0 or 1) "UseSessionTimer"              }
var kSCPropNetPPPVerboseLogging: CFStringRef; external name '_kSCPropNetPPPVerboseLogging'; (* attribute const *)             { CFNumber (0 or 1) "VerboseLogging"               }

{ Auth: }
var kSCPropNetPPPAuthEAPPlugins: CFStringRef; external name '_kSCPropNetPPPAuthEAPPlugins'; (* attribute const *)             { CFArray[CFString] "AuthEAPPlugins"               }
var kSCPropNetPPPAuthName: CFStringRef; external name '_kSCPropNetPPPAuthName'; (* attribute const *)                   { CFString          "AuthName"                     }
var kSCPropNetPPPAuthPassword: CFStringRef; external name '_kSCPropNetPPPAuthPassword'; (* attribute const *)               { CFString          "AuthPassword"                 }
var kSCPropNetPPPAuthPasswordEncryption: CFStringRef; external name '_kSCPropNetPPPAuthPasswordEncryption'; (* attribute const *)     { CFString          "AuthPasswordEncryption"       }
var kSCPropNetPPPAuthPrompt: CFStringRef; external name '_kSCPropNetPPPAuthPrompt'; (* attribute const *)                 { CFString          "AuthPrompt"                   }
var kSCPropNetPPPAuthProtocol: CFStringRef; external name '_kSCPropNetPPPAuthProtocol'; (* attribute const *)               { CFArray[CFString] "AuthProtocol"                 }

{ kSCPropNetPPPAuthPasswordEncryption values }
var kSCValNetPPPAuthPasswordEncryptionKeychain: CFStringRef; external name '_kSCValNetPPPAuthPasswordEncryptionKeychain'; (* attribute const *) {                   "Keychain"                     }

{ kSCPropNetPPPAuthPrompt values }
var kSCValNetPPPAuthPromptBefore: CFStringRef; external name '_kSCValNetPPPAuthPromptBefore'; (* attribute const *)            { CFString          "Before"                       }
var kSCValNetPPPAuthPromptAfter: CFStringRef; external name '_kSCValNetPPPAuthPromptAfter'; (* attribute const *)             { CFString          "After"                        }

{ kSCPropNetPPPAuthProtocol values }
var kSCValNetPPPAuthProtocolCHAP: CFStringRef; external name '_kSCValNetPPPAuthProtocolCHAP'; (* attribute const *)            { CFString          "CHAP"                         }
var kSCValNetPPPAuthProtocolEAP: CFStringRef; external name '_kSCValNetPPPAuthProtocolEAP'; (* attribute const *)             { CFString          "EAP"                          }
var kSCValNetPPPAuthProtocolMSCHAP1: CFStringRef; external name '_kSCValNetPPPAuthProtocolMSCHAP1'; (* attribute const *)         { CFString          "MSCHAP1"                      }
var kSCValNetPPPAuthProtocolMSCHAP2: CFStringRef; external name '_kSCValNetPPPAuthProtocolMSCHAP2'; (* attribute const *)         { CFString          "MSCHAP2"                      }
var kSCValNetPPPAuthProtocolPAP: CFStringRef; external name '_kSCValNetPPPAuthProtocolPAP'; (* attribute const *)             { CFString          "PAP"                          }

{ Comm: }
var kSCPropNetPPPCommAlternateRemoteAddress: CFStringRef; external name '_kSCPropNetPPPCommAlternateRemoteAddress'; (* attribute const *) { CFString          "CommAlternateRemoteAddress"   }
var kSCPropNetPPPCommConnectDelay: CFStringRef; external name '_kSCPropNetPPPCommConnectDelay'; (* attribute const *)           { CFNumber          "CommConnectDelay"             }
var kSCPropNetPPPCommDisplayTerminalWindow: CFStringRef; external name '_kSCPropNetPPPCommDisplayTerminalWindow'; (* attribute const *)  { CFNumber (0 or 1) "CommDisplayTerminalWindow"    }
var kSCPropNetPPPCommRedialCount: CFStringRef; external name '_kSCPropNetPPPCommRedialCount'; (* attribute const *)            { CFNumber          "CommRedialCount"              }
var kSCPropNetPPPCommRedialEnabled: CFStringRef; external name '_kSCPropNetPPPCommRedialEnabled'; (* attribute const *)          { CFNumber (0 or 1) "CommRedialEnabled"            }
var kSCPropNetPPPCommRedialInterval: CFStringRef; external name '_kSCPropNetPPPCommRedialInterval'; (* attribute const *)         { CFNumber          "CommRedialInterval"           }
var kSCPropNetPPPCommRemoteAddress: CFStringRef; external name '_kSCPropNetPPPCommRemoteAddress'; (* attribute const *)          { CFString          "CommRemoteAddress"            }
var kSCPropNetPPPCommTerminalScript: CFStringRef; external name '_kSCPropNetPPPCommTerminalScript'; (* attribute const *)         { CFString          "CommTerminalScript"           }
var kSCPropNetPPPCommUseTerminalScript: CFStringRef; external name '_kSCPropNetPPPCommUseTerminalScript'; (* attribute const *)      { CFNumber (0 or 1) "CommUseTerminalScript"        }

{ CCP: }
var kSCPropNetPPPCCPEnabled: CFStringRef; external name '_kSCPropNetPPPCCPEnabled'; (* attribute const *)                 { CFNumber (0 or 1) "CCPEnabled"                   }

{ IPCP: }
var kSCPropNetPPPIPCPCompressionVJ: CFStringRef; external name '_kSCPropNetPPPIPCPCompressionVJ'; (* attribute const *)          { CFNumber (0 or 1) "IPCPCompressionVJ"            }

{ LCP: }
var kSCPropNetPPPLCPEchoEnabled: CFStringRef; external name '_kSCPropNetPPPLCPEchoEnabled'; (* attribute const *)             { CFNumber (0 or 1) "LCPEchoEnabled"               }
var kSCPropNetPPPLCPEchoFailure: CFStringRef; external name '_kSCPropNetPPPLCPEchoFailure'; (* attribute const *)             { CFNumber          "LCPEchoFailure"               }
var kSCPropNetPPPLCPEchoInterval: CFStringRef; external name '_kSCPropNetPPPLCPEchoInterval'; (* attribute const *)            { CFNumber          "LCPEchoInterval"              }
var kSCPropNetPPPLCPCompressionACField: CFStringRef; external name '_kSCPropNetPPPLCPCompressionACField'; (* attribute const *)      { CFNumber (0 or 1) "LCPCompressionACField"        }
var kSCPropNetPPPLCPCompressionPField: CFStringRef; external name '_kSCPropNetPPPLCPCompressionPField'; (* attribute const *)       { CFNumber (0 or 1) "LCPCompressionPField"         }
var kSCPropNetPPPLCPMRU: CFStringRef; external name '_kSCPropNetPPPLCPMRU'; (* attribute const *)                     { CFNumber          "LCPMRU"                       }
var kSCPropNetPPPLCPMTU: CFStringRef; external name '_kSCPropNetPPPLCPMTU'; (* attribute const *)                     { CFNumber          "LCPMTU"                       }
var kSCPropNetPPPLCPReceiveACCM: CFStringRef; external name '_kSCPropNetPPPLCPReceiveACCM'; (* attribute const *)             { CFNumber          "LCPReceiveACCM"               }
var kSCPropNetPPPLCPTransmitACCM: CFStringRef; external name '_kSCPropNetPPPLCPTransmitACCM'; (* attribute const *)            { CFNumber          "LCPTransmitACCM"              }

{
 * kSCEntNetPPPoE Entity Keys
 }
{ RESERVED FOR FUTURE USE }

{
 * kSCEntNetPPPSerial Entity Keys
 }
{ RESERVED FOR FUTURE USE }

{
 * kSCEntNetPPTP Entity Keys
 }
{ RESERVED FOR FUTURE USE }

{
 * kSCEntNetL2TP Entity Keys
 }
var kSCPropNetL2TPIPSecSharedSecret: CFStringRef; external name '_kSCPropNetL2TPIPSecSharedSecret'; (* attribute const *)         { CFString          "IPSecSharedSecret"            }
var kSCPropNetL2TPIPSecSharedSecretEncryption: CFStringRef; external name '_kSCPropNetL2TPIPSecSharedSecretEncryption'; (* attribute const *) { CFString          "IPSecSharedSecretEncryption"  }
var kSCPropNetL2TPTransport: CFStringRef; external name '_kSCPropNetL2TPTransport'; (* attribute const *)                 { CFString          "Transport"                    }

{ kSCPropNetL2TPIPSecSharedSecretEncryption values }
var kSCValNetL2TPIPSecSharedSecretEncryptionKeychain: CFStringRef; external name '_kSCValNetL2TPIPSecSharedSecretEncryptionKeychain'; (* attribute const *) {                   "Keychain"                     }

{ kSCPropNetL2TPTransport values }
var kSCValNetL2TPTransportIP: CFStringRef; external name '_kSCValNetL2TPTransportIP'; (* attribute const *)                {                   "IP"                           }
var kSCValNetL2TPTransportIPSec: CFStringRef; external name '_kSCValNetL2TPTransportIPSec'; (* attribute const *)             {                   "IPSec"                        }

{
 * kSCEntNetProxies Entity Keys
 }
var kSCPropNetProxiesExceptionsList: CFStringRef; external name '_kSCPropNetProxiesExceptionsList'; (* attribute const *)         { CFArray[CFString] "ExceptionsList"               }
var kSCPropNetProxiesFTPEnable: CFStringRef; external name '_kSCPropNetProxiesFTPEnable'; (* attribute const *)              { CFNumber (0 or 1) "FTPEnable"                    }
var kSCPropNetProxiesFTPPassive: CFStringRef; external name '_kSCPropNetProxiesFTPPassive'; (* attribute const *)             { CFNumber (0 or 1) "FTPPassive"                   }
var kSCPropNetProxiesFTPPort: CFStringRef; external name '_kSCPropNetProxiesFTPPort'; (* attribute const *)                { CFNumber          "FTPPort"                      }
var kSCPropNetProxiesFTPProxy: CFStringRef; external name '_kSCPropNetProxiesFTPProxy'; (* attribute const *)               { CFString          "FTPProxy"                     }
var kSCPropNetProxiesGopherEnable: CFStringRef; external name '_kSCPropNetProxiesGopherEnable'; (* attribute const *)           { CFNumber (0 or 1) "GopherEnable"                 }
var kSCPropNetProxiesGopherPort: CFStringRef; external name '_kSCPropNetProxiesGopherPort'; (* attribute const *)             { CFNumber          "GopherPort"                   }
var kSCPropNetProxiesGopherProxy: CFStringRef; external name '_kSCPropNetProxiesGopherProxy'; (* attribute const *)            { CFString          "GopherProxy"                  }
var kSCPropNetProxiesHTTPEnable: CFStringRef; external name '_kSCPropNetProxiesHTTPEnable'; (* attribute const *)             { CFNumber (0 or 1) "HTTPEnable"                   }
var kSCPropNetProxiesHTTPPort: CFStringRef; external name '_kSCPropNetProxiesHTTPPort'; (* attribute const *)               { CFNumber          "HTTPPort"                     }
var kSCPropNetProxiesHTTPProxy: CFStringRef; external name '_kSCPropNetProxiesHTTPProxy'; (* attribute const *)              { CFString          "HTTPProxy"                    }
var kSCPropNetProxiesHTTPSEnable: CFStringRef; external name '_kSCPropNetProxiesHTTPSEnable'; (* attribute const *)            { CFNumber (0 or 1) "HTTPSEnable"                  }
var kSCPropNetProxiesHTTPSPort: CFStringRef; external name '_kSCPropNetProxiesHTTPSPort'; (* attribute const *)              { CFNumber          "HTTPSPort"                    }
var kSCPropNetProxiesHTTPSProxy: CFStringRef; external name '_kSCPropNetProxiesHTTPSProxy'; (* attribute const *)             { CFString          "HTTPSProxy"                   }
var kSCPropNetProxiesRTSPEnable: CFStringRef; external name '_kSCPropNetProxiesRTSPEnable'; (* attribute const *)             { CFNumber (0 or 1) "RTSPEnable"                   }
var kSCPropNetProxiesRTSPPort: CFStringRef; external name '_kSCPropNetProxiesRTSPPort'; (* attribute const *)               { CFNumber          "RTSPPort"                     }
var kSCPropNetProxiesRTSPProxy: CFStringRef; external name '_kSCPropNetProxiesRTSPProxy'; (* attribute const *)              { CFString          "RTSPProxy"                    }
var kSCPropNetProxiesSOCKSEnable: CFStringRef; external name '_kSCPropNetProxiesSOCKSEnable'; (* attribute const *)            { CFNumber (0 or 1) "SOCKSEnable"                  }
var kSCPropNetProxiesSOCKSPort: CFStringRef; external name '_kSCPropNetProxiesSOCKSPort'; (* attribute const *)              { CFNumber          "SOCKSPort"                    }
var kSCPropNetProxiesSOCKSProxy: CFStringRef; external name '_kSCPropNetProxiesSOCKSProxy'; (* attribute const *)             { CFString          "SOCKSProxy"                   }

{
 kSCCompUsers Entity Keys
 }
var kSCEntUsersConsoleUser: CFStringRef; external name '_kSCEntUsersConsoleUser'; (* attribute const *)                  {                   "ConsoleUser"                  }

{
 * kSCCompSystem Properties
 }
var kSCPropSystemComputerName: CFStringRef; external name '_kSCPropSystemComputerName'; (* attribute const *)               { CFString          "ComputerName"                 }
var kSCPropSystemComputerNameEncoding: CFStringRef; external name '_kSCPropSystemComputerNameEncoding'; (* attribute const *)       { CFNumber          "ComputerNameEncoding"         }

{
 * Configuration Store Definitions
 }
{ domain prefixes }
var kSCDynamicStoreDomainFile: CFStringRef; external name '_kSCDynamicStoreDomainFile'; (* attribute const *)               {                   "File:"                        }
var kSCDynamicStoreDomainPlugin: CFStringRef; external name '_kSCDynamicStoreDomainPlugin'; (* attribute const *)             {                   "Plugin:"                      }
var kSCDynamicStoreDomainSetup: CFStringRef; external name '_kSCDynamicStoreDomainSetup'; (* attribute const *)              {                   "Setup:"                       }
var kSCDynamicStoreDomainState: CFStringRef; external name '_kSCDynamicStoreDomainState'; (* attribute const *)              {                   "State:"                       }
var kSCDynamicStoreDomainPrefs: CFStringRef; external name '_kSCDynamicStoreDomainPrefs'; (* attribute const *)              {                   "Prefs:"                       }

{ kSCDynamicStoreDomainSetup Properties }
var kSCDynamicStorePropSetupCurrentSet: CFStringRef; external name '_kSCDynamicStorePropSetupCurrentSet'; (* attribute const *)      { CFString          "CurrentSet"                   }
var kSCDynamicStorePropSetupLastUpdated: CFStringRef; external name '_kSCDynamicStorePropSetupLastUpdated'; (* attribute const *)     {                   "LastUpdated"                  }

{ Properties }
var kSCDynamicStorePropNetInterfaces: CFStringRef; external name '_kSCDynamicStorePropNetInterfaces'; (* attribute const *)        { CFArray[CFString] "Interfaces"                   }
var kSCDynamicStorePropNetPrimaryInterface: CFStringRef; external name '_kSCDynamicStorePropNetPrimaryInterface'; (* attribute const *)  { CFString          "PrimaryInterface"             }
var kSCDynamicStorePropNetPrimaryService: CFStringRef; external name '_kSCDynamicStorePropNetPrimaryService'; (* attribute const *)    { CFString          "PrimaryService"               }
var kSCDynamicStorePropNetServiceIDs: CFStringRef; external name '_kSCDynamicStorePropNetServiceIDs'; (* attribute const *)        { CFArray[CFString] "ServiceIDs"                   }

{
 * Obsolete schema definitions which will be removed "soon".
 }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kSCPropUsersConsoleUserName CFSTRP('Name')}
{$endc}                            { CFString }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kSCPropUsersConsoleUserUID CFSTRP('UID')}
{$endc}                             { CFNumber }
{$ifc USE_CFSTR_CONSTANT_MACROS}
{$definec kSCPropUsersConsoleUserGID CFSTRP('GID')}
{$endc}                             { CFNumber }

end.
