\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Utilities for finding 
\ CATEGORY    : Standard Programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 11, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -ref


also internal

privates

0 value found?                  private \ anything found?
0 value ref-count               private \ references found
0 value the-word                private \ the word sought?

: found         ( -- )                          \ found the word
        true to found?                                  \ yes!
        1 +to ref-count                                 \ increment counter
        ;  private

: skip-string   ( l-addr1 -- l-addr2 )          \ skip inline string in LSEG
        dup lc@ 1+ aligned +
        ;  private

: search-one    ( l-addr -- )                   \ look in LSEG
        begin   dup cell+ swap l@                       \ fetch xt
                case
                ['] (exit) of   drop exit       endof   \ end of definition
                ['] (postpone) of                       \ special case
                        ['] (postpone) the-word =
                        if      drop found exit
                        then
                        dup l@ the-word =
                        if      drop found exit
                        then
                        cell+   endof
                ['] (tic) of                            \ special case
                        ['] (tic) the-word =
                        if      drop found exit
                        then
                        dup l@ the-word =
                        if      drop found exit
                        then
                        cell+   endof
                ['] modify of                           \ special case
                        ['] modify the-word =           \ looking for me?
                        if      drop found exit
                        then
                        dup l@ ['] docreate u<  \ defined before DOCREATE
                        if      drop exit
                        then
                        cell+   endof
                the-word of                             \ found word?
                        drop found exit endof
                ['] (s") of     cell+           endof
                ['] (c") of     cell+           endof
                ['] (.") of     skip-string     endof
                ['] (abort") of cell+           endof
                endcase
        again                                           \ loop forever
        ;  private

: ((ref))       ( wid -- )                      \ look in wordlist
        local thevoc
        true local new                                  \ not found yet
        thevoc voc@ temporary !                         \ prepare search
        begin   another                                 \ candidate word
        while   clear found?                            \ not found yet
                dup head>                               \ get xt
                dup >call [ ' cold >call ] literal =    \ a vector ?
                if      >body @ dup
                        >call [ ' : >call ] literal =   \ :
                        if      >body @ search-one
                        else    drop
                        then
                else    dup
                        >call [ ' : >call ] literal =   \ :
                        if      >body @ search-one
                        else    drop
                        then
                then
                found?
                if      new clear new                   \ first time
                        if      cr 8 spaces             \ for this wordlist
                                thevoc .vocname cr
                        then
                        .head space space               \ print name
                else    drop
                then
        repeat
        ;  private

\G Find compiled references in colon definitions of addr in all word
\G lists. Display the words where the references occur and the count
\G of the words where the references are found.
: (REF)         ( addr -- )                     \ REF "paren-ref"
        to the-word                                     \ word to lookup
        clear ref-count                                 \ reset counter
        voc-link                                        \ all wordlists
        begin   regular?                                \ only normal wordlists
                if      dup ((ref))                     \ lookup
                then
                @ ?dup 0=                               \ all wordlists done?
        until
        cr ref-count .dec ." reference"                 \ Display total
        ref-count 1 >
        if      's' emit                                \ Plural?
        then
        ."  of: " the-word dup .hex >head ?dup          \ Display address
        if      .head space                             \ Display name
        then
        ." found."
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Find compiled references in colon definitions of name in all word
\G lists. Display the words where the references occur and the count
\G of the words where the references are found.
: REF           ( "name" -- )                   \ REF
        ' (ref)
        ;

deprive

previous
                            \ (* End of Source *) /
