\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Long memory operators
\ CATEGORY    : Memory extensions
\ AUTHOR      : Coos Haak
\ LAST CHANGE : November 07, 1994, Coos Haak
\ ----------------------------------------------------------------------



        ?DEF -paragraphs [IF] -paragraphs [THEN]


        MARKER -paragraphs


\G If u is greater than zero, copy the contents of u consecutive
\G paragraph units at segment x1 to the u consecutive paragraph
\G units its at segment x2. After MOVE completes, the u consecutive
\G paragraph units at x2 contain exactly what the u consecutive
\G paragraph units at x1 contained before the move.
CODE MOVEP              ( x1 x2 u -- )                  \ PARAGRAPHS "move-p"
                XCHG    SP, BP
                PUSH    SI
                PUSH    DS
                PUSH    ES
                XCHG    SP, BP
                MOV     CX, BX
                POP     DX
                POP     BX
                TEST    CX, CX
        > IF
                CMP     BX, DX
        U< IF
                DEC     BX
                DEC     DX
                ADD     BX, CX
                ADD     DX, CX
                STD
        DO
                PUSH    CX
                MOV     CX, # 8
                MOV     SI, # $0E
                MOV     DI, SI
                MOV     DS, BX
                MOV     ES, DX
                REP     MOVSW
                DEC     BX
                DEC     DX
                POP     CX
        LOOP
                CLD
        ELSE
        U> IF
        DO
                PUSH    CX
                MOV     CX, # 8
                XOR     SI, SI
                XOR     DI, DI
                MOV     DS, BX
                MOV     ES, DX
                REP     MOVSW
                INC     BX
                INC     DX
                POP     CX
        LOOP
        THEN
        THEN
        THEN
                XCHG    SP, BP
                POP     ES
                POP     DS
                POP     SI
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE

\G If u is greater than zero, store char in each of u consecutive
\G paragraphs of characters of memory beginning at segment x.
CODE FILLP              ( x u char -- )                 \ PARAGRAPHS "fill-p"
                MOV     AX, BX
                MOV     BX, ES
                POP     CX
                POP     DX
                TEST    CX, CX
        > IF
        DO
                PUSH    CX
                MOV     CX, # $10
                MOV     ES, DX
                XOR     DI, DI
                REP     STOSB
                INC     DX
                POP     CX
        LOOP
        THEN
                MOV     ES, BX
                POP     BX
                NEXT
END-CODE

\G If u is greater than zero, display the character string at
\G paragraph address x for a total of u paragraphs. The characters
\G are displayed as with SEMIT .
: TYPEP         ( x u -- )                  \ PARAGRAPHS "type-paragraphs"
        c/l 5 - #paragraphs 1- 1 max local width 0      \ setup for screen
        ?do     cr dup i paragraphs x.                  \ type extended addr
                dup i paragraphs                        \ address
                width paragraphs stypex                 \ type the string
                stop? ?leave                            \ escape leaves
        width +loop                                     \ next round
        drop                                            \ drop segment
        ;



                            \ (* End of Source *) /
