\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Lempel, Ziv and Welch compression 
\ CATEGORY    : Utilities 
\ AUTHOR      : Lennart Benschop 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -cio

        MARKER -lzw



DOC
   See Vijgeblad 34/35
ENDDOC


create lzw$     ", .lzw"

privates

?def assembler [if]

code cc>bbb
                pop     ax
                mov     dl, ah
                and     dl, # $F
                mov     dh, bh
$if386
                shl     dh, # 4
$else
                mov     cl, # 4
                shl     dh, cl
$then
                or      dl, dh
                xor     dh, dh
                xor     ah, ah
                xor     bh, bh
                push    bx
                push    ax
                mov     bx, dx
                next
end-code  private

code bbb>cc
                mov     dx, bx
                pop     ax
                pop     bx
                mov     bh, bl
                and     bl, # $F
$if386
                shr     bh, # 4
$else
                mov     cl, # 4
                shr     bh, cl
$then
                mov     ah, bl
                mov     bl, dl
                push    ax
                next
end-code  private

[else]

: cc>bbb
        over flip $F and over flip $F and 4 lshift or
        rot $FF and rot $FF and swap rot
    ;  private

: bbb>cc
        swap rot tuck $F and flip or swap 4 rshift flip rot or
    ;  private

[then]

\ Open input file name1, return n1 time, n2 date and ud file size
\ Open output file name2.
: openpack          ( "name1" "name2" -- n1 n2 ud )
        bl word count openr
        lzw$ count bl word append here count openw
    ;  private

\ Open input file name1, return n1 time, n2 date and ud file size
\ Open output file name2.
: openunpack        ( "name1" "name2" -- n1 n2 ud )
        lzw$ count bl word append here count openr
        bl word count openw
    ;  private
        
variable cbuf   private
variable cstate private

: putcode
        cstate @
        if      cbuf @ swap cc>bbb putch putch putch cstate off
        else    cbuf ! cstate on
        then
    ;  private

: getcode
        cstate @
        if      cbuf @ cstate off
        else    getch getch getch bbb>cc cbuf ! cstate on
        then
    ;  private

: flushcode
        cstate @
        if      0 putcode
        then
    ;  private

$700 segment tabseg     private

?def assembler [if]

code pre@
                add     bx, bx
                mov     ds, tabseg
                mov     bx, 0 [bx]
                mov     ax, cs
                mov     ds, ax
                next
end-code  private

code pre!
                add     bx, bx
                mov     ds, tabseg
                pop     0 [bx]
                pop     bx
                mov     ax, cs
                mov     ds, ax
                next
end-code  private

code char@
                mov     ds, tabseg
$if386
                movzx   bx, $2000 [bx]
$else
                mov     bl, $2000 [bx]
                xor     bh, bh
$then
                mov     ax, cs
                mov     ds, ax
                next
end-code  private

code char!
                mov     ds, tabseg
                pop     ax
                mov     $2000 [bx], al
                pop     bx
                mov     ax, cs
                mov     ds, ax
                next
end-code  private

code hash@
                add     bx, bx
                mov     ds, tabseg
                mov     bx, $3000 [bx]
                mov     ax, cs
                mov     ds, ax
                next
end-code  private

code hash!
                add     bx, bx
                mov     ds, tabseg
                pop     $3000 [bx]
                pop     bx
                mov     ax, cs
                mov     ds, ax
                next
end-code  private

code hash
                pop     ax
                add     ax, ax
                xor     bx, ax
                and     bx, # $1FFF
                next
end-code  private

code rehash
$if386
                imul#   bx, bx #113
                add     bx, # #233
$else
                mov     ax, # #113
                mul     bx
                mov     bx, # #233
                add     bx, ax
$then
                and     bx, # $1FFF
                next
end-code  private

[else]

: pre@
        cells tabseg @ swap @x
    ;  private

: pre!
        cells tabseg @ swap !x
    ;  private

: char@
        $2000 + tabseg @ swap c@x
    ;  private

: char!
        $2000 + tabseg @ swap c!x
    ;  private

: hash@
        cells $3000 + tabseg @ swap @x
    ;  private

: hash!
        cells $3000 + tabseg @ swap !x
    ;  private

: hash
        swap 2* xor $1FFF and
    ;  private

: rehash
        #113 * #233 + $1FFF and
    ;  private

[then]

: clear-hash
        tabseg @ $3000 $4000 -1 fillx
    ;  private

: search-str
        2dup local chr local pre hash
        begin   dup>r hash@ dup -1 <>
        while   dup pre@ pre = swap char@ chr = and
                if      r> exit
                then
                r> rehash
        repeat
        drop r>
    ;  private

variable nextcode       private

: clear-tab
        $100 nextcode ! clear-hash $100 0
        do      i -1 i hash hash!
        loop
    ;  private

: init-tab
        $100 0
        do      i i char! -1 i pre!
        loop
        clear-tab
    ;  private

: put
        dup >< putch putch
    ;  private

: get
        getch >< getch or
    ;  private

: putd
        put put
    ;  private

: getd
        get get swap
    ;  private

2variable fsize private

: [pack]
        putd dup put local date dup put local time
        cstate off init-tab true local prefix
        begin   getch dup -1 <>
        while   prefix over search-str dup hash@ -1 <>
                if      hash@ to prefix drop
                else    prefix putcode nextcode @ $1000 <
                        if      nextcode @ swap hash!
                                prefix nextcode @ pre!
                                dup nextcode @ char!
                                nextcode incr
                        else    drop clear-tab
                        then
                        to prefix
                then
        repeat
        drop prefix -1 <>
        if      prefix putcode
        then
        flushcode closer time date closew
    ;

: pack
        >in @
        bl parse-word 2dup '.' scan nip -
        ." Compressing " type 8 out over mod - spaces
        >in !
        openpack [pack]
    ;

variable strptr private

: out-str
        $1000 strptr @
        ?do     pad i + c@ putch
        loop
        fsize 2@ $1000 strptr @ - 0 d- fsize 2!
    ;  private

: form-str
        $1000 strptr !
        begin   dup -1 <>
        while   strptr decr dup char@ pad strptr @ + c! pre@
        repeat
        drop
    ;  private

: ?addcode
        over -1 <>
        if      nextcode @ $1000 <
                if      nextcode @ char! nextcode @ pre! nextcode incr
                else    2drop $100 nextcode !
                then
        else    2drop
        then
    ;  private

: [unpack]
        cstate off init-tab getd fsize 2! get local date get local time
        true local oldcode false local firstchar
        begin   fsize 2@ or
        while   getcode dup nextcode @ <
                if      oldcode >r dup to oldcode form-str out-str
                        pad strptr @ + c@ to firstchar r> firstchar ?addcode
                else    pad strptr @ + dup 1- $1000 strptr @ - cmove
                        firstchar pad $FFF + c! strptr decr
                        out-str oldcode firstchar ?addcode to oldcode
                then
        repeat
        closer time date closew
    ;

: unpack
        >in @
        bl parse-word 2dup '.' scan nip -
        ." Expanding " type 8 out 8 mod - spaces
        >in !
        openunpack 2drop 2drop [unpack]
    ;

privates
                            \ (* End of Source *) /
