\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Disassembler for CHForth and 8086 or 80386 code 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -disassembler


DOC
   SEE    ( "name" -- ) is extended with a disassembler.
   DIS    ( addr -- )   disassembles code in Forth.
   DISX   ( x-addr -- ) disassembles any (far) code.
   GET-INTERRUPT DISX ( n -- ) disassembles an interruptvector.
ENDDOC

warning off

\G Replace the first word list in the search order with the
\G DISASSEMBLER word list.
VOCABULARY DISASSEMBLER         ( -- )                  \ DISASSEMBLER

internal also disassembler definitions also

privates

variable dumpseg  private

?undef assembler [if]

: b>s
        dup #127 > #-128 and or
        ;  private

: 3>>
        3 rshift
        ;  private

: 4>>
        4 rshift
        ;  private

: 5>>
        5 rshift
        ;  private

: 6>>
        6 rshift
        ;  private

[else]

code b>s
$if386
                movsx   bx, bl
$else
                mov     ax, bx
                cbw
                mov     bx, ax
$then
                next
end-code  private

code 3>>
$if386
                shr     bx, # 3
$else
                mov     cl, # 3
                shr     bx, cl
$then
                next
end-code  private

code 4>>
$if386
                shr     bx, # 4
$else
                mov     cl, # 4
                shr     bx, cl
$then
                next
end-code  private

code 5>>
$if386
                shr     bx, # 5
$else
                mov     cl, # 5
                shr     bx, cl
$then
                next
end-code  private

code 6>>
$if386
                shr     bx, # 6
$else
                mov     cl, # 6
                shr     bx, cl
$then
                next
end-code  private

[then]

' and   alias   .and.   private
' or    alias   .or.    private

: t@
        dumpseg @ swap @x
        ;  private

: tc@
        dumpseg @ swap c@x
        ;  private

: komma
        ',' emit
        ;  private

: .far
        ." far "
        ;  private

: ?byte
        1 and 0=
        if      ."  byte"
        then
        ;  private


: >lwc
        dup 'A' [ 'Z' 1+ ] literal within
        if      bl or
        then
        ;  private

: lemit
        >lwc emit
        ;  private

: -.head
        ?dup
        if      (.head) dup
                if      0
                        do      count lemit
                        loop
                        drop
                else    2drop 4 emit
                then
        else    ." {NoName}"
        then
        ;  private

: head.l
        ?at drop swap -.head ?at drop - 8 + spaces
        ;  private

: self.l
        create
        does>   body> >head head.l
        ;  private

: .self
        create
        does>   body> >head -.head
        ;  private

variable pfx    private
variable spfx   private
variable rpfx   private
variable apfx   private

$F2 constant repnz,     private
$F3 constant repz,      private

: (.me&size)
        case rpfx @
                repz, of        ." repz    " endof
                repnz, of       ." repnz   " endof
        endcase
        ?at drop swap -.head swap 1 and
        if      spfx @
                if      'D'
                else    'W'
                then
        else    'B'
        then
        lemit ?at drop - 8 + spaces
        ;  private

: .me
        last @ postpone literal postpone head.l
        ;  private immediate

: .me&size
        last @ postpone literal postpone (.me&size)
        ;  private immediate

variable cp     private

: <.32>
        '$' emit <# # # # # # # # # #> type
        ;  private

: <.16>
        '$' emit u>d <# # # # # #> type
        ;  private

: <.8>
        '$' emit u>d <# # # #> type
        ;  private

: true-address
        cp @ + .hex
        ;  private

: nextb
        cp @ tc@ cp incr
        ;  private

: nextw
        cp @ t@ 2 cp +!
        ;  private

: .na
        ." ???     " <.8>
        ;  private

: .na0
        dup .na
        ;  private

: .na1
        ." ???     " swap join .hex
        ;  private

variable ops    private
variable disp   private

$26 constant es,  private
$2E constant cs,  private
$36 constant ss,  private
$3E constant ds,  private
$64 constant fs,  private
$65 constant gs,  private
$66 constant sz,  private
$67 constant ad,  private

: .pfx
        case pfx @
                es, of  ." es:" endof
                cs, of  ." cs:" endof
                ss, of  ." ss:" endof
                ds, of  ." ds:" endof
                fs, of  ." fs:" endof
                gs, of  ." gs:" endof
        endcase
        ;  private

: ?disp
        dup 6>> ?dup 0=
        if      dup 7 .and. 6 = 2 .and.
        then
        3 of    0       then
        disp !
        ;  private

.self al        .self ax        .self [bx+si    .self es
.self cl        .self cx        .self [bx+di    .self cs
.self dl        .self dx        .self [bp+si    .self ss
.self bl        .self bx        .self [bp+di    .self ds
.self ah        .self sp        .self [si
.self ch        .self bp        .self [di
.self dh        .self si        .self [bp
.self bh        .self di        .self [bx

#cpu @ #386 = [if]
.self fs        .self gs        .self ?s
.self [eax      .self [ecx      .self [edx      .self [ebx
.self [esp      .self [ebp      .self [esi      .self [edi

[then]

: .8reg
        7 &exec:
        al cl dl bl ah ch dh bh
        ;  private

: .16reg
        spfx @
        if      'E' lemit
        then
        7 &exec:
        ax cx dx bx sp bp si di
        ;  private

: eax
        spfx @
        if      'E' lemit
        then
        ax
        ;  private

: -16reg
        7 &exec:
        ax cx dx bx sp bp si di
        ;  private

: .r8/16
        swap 1 &exec:
        .8reg .16reg
        ;  private

: .r/m
        2dup .r8/16
        ;  private

: .reg
        2dup 3>> .r8/16
        ;  private

: bdisp|
        cp @ disp @ + tc@ ops incr
        ;  private

: bdisp
        bdisp| b>s 0 .r
        ;  private

#cpu @ #386 = [if]

: wdisp
        apfx @
        if      cp @ disp @ + dup t@ swap cell+ t@ <.32> 2 ops +!
        else    cp @ disp @ + t@ dumpseg @ cseg =
                if      dup body> >head
                        if      ." adr " body> >head -.head
                        else    <.16>
                        then
                else    <.16>
                then
        then
        2 ops +!
        ;  private

[else]

: wdisp
        cp @ disp @ + t@
        dumpseg @ cseg =
        if      dup body> >head
                if      ." adr " body> >head -.head
                else    <.16>
                then
        else    <.16>
        then
        2 ops +!
        ;  private

[then]

: .disp
        dup 6>> 3 &exec:
        noop bdisp wdisp .r/m
        ; private

: bimm
        bdisp| <.8>
        ;  private

: b>simm
        bdisp| b>s <.16>
        ;  private

#cpu @ #386 = [if]

: wimm
        cp @ disp @ + spfx @
        if      dup t@ swap cell+ t@ <.32> 4
        else    t@ <.16> 2
        then
        ops +!
        ;  private

[else]

' wdisp alias wimm      private

[then]

: .imm
        1 &exec:
        bimm wimm
        ;  private

#cpu @ #386 = [if]

: .[]
        apfx @
        if      7 &exec:
                [eax [ecx [edx [ebx [esp [ebp [esi [edi
        then
        7 &exec:
        [bx+si [bx+di [bp+si [bp+di [si [di [bp [bx
        ;  private

[else]

: .[]
        7 &exec:
        [bx+si [bx+di [bp+si [bp+di [si [di [bp [bx
        ;  private

[then]

: bdisp]
        bdisp| ?dup
        if      push base decimal
                dup b>s s>d dabs <# #s rot $80 and
                if      '-'
                else    '+'
                then    hold #> type
                pop base
        then
        ;  private

#cpu @ #386 = [if]

: .mreg
        .pfx $C0 2dup .and. =
        if      .r/m exit
        then
        apfx @
        if  dup $C7 .and. 5 =
            if      '[' lemit wdisp ']' lemit exit
            then
        else
            dup $C7 .and. 6 =
            if      '[' lemit wdisp ']' lemit exit
            then
        then
        dup .[] dup 6>> 3 and
        case
            0 of    endof
            1 of    bdisp]  endof
            2 of    '+' lemit wdisp endof
            3 of    .na     endof
        endcase
        ']' lemit
        ;  private

[else]

: .mreg
        .pfx $C0 2dup .and. =
        if      .r/m exit
        then
        dup $C7 .and. 6 =
        if      '[' lemit wdisp ']' lemit exit
        then
        dup .[] dup 6>> 3 and
        case
        0 of    endof
        1 of    bdisp]  endof
        2 of    '+' lemit wdisp endof
        3 of    .na     endof
        endcase
        ']' lemit
        ;  private

[then]

#cpu @ #386 = [if]

: .seg
        3>> 7 &exec:
        es cs ss ds fs gs ?s ?s
        ;  private

[else]

: .seg
        3>> 3 &exec:
        es cs ss ds
        ;  private

[then]

: seg:
        .seg ':' lemit
        ;  private

self.l imul

self.l jo       self.l jno      self.l jb       self.l jae
self.l jz       self.l jnz      self.l jbe      self.l ja
self.l js       self.l jns      self.l jpe      self.l jpo
self.l jl       self.l jge      self.l jle      self.l jg

self.l mov

: .br
        $F &exec:
        jo jno jb  jae jz jnz jbe ja
        js jns jpe jpo jl jge jle jg
        ;  private

: .offset
        push base decimal
        <# #s rot 0< if '-' else '+' then hold #> type
        pop base
        ;  private

#cpu @ #386 = [if]

self.l bt       self.l bts      self.l btr      self.l btc
self.l seto     self.l setno    self.l setb     self.l setae
self.l setz     self.l setnz    self.l setbe    self.l seta
self.l sets     self.l setns    self.l setpe    self.l setpo
self.l setl     self.l setge    self.l setle    self.l setg

self.l movzx    self.l movsx
self.l bsf      self.l bsr

self.l push     self.l pop      .self fs        .self gs
self.l lss      self.l lfs      self.l lgs

: .bt
        dup 3>> 3 &exec:
        bt bts btr btc
        ;  private

: .setcc
        $F &exec:
        seto setno setb  setae setz setnz setbe seta
        sets setns setpe setpo setl setge setle setg
        ;  private

: .r32
        'E' lemit 7 &exec:
        ax cx dx bx sp bp si di
        ;  private

self.l sgdt     self.l sidt     self.l lgdt     self.l lidt
self.l smsw     self.l invlpg   self.l lmsw
self.l sldt     self.l str      self.l lldt     self.l ltr
self.l verr     self.l verw

.self cr    .self dr    .self tr

forth

: .dig
        3>> 7 and '0' or emit
        ;

disassembler

: 0f00s
        drop nextb dup $38 .and.
        case
                 0 of    sldt .mreg 2drop endof
                 8 of    str .mreg 2drop endof
                $10 of    lldt .mreg 2drop endof
                $18 of    ltr .mreg 2drop endof
                $20 of    verr .mreg 2drop endof
                $28 of    verw .mreg 2drop endof
                .na1
        endcase
        ;  private

: 0f01s
        drop nextb dup $38 .and.
        case
                 0 of    sgdt .mreg 2drop endof
                 8 of    sidt .mreg 2drop endof
                $10 of    lgdt .mreg 2drop endof
                $18 of    lidt .mreg 2drop endof
                $20 of    smsw .mreg 2drop endof
                $28 of    invlpg .mreg 2drop endof
                $30 of    lmsw .mreg 2drop endof
                $38 of    invlpg .mreg 2drop endof
                .na1
        endcase
        ;  private

: 0f20s
        case
                $20 of  mov nextb dup .r32 komma cr .dig drop endof
                $21 of  mov nextb dup .r32 komma dr .dig drop endof
                $22 of  mov nextb dup cr .dig komma .r32 drop endof
                $23 of  mov nextb dup dr .dig komma .r32 drop endof
                $24 of  mov nextb dup .r32 komma tr .dig drop endof
                $26 of  mov nextb dup tr .dig komma .r32 drop endof
                dup .na1
        endcase
        ;  private

: 0fa0s
        case
                $A0 of  push fs drop    endof
                $A1 of  pop fs drop     endof
                $A3 of  bt nextb .mreg komma .reg 2drop endof
                $A8 of  push gs drop    endof
                $A9 of  pop gs drop     endof
                $AB of  bts nextb .mreg komma .reg 2drop        endof
                $AF of  imul nextb .reg komma .mreg 2drop       endof
                dup .na1
        endcase
        ;  private

: 0fb0s
        case
                $B2 of  lss nextb .reg komma .mreg 2drop        endof
                $B3 of  btr nextb .mreg komma .reg 2drop        endof
                $B4 of  lfs nextb .reg komma .mreg 2drop        endof
                $B5 of  lgs nextb .reg komma .mreg 2drop        endof
                $B6 of  movzx nextb dup 3>> .16reg komma
                        dup $C0 and $C0 =
                        if      .8reg drop
                        else    .mreg 2drop
                        then    endof
                $B7 of  movzx nextb dup 3>> .16reg komma
                        dup $C0 and $C0 =
                        if      -16reg drop
                        else    .mreg 2drop
                        then    endof
                $BA of  nextb .bt .mreg komma ?disp 2drop bimm  endof
                $BB of  btc nextb .mreg komma .reg 2drop        endof
                $BC of  bsf nextb .reg komma .mreg 2drop        endof
                $BD of  bsr nextb .reg komma .mreg 2drop        endof
                $BE of  movsx nextb dup 3>> .16reg komma
                        dup $C0 and $C0 =
                        if      .8reg drop
                        else    .mreg 2drop
                        then    endof
                $BF of  movsx nextb dup 3>> .16reg komma
                        dup $C0 and $C0 =
                        if      -16reg drop
                        else    .mreg 2drop
                        then    endof
                dup .na1
        endcase
        ;  private

: pop
        dup $F =
        if      nextb
                dup 0=
                if      0f00s exit
                then
                dup 1 =
                if      0f01s exit
                then
                dup $F0 and $20 =
                if      0f20s exit
                then
                dup $F0 and $80 =
                if      .br drop nextw true-address exit
                then
                dup $F0 and $90 =
                if      .setcc 0 nextb .mreg drop 2drop exit
                then
                dup $F0 and $A0 =
                if      0fa0s exit
                then
                dup $F0 and $B0 =
                if      0fb0s exit
                then
                .na1 exit
        then
        .me .seg
        ;

[else]

: pop
        dup $F =
        if      .na exit
        then
        .me .seg
        ;

[then]

: push
        .me .seg
        ;

: p/p
        dup 1 &exec:
        push pop
        ;  private

self.l daa      self.l das      self.l aaa      self.l aas

: .adj
        3>> 3 &exec:
        daa das aaa aas
        ;  private

: p/seg
        dup 5>> 1 &exec:
        p/p seg:
        ;  private

: p/adj
        dup 5>> 1 &exec:
        p/p .adj
        ;  private

self.l add      self.l adc      self.l and      self.l xor
self.l or       self.l sbb      self.l sub      self.l cmp

: .al/x
        1 &exec:
        al eax
        ;  private

: .alu
        3>> 7 &exec:
        add or adc sbb and sub xor cmp
        ;  private

: alu
        dup .alu dup 4 .and.
        if      dup .al/x komma .imm exit
        then
        nextb over 2 .and.
        if      .reg komma .mreg
        else    .mreg komma .reg
        then
        2drop
        ;  private

: 00-3f
        dup 7 &exec:
        alu alu alu alu alu alu p/seg p/adj
        ;  private

: .reggp
        create
        does>   body> >head head.l .16reg
        ;  private

.reggp inc      .reggp dec      .reggp push     .reggp pop

: regs
        dup 3>> 3 &exec:
        inc dec push pop
        ;  private

#cpu @ #386 = [if]

self.l pusha    self.l popa     self.l push
self.l fs:      self.l gs:      self.l sz:      self.l ad:
self.l insb     self.l insw     self.l outsb    self.l outsw
self.l arpl     self.l bound

: 60-6f case
        $60 of  pusha   endof
        $61 of  popa    endof
        $62 of  bound nextb dup 3>> .16reg komma .mreg drop     endof
        $63 of  arpl nextb .mreg komma dup 3>> .16reg drop      endof
        $64 of  fs:     endof
        $65 of  gs:     endof
        $66 of  sz:     endof
        $67 of  ad:     endof
        $68 of  push wimm       endof
        $69 of  imul -1 nextb .reg komma .mreg komma
                ?disp drop wimm drop    endof
        $6A of  push b>simm     endof
        $6B of  imul -1 nextb .reg komma .mreg komma
                ?disp drop b>simm drop  endof
        $6C of  insb    endof
        $6D of  insw    endof
        $6E of  outsb   endof
        $6F of  outsw   endof
        .na dup
        endcase
        ;  private

[else]

: 60-6f
        .na
        ;  private

[then]

: (br)
        nextb b>s true-address
        ;  private

: .pfa
        drop cp @ 1+ t@ .hex 3 cp +!
        ;  private
        
: (lbr)
        nextw
        case    dup 3 + cp @ +
                [ ' quit >call 3 + ] literal
                of      ." docolon " .pfa exit
                endof
                [ find-methods dovoc 2 cells + >call 3 + ] literal
                of      ." dodoes " .pfa exit
                endof
                [ find-methods dovar 2 cells + 3 +  ] literal
                of      ." dovariable " .pfa exit
                endof
                [ find-methods doval 2 cells + 3 + ] literal
                of      ." dovalue " .pfa exit
                endof
                [ find-methods docreate 2 cells + 3 + ] literal
                of      ." docreate " drop cp incr exit
                endof
                [ find-methods docon 2 cells + 3 + ] literal
                of      ." doconstant " .pfa exit
                endof
                [ find-methods dovector 2 cells + 3 + ] literal
                of      ." dovector " .pfa cp @ t@ .hex 2 cp +! exit
                endof
                [ find-methods prefix 2 cells + 3 + ] literal
                of      ." doprefix " drop cp incr exit
                then
                [ find-methods domarker 2 cells + 3 + ] literal
                of      ." domarker " drop cp incr exit
                then
                [ find-methods dovoc 2 cells + 3 + ] literal
                of      ." dovoc " drop cp incr exit
                then
                [ find-methods doseg 2 cells + 3 + ] literal
                of      ." dosegment" drop cp incr exit
                endof
        endcase
        true-address
        ;  private

: .branch
        .br (br)
        ;  private

: 40-7f
        dup 4>> 3 &exec:
        regs regs 60-6f .branch
        ;  private

: alu#
        nextb dup .alu .mreg komma ?disp drop dup .imm drop
        ;  private

: .math
        3>> 7 &exec:
        add or adc sbb and sub xor cmp
        ;  private

: 83s
        nextb dup .math .mreg komma ?disp b>simm 2drop
        ;  private

: test
        .me nextb .mreg komma .reg 2drop
        ;

: xchg
        .me nextb .reg komma .mreg 2drop
        ;

self.l lea

: movrm/reg
        mov nextb .mreg komma .reg 2drop
        ;  private

: movd
        mov nextb .reg komma .mreg 2drop
        ;  private

: movs>m
        nextb over $8D =
        if      lea .reg komma .mreg
        else    over $8F =
                if      dup $38 .and.
                        if      .na1 exit
                        then
                        [ ' pop >head ] literal head.l .mreg
[ #cpu @ #386 = ] [if]
                else    dup $38 .and. $28 >
[else]
                else    dup $20 .and.
[then]
                        if      .na1 exit
                        then
                        mov swap 1 .or. tuck 2 .and.
                        if      dup .seg komma .mreg
                        else    .mreg komma dup .seg
                        then
                then
        then
        2drop
        ;  private

: 8movs
        dup 2/ 7 &exec:
        alu# 83s test xchg movrm/reg movd movs>m movs>m
        ;  private

self.l xchg     self.l cbw      self.l cwd      self.l call
self.l wait     self.l pushf    self.l popf     self.l sahf
self.l lahf     self.l test

#cpu @ #386 = [if]
self.l cwde     self.l cdq
[then]

: inter
        .far nextw nextw swap x.
        ;  private

: callinter
        call inter
        ;  private

: xchga
        dup 7 .and.
        if      xchg eax komma .16reg exit
        then
        drop ." nop"
        ;  private

#cpu @ #386 = [if]

: .cbw
        spfx @
        if      cwde
        else    cbw
        then
        ;  private

: .cwd
        spfx @
        if      cdq
        else    cwd
        then
        ;  private

: 98-9f
        7 &exec:
        .cbw .cwd callinter wait pushf popf sahf lahf
        ;  private

[else]

: 98-9f
        7 &exec:
        cbw cwd callinter wait pushf popf sahf lahf
        ;  private

[then]

: 90s
        dup 3>> 1 &exec:
        xchga 98-9f
        ;  private

: mova
        mov dup 2 .and.
        if      .pfx '[' lemit wdisp ." ]," .al/x exit
        then
        .al/x komma .pfx '[' lemit wdisp ']' lemit
        ;  private

: .test
        test dup .al/x komma .imm
        ;  private

: movs
        .me&size .pfx
        ;

: cmps
        .me&size .pfx
        ;

: stos
        .me&size
        ;

: lods
        .me&size .pfx
        ;

: scas
        .me&size
        ;

: a0s
        dup 2/ 7 &exec:
        mova mova movs cmps .test stos lods scas
        ;  private

: mov#
        mov dup 8 .and.
        if      .16reg komma wimm exit
        then
        .8reg komma bimm
        ;  private

: 80-bf
        dup 4>> 3 &exec:
        8movs 90s a0s mov#
        ;  private

self.l les      self.l lds      self.l into     self.l iret

: ret
        .me dup 8 .and.
        if      .far
        then
        1 .and. 0=
        if      wimm
        then
        ;

: .l/l
        1 &exec:
        les lds
        ;  private

: les/lds
        dup .l/l 1 .or. nextb .reg komma .mreg 2drop
        ;  private

: mov#r/m
        nextb dup $38 .and.
        if      .na1 exit
        then
        mov .mreg komma ?disp drop dup .imm drop
        ;  private

: int
        .me 1 .and.
        if      nextb
        else    3
        then
        <.8>
        ;

self.l rol      self.l ror      self.l rcl      self.l rcr
self.l shl      self.l shr      self.l sar

: into/iret
        1 &exec:
        into iret
        ;  private

: .shifts
        3>> 7 &exec:
        rol ror rcl rcr shl shr .na0 sar
        ;  private

: shifts
        dup>r nextb dup 3>> 7 .and. 6 =
        if      -r .na1 exit
        then
        dup .shifts .mreg komma drop 2 .and.
        if      cl
        else    1 0 .r
        then
        r> ?byte
        ;  private

#cpu @ #386 = [if]

: xshifts
        dup>r nextb dup 3>> 7 .and. 6 =
        if      -r .na1 exit
        then
        dup .shifts .mreg komma ?disp 2drop bimm r> ?byte
        ;  private

: enter
        .me nextw <.16> komma nextb <.8>
        ;

.self leave

: e/l
        1 &exec:
        enter leave
        ;  private

[then]

#cpu @ #386 = [if]

: c0s
        dup 2/ 7 &exec:
        xshifts ret les/lds mov#r/m e/l ret int into/iret
        ;  private

[else]

: c0s
        dup 2/ 7 &exec:
        .na ret les/lds mov#r/m .na ret int into/iret
        ;  private

[then]

: aam
        .me nextb <.8> drop
        ;

: aad
        .me nextb <.8> drop
        ;

: xlat
        .me drop .pfx
        ;

: esc
        .me 2dup $38 .and. ( 3>> ) swap 7 .and. ( 8 * ) .or. 0 .r komma .mreg
        ;

: d0s
        dup 8 .and.
        if      nextb esc 2drop exit
        then
        dup 7 &exec:
        shifts shifts shifts shifts aam aad .na xlat
        ;  private

.self loopz     .self loop      .self jcxz      .self loopnz

: .loop
        3 &exec:
        loopnz loopz loop jcxz
        ;  private

: loops
        ?at drop swap .loop apfx @
        if      'D' lemit
        then
        ?at drop - 8 + spaces (br)
        ;  private

self.l in       self.l out      self.l jmp

: io#
        dup 2 .and.
        if      out bimm komma .al/x exit
        then
        in .al/x komma bimm
        ;  private

: iox
        dup 2 .and.
        if      out dx komma .al/x exit
        then
        in .al/x komma dx
        ;  private

: .call
        3 &exec:
        call jmp jmp jmp
        ;  private

: calls
        dup .call dup 2 .and.
        if      dup 1 .and.
                if      (br)
                else    inter
                then
        else    (lbr)
        then
        drop
        ;  private

: e0s
        dup 2/ 2/ 3 &exec:
        loops io# calls iox
        ;  private

: ftest
        test .mreg komma ?disp drop dup .imm drop
        ;  private

self.l not      self.l neg      self.l mul
self.l div      self.l idiv     self.l repz     self.l repnz
self.l lock     self.l hlt      self.l cmc      self.l clc
self.l stc      self.l cli      self.l sti      self.l cld
self.l std      self.l inc      self.l dec      self.l push

: .mul/div
        3>> 3 &exec:
        mul imul div idiv
        ;  private

: mul/div
        dup .mul/div .mreg 2drop
        ;  private

: .not/neg
        3>> 1 &exec:
        not neg
        ;  private

: not/neg
        dup .not/neg .mreg 2drop
        ;  private

: f6-f7s
        nextb dup 3>> 7 &exec:
        ftest   .na1    not/neg not/neg
        mul/div mul/div mul/div mul/div
        ;  private

: .fes
        3>> 1 &exec:
        inc dec
        ;  private

: fes
        dup>r nextb dup 3>> 6 .and.
        if      -r .na1 exit
        then
        dup .fes .mreg 2drop r> ?byte
        ;  private

: .fcall/jmp
        2/ 1 &exec:
        jmp call
        ;  private

: fcall/jmp
        dup 3>> dup .fcall/jmp 1 .and.
        if      .far
        then
        .mreg 2drop
        ;  private

: fpush
        dup 8 .and. 0=
        if      push .mreg 2drop exit
        then
        .na1
        ;  private

: finc
        dup .fes .mreg 2drop
        ;  private

: ffs
        nextb dup 4>> 3 &exec:
        finc fcall/jmp fcall/jmp fpush
        ;  private

: .naf1
        dup tc@ .na
        ;  private

: f0s
        dup $F .and. dup 7 .and. 6 <
        if      nip
        then
        exec:
        lock .naf1 repnz repz hlt cmc f6-f7s f6-f7s
        clc  stc   cli   sti  cld std fes    ffs
        ;  private

: c0-ff
        dup 4>> 3 &exec:
        c0s d0s e0s f0s
        ;  private

: .inst
        dup 6>> exec:
        00-3f 40-7f 80-bf c0-ff
        ;  private

: name?
        dumpseg @ cseg <>
        if      false
        else    cp @ >head 0=
                if      false
                else    cp @ >head true
                then
        then
        ;  private

: prefetch
        case cp @ tc@
            repz,   of  repz,  rpfx ! cp incr recurse   endof
            repnz,  of  repnz, rpfx ! cp incr recurse   endof
            sz,     of  spfx on       cp incr recurse   endof
            ad,     of  apfx on       cp incr recurse   endof
            es,     of  es, pfx !     cp incr recurse   endof
            cs,     of  cs, pfx !     cp incr recurse   endof
            ss,     of  ss, pfx !     cp incr recurse   endof
            ds,     of  ds, pfx !     cp incr recurse   endof
            fs,     of  fs, pfx !     cp incr recurse   endof
            gs,     of  gs, pfx !     cp incr recurse   endof
        endcase
        ;  private

forth

: one-line
        [ extra ] push base hex [ forth ]
        ops off disp off pfx off spfx off rpfx off apfx off name?
        if      cr ." \   " dup .head space space head>flags h@
                dup =ansi .and.
                if      ." ans "
                then
                dup =comp .and.
                if      ." compile-only "
                then
                dup =hidden .and.
                if      ." hidden "
                then
                dup =immediate .and.
                if      ." immediate "
                then
                dup =local .and.
                if      ." local "
                then
                dup =private .and.
                if      ." private "
                then
                drop
        then
        cr dumpseg @ cp @ x. space cp @ prefetch
        pfx @ es, = cp @ tc@ $AD = cp @ 1+ tc@ $FF = cp @ 2 + tc@ $E0 =
        .and. .and. .and.
        if      ." next" 3 cp +!
        else    nextb .inst ops @ cp +!
        then
        ops off disp off #45 htab
        cp @ over - 2dup 0 max bounds
        ?do     i tc@ u>d <# # # #> type
        loop
        #68 htab 0 max bounds
        ?do     i tc@ semit
        loop
        [ extra ] pop base
        ;  private

forth definitions

\G Disassemble from extended address x-addr.
: DISX          ( x-addr -- )                   \ DISASSEMBLER "dis-extended"
        cp ! dumpseg !
        begin   one-line
                key ^[ =
        until
        ;

\G Disassemble from address addr.
: DIS           ( addr -- )                     \ DISASSEMBLER "disassemble"
        cseg swap disx
        ;

deprive

?def decompiler [if]

: see           ( "name" -- )
        ' dup c@ dup $E9 = swap $E8 = or
        if      dup >call [ decompiler ] tab@ nip
                if      (see) exit
                then
        then
        dis
        ;  forth  ans

[else]

: see           ( "name" -- )
        ' dis
        ;  ans

[then]

warning on

previous previous forth definitions

                            \ (* End of Source *) /
