\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Supersieve of Eratosthenes for very big numbers 
\ CATEGORY    : Examples 
\ AUTHOR      : Albert van der Horst 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -bits



        MARKER -horstsie



: dinc
        1. rot d+! ;

: mmod
        >r u>d r@ um/mod drop r> um/mod drop ;

variable ch/l           52 ch/l !
variable ln/p           20 ln/p !
variable pause          pause on
variable top-margin     top-margin off
variable left-margin    left-margin off

5000 constant size

create primes   2200 allot
create sieve    size allot
2variable upper-limit
2variable batch-size
2variable offset

: i,
        invert c, ;

create s-mask hex
        00 c, 01 c, 00 c, 00 c, 00 c, 00 c, 00 c, 02 c, 00 c, 00 c,
        00 c, 04 c, 00 c, 08 c, 00 c, 00 c, 00 c, 10 c, 00 c, 20 c,
        00 c, 00 c, 00 c, 40 c, 00 c, 00 c, 00 c, 00 c, 00 c, 80 c,

create c-mask
        00 i, 01 i, 00 i, 00 i, 00 i, 00 i, 00 i, 02 i, 00 i, 00 i,
        00 i, 04 i, 00 i, 08 i, 00 i, 00 i, 00 i, 10 i, 00 i, 20 i,
        00 i, 00 i, 00 i, 40 i, 00 i, 00 i, 00 i, 00 i, 00 i, 80 i,

: init-t
        sieve size FF fill ;

decimal

: getmask
        30 um/mod swap s-mask + c@ swap sieve + ;

: clear-b
        getmask creset ;

: set-b
        getmask cset ;

: test-b
        getmask c@ and ;

: prime?
        u>d 30 um/mod swap s-mask + c@ swap primes + c@ and ;

variable prime

: eliminate
        swap prime ! 0 30 0
        do      2dup 30 um/mod swap c-mask + c@ tuck $FF <>
                if
                        begin   dup size u<
                        while   2dup sieve + c@ and over sieve + c! prime @ +
                        repeat
                then
                2drop prime @ u>d d+
        loop
        2drop ;

variable c#
variable l#
2variable mils
variable mantissa

: ffeed
        pause @
        if      cr ." Druk op een toets om verder te gaan" key drop
        then
        page cr ." Zeef van Eratosthenes -- priemgetallen kleiner dan "
        upper-limit 2@ d. cr 2 l# ! mantissa on ;

: ?p
        dup l# +! l# @ ln/p @ >
        if      ffeed l# +!
        else    drop
        then ;

: newline
        1 ?p cr mantissa @
        if      mils 2@ 7 d.r
        else    7 spaces
        then
        7 c# ! mantissa off ;

: ?l
        dup c# +! c# @ ch/l @ >
        if      newline c# +!
        else    drop
        then ;

2variable counter

: .pr
        4 ?l space 0 <# # # # #> type counter dinc ;

: init-p
        ffeed newline ;

: *30
        u>d 2dup 2dup d+ d+ 2dup d+ 2dup 2dup d+ 2dup d+ d+ ;

: save-upper-limit
        upper-limit 2! size *30 batch-size 2! ;

: sieve-first-batch
        1. clear-b 1000 7
        do      i s>d test-b
                if      i i i + eliminate
                then
        loop
        sieve primes 2200 cmove ;

: wortel
        2dup 0. d<
        if      2drop -1
        else    -1 1
                do      i u>d d- i u>d d- 1. d- 2dup d0<
                        if      2drop i 1+ leave
                        then
                loop
        then ;

: sieve-next-batch
        batch-size 2@ offset d+! offset 2@ batch-size 2@ d+ wortel 7
        do      i prime?
                if      offset 2@ 1. d- i mmod i swap - 1- i swap eliminate
                then
        2 +loop ;

: print-next-thousand
        1000 0
        do      2dup i s>d d+ test-b
                if      i .pr
                then
        loop
        2drop ;

: list-primes
        save-upper-limit mils d0! counter d0! init-t init-p
        offset d0! sieve-first-batch 2 .pr 3 .pr 5 .pr 0. print-next-thousand
        0.
        begin   1000. d+ 2dup upper-limit 2@ d<
        while   mils dinc mantissa on newline 2dup offset 2@ d- 1000. d+
                batch-size 2@ d>
                if      init-t sieve-next-batch
                then
                2dup offset 2@ d- print-next-thousand
        repeat
        2drop ;

c/l 2 - ch/l !
l/scr 2 - ln/p !
pause on


                            \ (* End of Source *) /
