\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : The VanDerHorst Algorithm 
\ CATEGORY    : Examples 
\ AUTHOR      : Albert van der Horst 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -horst



DOC
   FACTORISE nnnnnnnn
ENDDOC

: doubles
        2* cells ;

: 2array
        create  here swap doubles dup allot erase
        does>   swap doubles + ;

: d<>
        d- or 0<> ;

: ashift.right
        dup 2/ swap 1 and ;

1000 constant max.cijfers

variable eerste.cijfer
variable laatste.cijfer
variable faktor 1 cells allot

max.cijfers 2array getal

: trekaf.cijfer
        dup>r getal 2@ r@ 1- getal 2@ d- 2dup d0<
        if      faktor 2@ d+ -1. r@ 1- getal d+!
        then
        r> getal 2! ;

: trekaf
        eerste.cijfer @ 1+ swap
        do      i trekaf.cijfer
        -1 +loop ;

: horst
        dup eerste.cijfer @ >
        if      dup 1- recurse dup trekaf
        then
        drop ;

: vereenvoudig
        eerste.cijfer @ getal 2@ d0=
        if      1 eerste.cijfer +!
        then ;

: volgende.faktor
        1. faktor d+! laatste.cijfer @ horst vereenvoudig ;

: ascii>binair
        '0' - u>d ;

: linker.nullen.weg
        begin   eerste.cijfer @ laatste.cijfer @ > invert
                eerste.cijfer @ getal 2@ d0= and
        while   1 eerste.cijfer +!
        repeat ;

: lees.getal
        0 eerste.cijfer ! dup 1- laatste.cijfer ! ?dup
        if      0
                do      count ascii>binair i getal 2!
                loop
                drop
        then
        linker.nullen.weg ;

: splits
        swap 4 0
        do      1- >r ashift.right u>d r@ getal 2! r>
        loop
        nip ;

: naar.binair
        10. faktor 2! 6 0
        do      volgende.faktor
        loop
        max.cijfers eerste.cijfer @ laatste.cijfer @
        do      i getal 2@ drop splits
        -1 +loop
        eerste.cijfer ! max.cijfers 1- laatste.cijfer !
        2. faktor 2! linker.nullen.weg ;

: drukaf.laatste
        laatste.cijfer @ getal 2@ ud. ;

: drukaf.laatste2 faktor 2@
        if      ." De laatste faktor is te groot om af te drukken."
        else    eerste.cijfer @ getal 2@ drop um*
                laatste.cijfer @ getal 2@ d+ ud.
        then ;

: laatste.faktor
        eerste.cijfer @ laatste.cijfer @ > invert
        if      eerste.cijfer @ laatste.cijfer @ =
                if      eerste.cijfer @ getal 2@ 1. d<>
                        if      cr ." Faktor: " drukaf.laatste
                        then
                else    cr ." Faktor: " drukaf.laatste2
                then
        then ;

: ontbinden
        lees.getal naar.binair
        begin   eerste.cijfer @ 1+ laatste.cijfer @ <
        while
                begin   laatste.cijfer @ getal 2@ d0=
                while   cr ." Faktor: " faktor 2@ ud. -1 laatste.cijfer +!
                repeat
                volgende.faktor
        repeat
        laatste.faktor ;

: factorise
        bl word count timer-reset ontbinden .elapsed ;



                            \ (* End of Source *) /
