\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Musical test 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -eartrain


DOC
(*
  See Forth Dimensions XII,5 page 24
*)
ENDDOC

statoff

: ?
        '_' emit ;      ' ? is prompt

signon off

10 constant aantal

: nogeens?
        cr ." Nog eens? [J,n]" key >upc 'N' = ;

: crs
        0
        do      cr
        loop ;

: position
        page 10 crs 15 spaces ;

-- Dit heb ik al
: noot
        swap tone ;

-- Europa 1992, niet USA 1492
262 constant c
277 constant cis        ' cis alias des
294 constant d
311 constant dis        ' dis alias es
330 constant e
349 constant f
370 constant fis        ' fis alias ges
392 constant g
415 constant gis        ' gis alias as
440 constant a
466 constant ais        ' ais alias bes
494 constant b

create duration         250 ,

create grondtoon        256 ,

: speel
        grondtoon @ 256 */ duration @ noot ;

: c1
        c speel ;

: cis1
        cis speel ;     ' cis1 alias des1

: d1
        d speel ;

: dis1
        dis speel ;     ' dis1 alias es1

: e1
        e speel ;

: f1
        f speel ;

: fis1
        fis speel ;     ' fis1 alias ges1

: g1
        g speel ;

: gis1
        gis speel ;     ' gis1 alias as1

: a1
        a speel ;

: ais1
        ais speel ;     ' ais1 alias bes1

: b1
        b speel ;

: c2
        c 2* speel ;

: groot
        c1 e1 g1 e1 c1 ;

: klein
        c1 dis1 g1 dis1 c1 ;

: verminderd
        c1 dis1 fis1 dis1 c1 ;

: vermeerderd
        c1 e1 gis1 e1 c1 ;

create drieklanken
        ' groot ,
        ' klein ,
        ' verminderd ,
        ' vermeerderd ,

create grondtonen
        ' c , ' cis , ' d , ' dis , ' e , ' f ,
        ' fis , ' g , ' gis , ' a , ' ais , ' b ,

: wacht
        1000 ms ;

: akkoord
        position 12 choose cells grondtonen + @ dup execute grondtoon !
        4 choose cells drieklanken + @ dup execute wacht
        position swap >head .head space >head .head cr ;

: akkoorden
        cr aantal 0
        do      akkoord nogeens? ?leave
        loop ;

: priem
        c1 c1 ;

: kleine_secunde
        c1 cis1 ;

: grote_secunde
        c1 d1 ;

: kleine_terts
        c1 dis1 ;

: grote_terts
        c1 e1 ;

: reine_kwart
        c1 f1 ;

: vergrote_kwart
        c1 fis1 ;

: reine_kwint
        c1 g1 ;

: kleine_sext
        c1 gis1 ;

: grote_sext
        c1 a1 ;

: klein_septiem
        c1 ais1 ;

: groot_septiem
        c1 b1 ;

: oktaaf
        c1 c2 ;

create ^intervallen
        ' priem ,
        ' kleine_secunde ,
        ' grote_secunde ,
        ' kleine_terts ,
        ' grote_terts ,
        ' reine_kwart ,
        ' vergrote_kwart ,
        ' reine_kwint ,
        ' kleine_sext ,
        ' grote_sext ,
        ' klein_septiem ,
        ' groot_septiem ,
        ' oktaaf ,

: interval
        position 0 cells grondtonen + @ dup execute grondtoon !
        13 choose cells ^intervallen + @ dup execute wacht
        position swap >head .head space >head .head cr ;

: intervallen
        cr aantal 0
        do      page 12 crs interval nogeens? ?leave
        loop ;

: toon+interval
        position 12 choose cells grondtonen + @ dup execute grondtoon !
        13 choose cells ^intervallen + @ dup execute wacht
        position swap >head .head space >head .head cr ;

: tonen+intervallen
        cr aantal 0
        do      toon+interval nogeens? ?leave
        loop ;

: menu
        page 4 crs 10 spaces
        ." A  akkoorden" 2 crs 10 spaces
        ." B  intervallen" 2 crs 10 spaces
        ." C  interval met toonwisseling" 2 crs 10 spaces
        ." D  stop" 3 crs 10 spaces
        ." Maak een keuze druk daarna op <enter>" 2 crs ;

: a
        akkoorden menu ;

: b
        intervallen menu ;

: c
        tonen+intervallen menu ;

internal

: d
        page
        ( bye )                 \ BYE deleted
        ['] (prompt) is prompt
        ;

forth

menu

                            \ (* End of Source *) /
