\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Loops in a text file
\ CATEGORY    : Batch File Enhancer
\ AUTHOR      : Marcel Hendrix 
\ LAST CHANGE : Janauary 2, 1992, Marcel Hendrix 
\ ----------------------------------------------------------------------



        NEEDS -miscutil

        MARKER -textloop

        PRIVATES


DOC
(*
  A simple utility to repeatedly execute a part of a (batch) file.
  See also /examples/misc/ntimes.frt . It uses the potential of SAVE-INPUT
  and RESTORE-PUT to mark a place in the input stream to come back to later. 
  Three words are given: [BEGIN] and [UNTIL] . 

  Example usage:

  [BEGIN]                       
                ( ... )         \ Anything Forth at all
                ?DEF foo        \ Anything that generates a flag, or 
  [UNTIL]                       \ user intervention. Stop on ESC pressed

  The word [AGAIN] is simply  FALSE [UNTIL] .
  The construct loops until the condition is true, or the ESC key is pressed.
  The loop halts if you press any other key.
*)
ENDDOC


-- Duplicate exactly i elements of the top of the stack. 
-- The count i is not included.

: NDUP          DUP 1- >S 0 ?DO  S PICK         \ <ni> .. <n1> <i> --
                          LOOP -S ; PRIVATE     \ -- <ni> .. <n1> <ni> .. <n1> 

: CDUP          DUP 1+ NDUP ;       PRIVATE     \ i*{n} i --- i*{n} i i*{n} i 
: CDROP         0 ?DO DROP LOOP ;   PRIVATE     \ <ni> .. <n1> <i> --- <>


: [BEGIN]       SAVE-INPUT ;                    \ <> --- <ni> .. <n1> <i> 

: [UNTIL]       STOP? ABORT" user interrupt"    \ <ni> .. <n1> <i> --- <> or...
                   IF CDROP EXIT 
                ENDIF
                CDUP RESTORE-INPUT              \  ...  --- <ni> .. <n1> <i> 
                   ABORT" could not restore" ;

: [AGAIN]       FALSE [UNTIL] ;

\ Simulate [WHILE] ... [REPEAT] with [BEGIN] [IF] .. [THEN] [AGAIN]


:ABOUT          CR ." Usage: [BEGIN] <foo> <test> [UNTIL] <bar>" 
                CR ."  or    [BEGIN] <foo> [AGAIN] <bar> " CR
                CR ." Break the loop with the ESC key." ; 

                DEPRIVE
-- Voorbeeldje:

variable xx
100 xx ! cr timer-reset
[BEGIN]
        ?at xx @ 3 .r at-xy
        -1 xx +! xx @ 0=
[UNTIL]
cr .elapsed

s" CHFORTH" environment? [if]
drop
: show-input
        save-input drop local _in local _#tib local _tib
        local _blk local _sid local _line
        push base
        cr _blk
        if      ." Interpreting from block " _blk . _in #64 /
                ." line " dup .
                cr '"' emit _tib swap #64 * + #64 type '"' emit
        else    _sid 0>
                if      ." Interpreting from file " 'name count type
                else    _sid 0<
                        if      ." Interpreting from string"
                        else    ." Interpreting from terminal"
                        then
                then
                cr '"' emit _tib _#tib type '"' emit
        then
        cr
        _sid 1 <
        if      #10 spaces
        else    ." #lines" _line 4 .r
        then
        ."  source-id" _sid 3 .r
        _blk
        if      ."  block" _blk 3 .r
        else    9 spaces
        then
        ."  source " _tib h. _#tib 4 .r
        ."  >in" _in 5 .r space cr
        pop base
        ;

[then]

s" IFORTH" environment? [if]
drop
: show-input
        cr source type
        cr ." Data  : " save-input dup 0 swap
        do      i roll u.
        -1 +loop cr ;

[then]

show-input
                            \ (* End of Source *) /
