\ 4tH library - SHELLSORT - Copyright 2011 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

\ void shell_sort (int *a, int n) {
\    int h, i, j, k;
\    for (h = n; h /= 2;) {
\        for (i = h; i < n; i++) {
\            k = a[i];
\            for (j = i; j >= h && k < a[j - h]; j -= h) {
\                a[j] = a[j - h];
\            }
\            a[j] = k;
\        }
\    }
\ }

[UNDEFINED] sort     [IF]
[UNDEFINED] precedes [IF]
defer precedes                         ( addr addr -- flag )
[THEN]                                 \ compatible with QSORT

: (shell)                              ( a n h -- a n h)
  over >r tuck                         ( a h n h)
  ?do                                  ( a h)
    i swap >r                          ( a j        R: h)
    2dup cells + @ -rot                ( k a j      R: h)
    begin                              ( k a j      R: h)
      dup r@ - dup >r 0< 0=            ( k a j f    R: h j-h)
    while                              ( k a j      R: h j-h)
      -rot over over r@ cells + @      ( j k a k v  R: h j-h)
      precedes >r rot r>               ( k a j f    R: h j-h)
    while                              ( k a j      R: h j-h)
      over r@ cells + @ >r             ( k a j      R: h j-h a[j-h])
      2dup cells + r> swap !           ( k a j      R: h j-h)
      drop r>                          ( k a j'     R: h)
    repeat                             ( k a j      R: h j-h)
[UNDEFINED] 4TH# [IF] then [THEN]
    rot >r 2dup cells +                ( a j a[j]   R: h j-h k)
    r> swap ! r> drop drop r>          ( a h)
  loop r> swap
;
                                       ( a n --)
: sort dup begin 5 11 */ dup while (shell) repeat drop 2drop ;

[DEFINED] 4TH# [IF] hide (shell) [THEN]
[THEN]
