;=============================================================================
; Insight, real-mode debugger for MS DOS / PC DOS / FreeDOS.
; Copyright (c) Victor M. Gamayunov, Sergey Pimenov, 1993, 96, 97, 2002.
; Modifications by Oleg O. Chukaev (2006, 2007).
;-----------------------------------------------------------------------------
; colors.inc
; Constants: colors.
;-----------------------------------------------------------------------------
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
; 02111-1307, USA.
;=============================================================================


;=============================================================================
; Main screen
;-----------------------------------------------------------------------------
atCPUborder		equ	BLACK*16+WHITE
atMainWindow		equ	BLACK*16+LIGHT_GRAY

atCmdNormal		equ	atNormInstr
atCmdSelected		equ	atSelInstr
atBP_and_Cur		equ	atBrkSelInstr
atBreakPoint		equ	atBrkInstr

atNormAddr		equ	BLACK*16+LIGHT_GRAY
atNormOpcode		equ	BLACK*16+GREEN
atNormInstr		equ	BLACK*16+LIGHT_GREEN
atNormNumber		equ	BLACK*16+CYAN
atNormArrow		equ	BLACK*16+WHITE
atNormDisable		equ	BLACK*16+LIGHT_GRAY
                	
atSelAddr		equ	LIGHT_GRAY*16
atSelOpcode		equ	LIGHT_GRAY*16
atSelInstr		equ	LIGHT_GRAY*16
atSelNumber		equ	LIGHT_GRAY*16
atSelArrow		equ	LIGHT_GRAY*16+LIGHT_CYAN
atSelDisable		equ	LIGHT_GRAY*16+DARK_GRAY

atBrkAddr		equ	RED*16+WHITE
atBrkOpcode		equ	RED*16+WHITE
atBrkInstr		equ	RED*16+WHITE
atBrkNumber		equ	RED*16+WHITE
atBrkArrow		equ	RED*16+WHITE
atBrkDisable		equ	RED*16+DARK_GRAY

atBrkDisAddr		equ	RED*16+DARK_GRAY
atBrkDisOpcode		equ	RED*16+DARK_GRAY
atBrkDisInstr		equ	RED*16+DARK_GRAY
atBrkDisNumber		equ	RED*16+DARK_GRAY
atBrkDisArrow		equ	RED*16+WHITE
atBrkDisDisable		equ	RED*16+DARK_GRAY

atBrkSelAddr		equ	MAGENTA*16+WHITE
atBrkSelOpcode		equ	MAGENTA*16+WHITE
atBrkSelInstr		equ	MAGENTA*16+WHITE
atBrkSelNumber		equ	MAGENTA*16+WHITE
atBrkSelArrow		equ	MAGENTA*16+WHITE
atBrkSelDisable		equ	MAGENTA*16+DARK_GRAY

atBrkDSAddr		equ	MAGENTA*16+DARK_GRAY
atBrkDSOpcode		equ	MAGENTA*16+DARK_GRAY
atBrkDSInstr		equ	MAGENTA*16+DARK_GRAY
atBrkDSNumber		equ	MAGENTA*16+DARK_GRAY
atBrkDSArrow		equ	MAGENTA*16+WHITE
atBrkDSDisable		equ	MAGENTA*16+DARK_GRAY

;atCmdNormal		equ	LIGHT_GREEN
;atCmdSelected		equ	LIGHT_GRAY*16
;atBreakPoint		equ	RED*16+WHITE
;atBP&Cur		equ	MAGENTA*16+WHITE

atAsmLine		equ	BLACK*16+WHITE

atTitle			equ	BLACK*16+YELLOW
atCPUName		equ	BLACK*16+CYAN

atCodeMark		equ	BLACK*16+LIGHT_RED

atRegName		equ	BLACK*16+LIGHT_GRAY
atRegValue		equ	BLACK*16+LIGHT_GREEN
atRegNewValue		equ	BLACK*16+LIGHT_CYAN

atFlagValue		equ	BLACK*16+LIGHT_GREEN
atFlagNewValue		equ	BLACK*16+LIGHT_CYAN

atDumpAddr		equ	BLACK*16+LIGHT_GRAY
atDumpValue		equ	BLACK*16+LIGHT_GREEN
atDumpCursor		equ	BLUE*16+WHITE
atDumpZero		equ	BLACK*16+GREEN

atStackName		equ	BLACK*16+LIGHT_GRAY
atStackValue		equ	BLACK*16+LIGHT_GREEN

atMemAddr		equ	BLACK*16+WHITE
atMemValue		equ	BLACK*16+YELLOW

atCurUnasmAddr		equ	BLACK*16+LIGHT_CYAN

atDataWatchMem		equ	BLACK*16+LIGHT_RED

atAssembler		equ	LIGHT_GRAY*16+WHITE
atsAssembler		equ	LIGHT_GRAY*16+WHITE
atBrkAssembler		equ	MAGENTA*16+LIGHT_CYAN
atsBrkAssembler		equ	MAGENTA*16+LIGHT_CYAN

;=============================================================================
; Menu.
;-----------------------------------------------------------------------------
atMenuBorder		equ	LIGHT_GRAY*16+BLACK
atMenuNorm		equ	LIGHT_GRAY*16+BLACK
atMenuNormHot		equ	LIGHT_GRAY*16+RED
atMenuNormDis		equ	LIGHT_GRAY*16+DARK_GRAY
atMenuSel		equ	GREEN*16+BLACK
atMenuSelHot		equ	GREEN*16+RED
atMenuSelDis		equ	GREEN*16+DARK_GRAY

;=============================================================================
; Horizontal menu.
;-----------------------------------------------------------------------------
atHMenuNorm		equ	LIGHT_GRAY*16+BLACK
atHMenuNormHot		equ	LIGHT_GRAY*16+RED
atHMenuSel		equ	GREEN*16+BLACK
atHMenuSelHot		equ	GREEN*16+RED

;=============================================================================
; Input line.
;-----------------------------------------------------------------------------
atInputLine		equ	BLUE*16+WHITE
atsInputLine		equ	GREEN*16+WHITE

;=============================================================================
; Message box / Error box.
;-----------------------------------------------------------------------------
atMessageBox		equ	BLUE*16+WHITE
atMessageBoxTitle	equ	BLUE*16+LIGHT_CYAN
atMessage		equ	BLUE*16+YELLOW

atErrorBox		equ	RED*16+WHITE
atErrorBoxTitle		equ	RED*16+YELLOW
atErrorMsg		equ	RED*16+YELLOW

;=============================================================================
; Dialog windows.
;-----------------------------------------------------------------------------
atDialogWindow		equ	LIGHT_GRAY*16+WHITE
atDialogWindowTitle	equ	LIGHT_GRAY*16+WHITE	;2007-11-17
atShadow		equ	BLACK*16+LIGHT_GRAY

;=============================================================================
; Buttons.
;-----------------------------------------------------------------------------
atPushButton		equ	GREEN*16+BLACK
atlPushButton		equ	GREEN*16+YELLOW
atsPushButton		equ	GREEN*16+WHITE
atlsPushButton		equ	GREEN*16+YELLOW
atPushButtonDef		equ	GREEN*16+BLUE
atlPushButtonDef	equ	GREEN*16+YELLOW
atButtonShadow		equ	LIGHT_GRAY*16+BLACK

;=============================================================================
; Labels.
;-----------------------------------------------------------------------------
atLabel			equ	LIGHT_GRAY*16+BLACK
atlLabel		equ	LIGHT_GRAY*16+YELLOW
atsLabel		equ	LIGHT_GRAY*16+WHITE
atlsLabel		equ	LIGHT_GRAY*16+YELLOW

;=============================================================================
; String list.
;-----------------------------------------------------------------------------
atListNormal		equ	CYAN*16+BLACK
atListSelected		equ	GREEN*16+WHITE
atListDefault		equ	CYAN*16+YELLOW	;2007-11-11

;=============================================================================
; Check boxes.
;-----------------------------------------------------------------------------
atCheckBoxes		equ	CYAN*16+BLACK
atsCheckBoxes		equ	CYAN*16+WHITE
atlCheckBoxes		equ	CYAN*16+YELLOW

;=============================================================================
; Radio buttons.
;-----------------------------------------------------------------------------
atRadioButtons		equ	CYAN*16+BLACK
atsRadioButtons		equ	CYAN*16+WHITE
atlRadioButtons		equ	CYAN*16+YELLOW

;=============================================================================
; E0F
;=============================================================================

