/*
 *  sys/timeb.h     timeb structure used with ftime()
 *
 *                          Open Watcom Project
 *
 *    Copyright (c) 2002-2008 Open Watcom Contributors. All Rights Reserved.
 *    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef __TIMEB_H_INCLUDED
#define __TIMEB_H_INCLUDED
#if !defined(_ENABLE_AUTODEPEND)
  #pragma read_only_file;
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef _COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif

#ifdef __cplusplus
  #ifndef _STDTIME_T_DEFINED
    #define _STDTIME_T_DEFINED
    namespace std {
      typedef unsigned long time_t;
    }
  #endif
  #ifndef _TIME_T_DEFINED
    #define _TIME_T_DEFINED
    #define _TIME_T_DEFINED_
    using std::time_t;
  #endif
#else
  #ifndef _TIME_T_DEFINED
    #define _TIME_T_DEFINED
    #define _TIME_T_DEFINED_
    typedef unsigned long time_t;
  #endif
#endif /* __cplusplus */

#ifdef _M_IX86
#pragma pack( __push, 1 )
#else
#pragma pack( __push, 8 )
#endif
struct timeb {
    time_t              time;           /* seconds since Jan 1, 1970 UTC */
    unsigned short      millitm;        /* milliseconds */
    short               timezone;       /* difference in minutes from UTC */
    short               dstflag;        /* nonzero if daylight savings time */
};
struct _timeb {
    time_t              time;           /* seconds since Jan 1, 1970 UTC */
    unsigned short      millitm;        /* milliseconds */
    short               timezone;       /* difference in minutes from UTC */
    short               dstflag;        /* nonzero if daylight savings time */
};
#pragma pack( __pop )

_WCRTLINK extern int ftime( struct timeb *__timeptr );
_WCRTLINK extern int _ftime( struct _timeb *__timeptr );

#ifdef __cplusplus
} /* End of extern "C" */
#endif
#endif
