/*
 *  jctype.h    Japanese character test macros
 *
 *                          Open Watcom Project
 *
 *    Copyright (c) 2002-2008 Open Watcom Contributors. All Rights Reserved.
 *    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
 *
 *    This file is automatically generated. Do not edit directly.
 *
 * =========================================================================
 */
#ifndef _JCTYPE_H_INCLUDED
#define _JCTYPE_H_INCLUDED
#if !defined(_ENABLE_AUTODEPEND)
  #pragma read_only_file;
#endif


/*
 *       iskana(c)       JiER[h
 *       iskpun(c)       Jiؕ
 *       iskmoji(c)      Ji
 *       isalkana(c)     p܂̓Ji
 *       ispnkana(c)     pؕ܂̓Jiؕ
 *       isalnmkana(c)   p܂̓Ji
 *       isprkana(c)     \\i󔒂܂ށj
 *       isgrkana(c)     \\i󔒂j
 *
 *       iskanji(c)      PoCg
 *       iskanji2(c)     QoCg
 *
 */

#ifndef _COMDEF_H_INCLUDED
 #include <_comdef.h>
#endif
#ifndef _CTYPE_H_INCLUDED
 #include <ctype.h>
#endif

#define _K      0x01    /* Kana moji      */
#define _KP     0x02    /* Kana punct.    */
#define _J1     0x04    /* Kanji 1st byte */
#define _J2     0x08    /* Kanji 2nd byte */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
_WCRTLINK extern int    iskana(int);
_WCRTLINK extern int    iskpun(int);
_WCRTLINK extern int    iskmoji(int);
_WCRTLINK extern int    isalkana(int);
_WCRTLINK extern int    ispnkana(int);
_WCRTLINK extern int    isalnmkana(int);
_WCRTLINK extern int    isprkana(int);
_WCRTLINK extern int    isgrkana(int);
_WCRTLINK extern int    iskanji(int);
_WCRTLINK extern int    iskanji2(int);

/* kana, kanji type table */
#if defined(__SW_BR) || defined(_RTDLL)
 #define _IsKTable _IsKTable_br
#endif
_WCRTDATA extern const char _WCDATA _IsKTable[257];
#ifdef __cplusplus
} /* End of extern "C" */
#endif

#if !defined(__FUNCTION_DATA_ACCESS)
#define iskana(__c)     (_IsKTable[(unsigned char)(__c)+1] & (_K|_KP))
#define iskpun(__c)     (_IsKTable[(unsigned char)(__c)+1] & _KP)
#define iskmoji(__c)    (_IsKTable[(unsigned char)(__c)+1] & _K)
#define isalkana(__c)   (isalpha(__c) || iskmoji(__c))
#define ispnkana(__c)   (ispunct(__c) || iskpun(__c))
#define isalnmkana(__c) (isalnum(__c) || iskmoji(__c))
#define isprkana(__c)   (isprint(__c) || iskana(__c))
#define isgrkana(__c)   (isgraph(__c) || iskana(__c))

#define iskanji(__c)    (_IsKTable[(unsigned char)(__c)+1] & _J1)
#define iskanji2(__c)   (_IsKTable[(unsigned char)(__c)+1] & _J2)
#endif

#endif
