.\" Converted with mdoc2man 0.2
.\" from NiH: zip_source_filep.mdoc,v 1.6 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_source_filep.mdoc,v 1.6 2005/06/09 21:14:54 wiz Exp $
.\"
.\" zip_source_filep.mdoc \-- create data source from a file stream
.\" Copyright (C) 2004, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SOURCE_FILEP 3 "November 4, 2004" NiH
.SH "NAME"
zip_source_filep \- create data source from FILE *
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
.Ft int
.Fn zip_source_filep "struct zip *archive" "FILE *file" "off_t start" "off_t len"
.SH "DESCRIPTION"
The function
.Fn zip_source_filep
creates a zip source from a file stream.
.Fn zip_source_filep
reads
\fBlen\fR
bytes from offset
\fBstart\fR
from the open file stream
\fBfile.\fR
If
\fBlen\fR
is 0 or \-1, the whole file (starting from
\fBstart )\fR
is used.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
.Dv NULL
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
.Fn zip_source_filep
fails if:
.RS
.TP 4
Bq Er ZIP_ER_INVAL
\fBfile,\fR
\fBstart,\fR
or
\fBlen\fR
are invalid.
.TP 4
Bq Er ZIP_ER_MEMORY
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source_buffer(3),
zip_source_file(3),
zip_source_free(3),
zip_source_function(3),
zip_source_zip(3)
.SH "AUTHORS"
-nosplit
Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
