/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  F-Code I/O routines.
*
****************************************************************************/


#include "ftnstd.h"
#include "global.h"
#include "fcdata.h"
#include "wf77defs.h"
#include "wf77cg.h"
#include "tmpdefs.h"
#include "fcodes.h"
#include "parmtype.h"

//=================== Back End Code Generation Routines ====================

extern  void            CGDone(cg_name);
extern  cg_name         CGInteger(signed_32,cg_type);
extern  void            CGAddParm(call_handle,cg_name,cg_type);
extern  cg_name         CGCall(call_handle);
extern  cg_name         CGBackName(back_handle,cg_type);
extern  cg_name         CGFEName(sym_handle,cg_type);
extern  cg_name         CGUnary(cg_op,cg_name,cg_type);
extern  cg_name         CGBinary(cg_op,cg_name,cg_name,cg_type);
extern  void            CGTrash(cg_name);
extern  cg_name         CGAssign(cg_name,cg_name,cg_type);
extern  void            CGControl(cg_op,cg_name,label_handle);
extern  cg_name         CGCompare(cg_op,cg_name,cg_name,cg_type);
extern  void            CG3WayControl(cg_name,label_handle,label_handle,
                                      label_handle );
extern  label_handle    BENewLabel(void);
extern  void            BEFiniLabel(label_handle);

//=========================================================================

extern  call_handle     InitCall(int);
extern  unsigned_16     GetU16(void);
extern  pointer         GetPtr(void);
extern  cg_name         XPop(void);
extern  cg_name         XPopValue(cg_type);
extern  void            XPopCmplx(cg_cmplx *,cg_type);
extern  cg_name         GetTypedValue(void);
extern  void            XPush(cg_name);
extern  cg_name         SymAddr(sym_id);
extern  cg_type         SymPtrType(sym_id);
extern  cg_name         ImagPtr(cg_name,cg_type);
extern  back_handle     GetFmtLabel(label_id);
extern  cg_name         ArrayEltSize(sym_id);
extern  cg_name         ArrayNumElts(sym_id);
extern  cg_name         FieldArrayNumElts(sym_id);
extern  label_handle    GetLabel(int);
extern  cg_name         SCBLenAddr(cg_name);
extern  cg_name         SCBPtrAddr(cg_name);
extern  label_handle    GetStmtLabel(sym_id);
extern  void            RefStmtLabel(sym_id);
extern  cg_type         CmplxBaseType(cg_type);
extern  void            CloneCGName(cg_name,cg_name *,cg_name *);
extern  tmp_handle      MkTmp(cg_name,cg_type);
extern  cg_name         TmpPtr(tmp_handle,cg_type);
extern  cg_name         TmpVal(tmp_handle,cg_type);
extern  void            ReverseList(void **);
extern  cg_type         PromoteToBaseType(cg_type);

static  void            StructIOArrayStruct( sym_id arr );
static  void            StructIOItem( sym_id fd );

static  sym_id          EndEqStmt;
static  sym_id          ErrEqStmt;
static  void            (**IORtnTable)();
static  tmp_handle      TmpStructPtr;
static  bool            IOStatSpecified;
static  label_handle    IOSLabel;
static  bool            NmlSpecified;


static  void    StructIO( struct field *fd ) {
//============================================

    sym_id      map;
    sym_id      big_map;
    unsigned_32 size;

    while( fd != NULL ) {
        if( fd->typ == TY_STRUCTURE ) {
            if( fd->dim_ext != NULL ) {
                StructIOArrayStruct( (sym_id)fd );
            } else {
                StructIO( fd->xt.record->fl.fields );
            }
        } else if( fd->typ == TY_UNION ) {
            size = 0;
            map = fd->xt.sym_record;
            while( map != NULL ) { // find biggest map
                if( map->sd.size > size ) {
                    size = map->sd.size;        // 91/08/01 DJG
                    big_map = map;
                }
                map = map->sd.link;
            }
            StructIO( big_map->sd.fl.fields );
        } else {
            StructIOItem( (sym_id)fd );
        }
        fd = &fd->link->fd;
    }
}


void    FCSetIOCB() {
//===================

// Call runtime routine to set i/o statement in IOCB.
// This must be the first call when processing an I/O statement.

    EndEqLabel = 0;
    ErrEqLabel = 0;
    EndEqStmt = NULL;
    ErrEqStmt = NULL;
    IOStatSpecified = FALSE;
    NmlSpecified = FALSE;
}


void    FCSetUnit() {
//===================

// Call runtime routine to set unit number in IOCB.

    IOCallValue( RT_SET_UNIT );
}


static  void    IOStatement( uint stmt ) {
//========================================

    // don't need label generated for IOSTAT unless it's a READ or WRITE
    // statement that is not NAMELIST-directed
    if( ( (stmt != RT_EX_READ) && (stmt != RT_EX_WRITE) ) || NmlSpecified ) {
        IOStatSpecified = FALSE;
    }
    ChkIOErr( CGCall( InitCall( stmt ) ) );
}


void    FCExRead() {
//==================

// Call runtime routine to set start READ operation.

    IOStatement( RT_EX_READ );
}


void    FCExWrite() {
//===================

// Call runtime routine to set start WRITE operation.

    IOStatement( RT_EX_WRITE );
}


void    FCExOpen() {
//==================

// Call runtime routine to set start OPEN operation.

    IOStatement( RT_EX_OPEN );
}


void    FCExClose() {
//===================

// Call runtime routine to set start CLOSE operation.

    IOStatement( RT_EX_CLOSE );
}


void    FCExBack() {
//==================

// Call runtime routine to set start BACKSPACE operation.

    IOStatement( RT_EX_BACK );
}


void    FCExEndf() {
//==================

// Call runtime routine to set start ENDFILE operation.

    IOStatement( RT_EX_ENDF );
}


void    FCExRew() {
//=================

// Call runtime routine to set start REWIND operation.

    IOStatement( RT_EX_REW );
}


void    FCExInq() {
//=================

// Call runtime routine to set start INQUIRE operation.

    IOStatement( RT_EX_INQ );
}


void    FCOutLOG1() {
//===================

// Call runtime routine to output LOGICAL*1 value.

    Output( RT_OUT_LOG1, T_UINT_1 );
}


void    FCOutLOG4() {
//===================

// Call runtime routine to output LOGICAL*4 value.

    Output( RT_OUT_LOG4, T_UINT_4 );
}


void    FCOutINT1() {
//===================

// Call runtime routine to output INTEGER*1 value.

    Output( RT_OUT_INT1, T_INT_1 );
}


void    FCOutINT2() {
//===================

// Call runtime routine to output INTEGER*2 value.

    Output( RT_OUT_INT2, T_INT_2 );
}


void    FCOutINT4() {
//===================

// Call runtime routine to output INTEGER*4 value.

    Output( RT_OUT_INT4, T_INT_4 );
}


void    FCOutREAL() {
//===================

// Call runtime routine to output REAL*4 value.

    Output( RT_OUT_REAL, T_SINGLE );
}


void    FCOutDBLE() {
//===================

// Call runtime routine to output REAL*8 value.

    Output( RT_OUT_DBLE, T_DOUBLE );
}


void    FCOutXTND() {
//===================

// Call runtime routine to output REAL*10 value.

    Output( RT_OUT_XTND, T_LONGDOUBLE );
}


static  void    OutCplx( int rtn, cg_type typ ) {
//===============================================

// Call runtime routine to input COMPLEX value.

    call_handle handle;
    cg_cmplx    z;

    handle = InitCall( rtn );
    XPopCmplx( &z, typ );
    typ = CmplxBaseType( typ );
    CGAddParm( handle, z.imagpart, typ );
    CGAddParm( handle, z.realpart, typ );
    CGDone( CGCall( handle ) );
}


void    FCOutCPLX() {
//===================

// Call runtime routine to output COMPLEX*8 value.

    OutCplx( RT_OUT_CPLX, T_COMPLEX );
}


void    FCOutDBCX() {
//===================

// Call runtime routine to output COMPLEX*16 value.

    OutCplx( RT_OUT_DBCX, T_DCOMPLEX );
}


void    FCOutXTCX() {
//===================

// Call runtime routine to output COMPLEX*20 value.

    OutCplx( RT_OUT_XTCX, T_XCOMPLEX );
}


void    FCOutCHAR() {
//===================

// Call runtime routine to output CHARACTER*n value.

    call_handle handle;

    handle = InitCall( RT_OUT_CHAR );
    CGAddParm( handle, XPop(), T_POINTER );
    CGDone( CGCall( handle ) );
}


static  void    OutString() {
//===========================

// Call runtime routine to output CHARACTER*n value.
// Note: 2 arguments are passed (data pointer and length) as opposed to a
//       pointer to the SCB.

    IOString( RT_OUT_STR );
}


static  void    IOString( uint rtn ) {
//====================================

    call_handle handle;

    handle = InitCall( rtn );
    CGAddParm( handle, XPop(), T_INTEGER );
    CGAddParm( handle, XPop(), T_POINTER );
    CGDone( CGCall( handle ) );
}


static  void    Output( int rtn, cg_type arg_type ) {
//===================================================

// Call runtime routine to output elemental types value.

    call_handle handle;

    handle = InitCall( rtn );
    CGAddParm( handle, XPopValue( arg_type ), PromoteToBaseType( arg_type ) );
    CGDone( CGCall( handle ) );
}


void    FCInpLOG1() {
//===================

// Call runtime routine to input LOGICAL*1 value.

    Input( RT_INP_LOG1 );
}


void    FCInpLOG4() {
//===================

// Call runtime routine to input LOGICAL*4 value.

    Input( RT_INP_LOG4 );
}


void    FCInpINT1() {
//===================

// Call runtime routine to input INTEGER*1 value.

    Input( RT_INP_INT1 );
}


void    FCInpINT2() {
//===================

// Call runtime routine to input INTEGER*2 value.

    Input( RT_INP_INT2 );
}


void    FCInpINT4() {
//===================

// Call runtime routine to input INTEGER*4 value.

    Input( RT_INP_INT4 );
}


void    FCInpREAL() {
//===================

// Call runtime routine to input REAL*4 value.

    Input( RT_INP_REAL );
}


void    FCInpDBLE() {
//===================

// Call runtime routine to input REAL*8 value.

    Input( RT_INP_DBLE );
}


void    FCInpXTND() {
//===================

// Call runtime routine to input REAL*10 value.

    Input( RT_INP_XTND );
}


void    FCInpCPLX() {
//===================

// Call runtime routine to input COMPLEX*8 value.

    Input( RT_INP_CPLX );
}


void    FCInpDBCX() {
//===================

// Call runtime routine to input COMPLEX*16 value.

    Input( RT_INP_DBCX );
}


void    FCInpXTCX() {
//===================

// Call runtime routine to input COMPLEX*20 value.

    Input( RT_INP_XTCX );
}


void    FCInpCHAR() {
//===================

// Call runtime routine to input CHARACTER*n value.

    Input( RT_INP_CHAR );
}


static  void    InpString() {
//===========================

// Call runtime routine to input CHARACTER*n value.
// Note: 2 arguments are passed (data pointer and length) as opposed to a
//       pointer to the SCB.

    IOString( RT_INP_STR );
}


static  void    Input( int rtn ) {
//================================

// Common input routine.

    call_handle handle;

    handle = InitCall( rtn );
    CGAddParm( handle, XPop(), T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCEndIO() {
//=================

// Call runtime routine to terminate i/o processing.

    CGDone( CGCall( InitCall( RT_ENDIO ) ) );
    FCChkIOStmtLabel();
    if( ( ErrEqLabel == 0 ) && ( EndEqLabel == 0 ) && IOStatSpecified ) {
        CGControl( O_LABEL, NULL, IOSLabel );
        BEFiniLabel( IOSLabel );
    }
}


static  void            (*OutRtn[])() = {
        NULL,
        &FCOutLOG1,
        &FCOutLOG4,
        &FCOutINT1,
        &FCOutINT2,
        &FCOutINT4,
        &FCOutREAL,
        &FCOutDBLE,
        &FCOutXTND,
        &FCOutCPLX,
        &FCOutDBCX,
        &FCOutXTCX,
        &OutString
};

static  void            (*InpRtn[])() = {
        NULL,
        &FCInpLOG1,
        &FCInpLOG4,
        &FCInpINT1,
        &FCInpINT2,
        &FCInpINT4,
        &FCInpREAL,
        &FCInpDBLE,
        &FCInpXTND,
        &FCInpCPLX,
        &FCInpDBCX,
        &FCInpXTCX,
        &InpString
};


void    FCOutStruct() {
//=====================

// Output a structure.

    IORtnTable = OutRtn;
    TmpStructPtr = MkTmp( XPop(), T_POINTER );
    StructIO( ((sym_id)GetPtr())->sd.fl.fields );
}


static  void    DoStructArrayIO( tmp_handle num_elts, struct field *fieldz ) {
//============================================================================

// Perform structure array i/o.

    label_handle        label;

    label = BENewLabel();
    CGControl( O_LABEL, NULL, label );
    StructIO( fieldz );
    CGControl( O_IF_TRUE,
               CGCompare( O_NE,
                          CGAssign( TmpPtr( num_elts, T_INT_4 ),
                                    CGBinary( O_MINUS,
                                              TmpVal( num_elts, T_INT_4 ),
                                              CGInteger( 1, T_INTEGER ),
                                              T_INT_4 ),
                                    T_INT_4 ),
                          CGInteger( 0, T_INTEGER ), T_INT_4 ),
               label );
    BEFiniLabel( label );
}


static  void    StructIOArrayStruct( sym_id arr ) {
//=================================================

// Perform structure array i/o on a field.

    tmp_handle          num_elts;

    num_elts = MkTmp( FieldArrayNumElts( arr ), T_INT_4 );
    DoStructArrayIO( num_elts, arr->fd.xt.record->fl.fields );
}


static  void    StructIOItem( sym_id fd ) {
//=========================================

// Perform i/o of structure field.

    uint        rtn;

    if( fd->fd.dim_ext == NULL ) {
        XPush( TmpVal( TmpStructPtr, T_POINTER ) );
        if( fd->fd.typ == TY_CHAR ) {
            XPush( CGInteger( fd->fd.xt.size, T_INTEGER ) );
        }
        IORtnTable[ ParmType( fd->fd.typ, fd->fd.xt.size ) ]();
        CGTrash( CGAssign( TmpPtr( TmpStructPtr, T_POINTER ),
                           CGBinary( O_PLUS,
                                     TmpVal( TmpStructPtr, T_POINTER ),
                                     CGInteger( fd->fd.xt.size, T_UINT_4 ),
                                     T_POINTER ),
                           T_POINTER ) );
    } else {
        if( IORtnTable == &OutRtn ) {
            rtn = RT_PRT_ARRAY;
        } else {
            rtn = RT_INP_ARRAY;
        }
        if( fd->fd.typ == TY_CHAR ) {
            ChrArrayIO( rtn + 1, TmpVal( TmpStructPtr, T_POINTER ),
                        CGInteger( fd->fd.dim_ext->num_elts, T_INT_4 ),
                        CGInteger( fd->fd.xt.size, T_INTEGER ) );
        } else {
            NumArrayIO( rtn, TmpVal( TmpStructPtr, T_POINTER ),
                        CGInteger( fd->fd.dim_ext->num_elts, T_INT_4 ),
                        ParmType( fd->fd.typ, fd->fd.xt.size ) );
        }
        CGTrash( CGAssign( TmpPtr( TmpStructPtr, T_POINTER ),
                           CGBinary( O_PLUS,
                                     TmpVal( TmpStructPtr, T_POINTER ),
                                     CGInteger( fd->fd.xt.size *
                                                fd->fd.dim_ext->num_elts,
                                                T_UINT_4 ),
                                     T_POINTER ),
                           T_POINTER ) );
    }
}


void    FCPrtStructArray() {
//==========================

    IORtnTable = OutRtn;
    StructArrayIO();
}


void    FCInpStructArray() {
//==========================

    IORtnTable = InpRtn;
    StructArrayIO();
}


void    FCInpStruct() {
//=====================

// Input a structure.

    IORtnTable = InpRtn;
    TmpStructPtr = MkTmp( XPop(), T_POINTER );
    StructIO( ((sym_id)GetPtr())->sd.fl.fields );
}


void    FCChkIOStmtLabel() {
//==========================

    if( EndEqStmt != NULL ) {
        RefStmtLabel( EndEqStmt );
    }
    if( ErrEqStmt != NULL ) {
        RefStmtLabel( ErrEqStmt );
    }
}


void    FCSetNml() {
//==================

// Set NAMELIST format.

    call_handle handle;
    sym_id      nl;
    grp_entry   *ge;

    NmlSpecified = TRUE;
    handle = InitCall( RT_SET_NML );
    nl = GetPtr();
    ReverseList( &nl->nl.group_list );
    ge = nl->nl.group_list;
    while( ge != NULL ) {
        CGAddParm( handle, SymAddr( ge->sym ), T_POINTER );
        ge = ge->link;
    }
    ReverseList( &nl->nl.group_list );
    CGAddParm( handle, CGBackName( nl->nl.address, T_POINTER ), T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCSetFmt() {
//==================

// Set format string from FORMAT statement.

    call_handle handle;

    handle = InitCall( RT_SET_FMT );
    CGAddParm( handle, CGBackName( GetStmtLabel( GetPtr() ), T_POINTER ),
               T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCPassLabel() {
//=====================

// Pass label to run-time routine.

    call_handle handle;

    handle = InitCall( GetU16() );
    CGAddParm( handle, CGBackName( GetLabel( GetU16() ), T_POINTER ),
               T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCFmtAssign() {
//=====================

// Set FORMAT string for:
//       ASSIGN 10 TO I
//       PRINT I, ...
// 10    FORMAT( ... )

    call_handle handle;

    handle = InitCall( RT_SET_FMT );
    CGAddParm( handle,
               CGUnary( O_POINTS, SymAddr( GetPtr() ), T_POINTER ),
               T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCPrtArray() {
//====================

// Output an array.

    ArrayIO( RT_PRT_ARRAY, RT_PRT_CHAR_ARRAY );
}


void    FCInpArray() {
//====================

// Input an array.

    ArrayIO( RT_INP_ARRAY, RT_INP_CHAR_ARRAY );
}


void    ArrayIO( int num_array, int chr_array ) {
//===============================================

// Output an array.

    sym_id      arr;
    sym_id      field;
    cg_name     addr;
    cg_name     num_elts;
    cg_name     elt_size;

    arr = GetPtr();
    field = GetPtr();
    if( field == NULL ) {
        addr = SymAddr( arr );
        num_elts = ArrayNumElts( arr );
        if( arr->ns.typ == TY_CHAR ) {
            ChrArrayIO( chr_array, addr, num_elts, ArrayEltSize( arr ) );
        } else {
            NumArrayIO( num_array, addr, num_elts,
                        ParmType( arr->ns.typ, arr->ns.xt.size ) );
        }
    } else { // must be a array field in a structure
        addr = XPop();
        num_elts = FieldArrayNumElts( field );
        if( field->fd.typ == TY_CHAR ) {
            elt_size = CGInteger( field->fd.xt.size, T_INTEGER );
            ChrArrayIO( chr_array, addr, num_elts, elt_size );
        } else {
            NumArrayIO( num_array, addr, num_elts,
                        ParmType( field->fd.typ, field->fd.xt.size ) );
        }
    }
}


static  void    ChrArrayIO( uint rtn, cg_name arr, cg_name num_elts,
                            cg_name elt_size ) {
//==================================================================

    call_handle call;

    call = InitCall( rtn );
    CGAddParm( call, elt_size, T_INTEGER );
    CGAddParm( call, num_elts, T_INT_4 );
    CGAddParm( call, arr, T_POINTER );
    CGDone( CGCall( call ) );
}


static  void    NumArrayIO( uint rtn, cg_name arr, cg_name num_elts,
                            uint typ ) {
//==================================================================

    call_handle call;

    call = InitCall( rtn );
    CGAddParm( call, CGInteger( typ, T_INTEGER ), T_INTEGER );
    CGAddParm( call, num_elts, T_INT_4 );
    CGAddParm( call, arr, T_POINTER );
    CGDone( CGCall( call ) );
}


static  void    StructArrayIO() {
//===============================

// Perform structure array i/o.

    sym_id              arr;
    tmp_handle          num_elts;

    arr = GetPtr();
    num_elts = MkTmp( ArrayNumElts( arr ), T_INT_4 );
    TmpStructPtr = MkTmp( SymAddr( arr ), T_POINTER );
    DoStructArrayIO( num_elts, arr->ns.xt.record->fl.fields );
}


void    FCFmtScan() {
//===================

// Call runtime routine to scan a format specification from a character
// expression.

    call_handle handle;

    handle = InitCall( RT_FMT_SCAN );
    CGAddParm( handle, CGInteger( GetU16(), T_UNSIGNED ), T_UNSIGNED );
    CGAddParm( handle, XPop(), T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCFmtArrScan() {
//======================

// Call runtime routine to scan a format specification from a character
// array.

    call_handle handle;
    sym_id      sym;

    sym = GetPtr();
    handle = InitCall( RT_FMT_ARR_SCAN );
    CGAddParm( handle, CGInteger( GetU16(), T_UNSIGNED ), T_UNSIGNED );
    CGAddParm( handle, ArrayEltSize( sym ), T_UNSIGNED );
    CGAddParm( handle, ArrayNumElts( sym ), T_INT_4 );
    CGAddParm( handle, SymAddr( sym ), T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCIntlArrSet() {
//======================

// Call runtime routine to set internal file to character array.

    call_handle handle;
    sym_id      sym;
    sym_id      scb;

    sym = GetPtr();
    scb = GetPtr();
    CGTrash( CGAssign( SCBLenAddr( CGFEName( scb, T_POINTER ) ),
                       ArrayEltSize( sym ), T_INTEGER ) );
    CGTrash( CGAssign( SCBPtrAddr( CGFEName( scb, T_POINTER ) ),
                       SymAddr( sym ), T_POINTER ) );
    handle = InitCall( RT_SET_INTL );
    CGAddParm( handle, ArrayNumElts( sym ), T_INT_4 );
    CGAddParm( handle, CGFEName( scb, T_POINTER ), T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCSetIntl() {
//===================

// Call runtime routine to set internal file to character item (not array).

    call_handle handle;

    handle = InitCall( RT_SET_INTL );
    CGAddParm( handle, CGInteger( 1, T_INT_4 ), T_INT_4 );
    CGAddParm( handle, XPop(), T_POINTER );
    CGDone( CGCall( handle ) );
}


void    FCSetFile() {
//===================

// Set FILE=.

    IOCall( RT_SET_FILE );
}


void    FCSetCCtrl() {
//====================

// Set CARRIAGECONTROL=.

    IOCall( RT_SET_CCTRL );
}


void    FCSetShare() {
//====================

// Set SHARE=.

    IOCall( RT_SET_SHARE );
}


void    FCSetRecType() {
//======================

// Set RECORDTYPE=.

    IOCall( RT_SET_RECTYPE );
}


void    FCSetAction() {
//=====================

// Set ACTION=.

    IOCall( RT_SET_ACTION );
}


void    FCSetErr() {
//==================

// Set ERROR=.

    sym_id      sn;

    CGDone( CGCall( InitCall( RT_SET_ERR ) ) );
    sn = GetPtr();
    // Don't call RefStmtLabel() for 'sn' yet since we will be referencing
    // the label for error checking after an i/o operation. RefStmtLabel()
    // may call DoneLabel() if this is the last reference to the statement
    // label.
    ErrEqStmt = sn;
    ErrEqLabel = sn->st.address;
}


void    FCSetEnd() {
//==================

// Set END=.

    sym_id      sn;

    CGDone( CGCall( InitCall( RT_SET_END ) ) );
    sn = GetPtr();
    // Don't call RefStmtLabel() for 'sn' yet since we will be referencing
    // the label for error checking after an i/o operation. RefStmtLabel()
    // may call DoneLabel() if this is the last reference to the statement
    // label.
    EndEqStmt = sn;
    EndEqLabel = sn->st.address;
}


void    FCSetAtEnd() {
//====================

// Set END= for ATEND statement.

    CGDone( CGCall( InitCall( RT_SET_END ) ) );
    EndEqLabel = GetU16();
}


void    FCSetRec() {
//==================

// Set REC=.

    IOCallValue( RT_SET_REC );
}


void    FCSetIOS() {
//==================

// Set IOSTAT=.

    IOCall( RT_SET_IOS );
    IOStatSpecified = TRUE;
}


void    FCSetAcc() {
//==================

// Set ACCESS=.

    IOCall( RT_SET_ACC );
}


void    FCSetBlnk() {
//===================

// Set BLANK=.

    IOCall( RT_SET_BLNK );
}


void    FCSetForm() {
//===================

// Set FORM=.

    IOCall( RT_SET_FORM );
}


void    FCInqBlockSize() {
//========================

// Set BLOCKSIZE= for INQUIRE statement.

    IOCall( RT_INQ_BLOCKSIZE );
}


void    FCSetLen() {
//==================

// Set RECL= for INQUIRE statement.

    IOCall( RT_SET_LEN );
}


void    FCSetStat() {
//===================

// Set STATUS=.

    IOCall( RT_SET_STAT );
}


void    FCSetDir() {
//==================

// Set DIRECT=.

    IOCall( RT_SET_DIR );
}


void    FCSetFmtd() {
//===================

// Set FORMATTED=.

    IOCall( RT_SET_FMTD );
}


void    FCSetName() {
//===================

// Set NAME=.

    IOCall( RT_SET_NAME );
}


void    FCSetSeq() {
//==================

// Set SEQUENTIAL=.

    IOCall( RT_SET_SEQ );
}


void    FCSetUFmtd() {
//====================

// Set UNFORMATTED=.

    IOCall( RT_SET_UFMTD );
}


void    FCSetExst() {
//===================

// Set EXIST=.

    IOCall( RT_SET_EXST );
}


void    FCSetNmd() {
//==================

// Set NAMED=.

    IOCall( RT_SET_NMD );
}


void    FCSetNRec() {
//===================

// Set NEXTREC=.

    IOCall( RT_SET_NREC );
}


void    FCSetNumb() {
//===================

// Set NUMBER=.

    IOCall( RT_SET_NUMB );
}


void    FCSetOpen() {
//===================

// Set OPENED=.

    IOCall( RT_SET_OPEN );
}


void    FCSetBlockSize() {
//========================

// Set BLOCKSIZE= for OPEN statement.

    IOCallValue( RT_SET_BLOCKSIZE );
}


void    FCSetRecl() {
//===================

// Set RECL= for OPEN statement.

    IOCallValue( RT_SET_RECL );
}


void    FCSetNoFmt() {
//====================

// Set "not formatted i/o".

    CGDone( CGCall( InitCall( RT_SET_NOFMT ) ) );
}


static  void    IOCall( int rtn ) {
//=================================

// Call i/o run-time routine with one argument.

    call_handle handle;

    handle = InitCall( rtn );
    CGAddParm( handle, XPop(), T_POINTER );
    CGDone( CGCall( handle ) );
}


static  void    IOCallValue( int rtn ) {
//======================================

// Call i/o run-time routine with one argument.

    call_handle handle;

    handle = InitCall( rtn );
    CGAddParm( handle, GetTypedValue(), T_INT_4 );
    CGDone( CGCall( handle ) );
}


static  void    ChkIOErr( cg_name io_stat ) {
//===========================================

// Check for i/o errors.

    label_handle        eq_label;

    io_stat = CGUnary( O_POINTS, io_stat, T_INTEGER );
    if( ( EndEqLabel != 0 ) && ( ErrEqLabel != 0 ) ) {
        eq_label = BENewLabel();
        CG3WayControl( io_stat, GetLabel( EndEqLabel ), eq_label,
                       GetLabel( ErrEqLabel ) );
        CGControl( O_LABEL, NULL, eq_label );
        BEFiniLabel( eq_label );
    } else if( EndEqLabel != 0 ) {
        CGControl( O_IF_TRUE,
                   CGCompare( O_LT, io_stat, CGInteger( 0, T_INTEGER ),
                              T_INTEGER ),
                   GetLabel( EndEqLabel ) );
    } else if( ErrEqLabel != 0 ) {
        CGControl( O_IF_TRUE,
                   CGCompare( O_NE, io_stat, CGInteger( 0, T_INTEGER ),
                              T_INTEGER ),
                   GetLabel( ErrEqLabel ) );
    } else if( IOStatSpecified ) {
        IOSLabel = BENewLabel();
        CGControl( O_IF_TRUE,
                   CGCompare( O_NE, io_stat, CGInteger( 0, T_INTEGER ),
                              T_INTEGER ),
                   IOSLabel );
    } else {
        CGDone( io_stat );
    }
}
