/*
 *Duffs device: Demonstrates (legal but questionable) use of case statements
 *				within an inner loop! In this case, a do loop is started at
 *				the right point to perform a copy using 1/8 of the normal
 *				number of iterations required by a single-byte loop.
 *
 * Compile command: cc duff -fop
 */
duff(char *to, char *from, unsigned count)
{
	unsigned n;

	n = (count + 7) / 8;	/* count > 0 assumed */
	switch (count % 8) {
		do {
			case 0:	*to++ = *from++;
			case 7:	*to++ = *from++;
			case 6:	*to++ = *from++;
			case 5:	*to++ = *from++;
			case 4:	*to++ = *from++;
			case 3:	*to++ = *from++;
			case 2:	*to++ = *from++;
			case 1:	*to++ = *from++; }
		while (--n); }
}

/*
 * Test program
 */
#include <stdio.h>
main()
{
	int i;
	static char string[] = {
		"The quick brown fox jumped over the lazy dog's back." };
	char buffer[sizeof(string)];

	for(i=1; i < sizeof(string); ++i) {
		memset(buffer, 0, sizeof(buffer));
		duff(buffer, string, i);
		printf("%s\n", buffer); }
}
