/*
 * Filter to convert C++ style end-of-line comments (//)
 * into standard 'C' comments
 *
 * Compile command: cc calc -fop
 */
#include <stdio.h>

main()
{
	int c, lastc;
	char incomment;

	incomment = 0;
	while((c = getc(stdin)) != EOF) {
		switch(c) {
			case '\'' :			/* Character constant */
			case '"' :			/* Literal String */
				if(!incomment) {
					putc(c, stdout);
					while(((lastc = getc(stdin)) != EOF) && (lastc != c)) {
						putc(lastc, stdout);
				if(lastc == '\\')		/* Next char is protected */
					putc(getc(stdin), stdout); } }
				break;
			case '/' :			/* Could be the start of a comment */
				if((lastc == '/') && !incomment) {
					incomment = 1;
					c = '*'; }
				break;
			case '\n' :			/* Newline, reset comment flags */
				if(incomment)
					fputs(" */", stdout);
				incomment = 0; }
		putc(lastc = c, stdout); }
}
