/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <limits.h>
#include <stddef.h>
#include <ctype.h>
#include <locale.h>
#include "_locale.h"
#include "llp.h"

extern ABBREVIATED_CTYPE_DATA C_ctype_data ;
extern ABBREVIATED_TIME_DATA C_time_data ;
extern NUMERIC_DATA C_numeric_data ;
extern void *__locale_data[LC_LAST+1] ;

static char C_qualified_name[] = "C";
static char C_unqualified_name[] = "C";

static ABBREVIATED_COLLATE_DATA C_collate_data= {
	&C_qualified_name,
	{
	0x00, 0x00, 0x01, 0x00, 0x25, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x67, 0x68, 0x00, 0x00, 0x0D, 0x0E, 0x0B, 0x00, 
	0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 
	0x09, 0x0A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x10, 0x12, 0x14, 0x16, 0x18, 0x1A, 0x1C, 
	0x1E, 0x20, 0x22, 0x24, 0x26, 0x28, 0x2A, 0x2C, 
	0x2E, 0x30, 0x32, 0x34, 0x36, 0x38, 0x3A, 0x3C, 
	0x3E, 0x40, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0F, 0x11, 0x13, 0x15, 0x17, 0x19, 0x1B, 
	0x1D, 0x1F, 0x21, 0x23, 0x25, 0x27, 0x29, 0x2B, 
	0x2D, 0x2F, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3B, 
	0x3D, 0x3F, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x4E, 0x64, 0x4F, 0x46, 0x49, 0x45, 0x47, 0x4D, 
	0x52, 0x53, 0x51, 0x57, 0x56, 0x55, 0x4A, 0x48, 
	0x50, 0x4B, 0x4C, 0x5D, 0x5E, 0x5C, 0x63, 0x62, 
	0x66, 0x5F, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x44, 0x54, 0x5B, 0x61, 0x58, 0x59, 0x43, 0x5A, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	
	}
};
static MONETARY_DATA C_monetary_data= {
	&C_qualified_name,
	"",
	"",
	"",
	"",
	"",
	"",
	"",
    CHAR_MAX,CHAR_MAX,CHAR_MAX,CHAR_MAX,
    CHAR_MAX,CHAR_MAX,CHAR_MAX,CHAR_MAX,
    CHAR_MAX,CHAR_MAX,CHAR_MAX,CHAR_MAX,
    CHAR_MAX,CHAR_MAX
};
static MESSAGE_DATA C_message_data = {
	&C_qualified_name,
	"y",
	"n",
};
static USERDEF_DATA C_userdef_data = {
    &C_qualified_name, 0
};
LOCALE_HEADER _C_locale_data = {
	&C_unqualified_name,
    &C_qualified_name,
    { &C_collate_data },
	{ &C_ctype_data },
	&C_monetary_data,
	&C_numeric_data,
	{ &C_time_data },
	&C_message_data,
	&C_userdef_data
};

static void *__init_locale_data[LC_LAST+1] = {
    0,
	&C_collate_data,
	&C_ctype_data,
	&C_monetary_data,
	&C_numeric_data,
	&C_time_data,
	&C_message_data,
	&C_userdef_data
} ;

#pragma startup __locale_reinit 230
void __locale_reinit()
{
	memcpy(__locale_data, __init_locale_data, sizeof(__locale_data));
	__ctype_init();
}

