''
''
'' cryptlib -- encryption and authentication services toolkit 
''			   (header translated with help of SWIG FB wrapper)
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __cryptlib_bi__
#define __cryptlib_bi__

#inclib "crypt"

enum CRYPT_ALGO_TYPE
	CRYPT_ALGO_NONE
	CRYPT_ALGO_DES
	CRYPT_ALGO_3DES
	CRYPT_ALGO_IDEA
	CRYPT_ALGO_CAST
	CRYPT_ALGO_RC2
	CRYPT_ALGO_RC4
	CRYPT_ALGO_RC5
	CRYPT_ALGO_AES
	CRYPT_ALGO_BLOWFISH
	CRYPT_ALGO_SKIPJACK
	CRYPT_ALGO_DH = 100
	CRYPT_ALGO_RSA
	CRYPT_ALGO_DSA
	CRYPT_ALGO_ELGAMAL
	CRYPT_ALGO_KEA
	CRYPT_ALGO_MD2 = 200
	CRYPT_ALGO_MD4
	CRYPT_ALGO_MD5
	CRYPT_ALGO_SHA
	CRYPT_ALGO_RIPEMD160
	CRYPT_ALGO_HMAC_MD5 = 300
	CRYPT_ALGO_HMAC_SHA
	CRYPT_ALGO_HMAC_RIPEMD160
	CRYPT_ALGO_LAST
	CRYPT_ALGO_FIRST_CONVENTIONAL = CRYPT_ALGO_DES
	CRYPT_ALGO_LAST_CONVENTIONAL = CRYPT_ALGO_DH-1
	CRYPT_ALGO_FIRST_PKC = CRYPT_ALGO_DH
	CRYPT_ALGO_LAST_PKC = CRYPT_ALGO_MD2-1
	CRYPT_ALGO_FIRST_HASH = CRYPT_ALGO_MD2
	CRYPT_ALGO_LAST_HASH = CRYPT_ALGO_HMAC_MD5-1
	CRYPT_ALGO_FIRST_MAC = CRYPT_ALGO_HMAC_MD5
	CRYPT_ALGO_LAST_MAC = CRYPT_ALGO_HMAC_MD5+99
end enum


enum CRYPT_MODE_TYPE
	CRYPT_MODE_NONE
	CRYPT_MODE_ECB
	CRYPT_MODE_CBC
	CRYPT_MODE_CFB
	CRYPT_MODE_OFB
	CRYPT_MODE_LAST
end enum


enum CRYPT_KEYSET_TYPE
	CRYPT_KEYSET_NONE
	CRYPT_KEYSET_FILE
	CRYPT_KEYSET_HTTP
	CRYPT_KEYSET_LDAP
	CRYPT_KEYSET_ODBC
	CRYPT_KEYSET_DATABASE
	CRYPT_KEYSET_PLUGIN
	CRYPT_KEYSET_ODBC_STORE
	CRYPT_KEYSET_DATABASE_STORE
	CRYPT_KEYSET_PLUGIN_STORE
	CRYPT_KEYSET_LAST
end enum


enum CRYPT_DEVICE_TYPE
	CRYPT_DEVICE_NONE
	CRYPT_DEVICE_FORTEZZA
	CRYPT_DEVICE_PKCS11
	CRYPT_DEVICE_CRYPTOAPI
	CRYPT_DEVICE_LAST
end enum


enum CRYPT_CERTTYPE_TYPE
	CRYPT_CERTTYPE_NONE
	CRYPT_CERTTYPE_CERTIFICATE
	CRYPT_CERTTYPE_ATTRIBUTE_CERT
	CRYPT_CERTTYPE_CERTCHAIN
	CRYPT_CERTTYPE_CERTREQUEST
	CRYPT_CERTTYPE_REQUEST_CERT
	CRYPT_CERTTYPE_REQUEST_REVOCATION
	CRYPT_CERTTYPE_CRL
	CRYPT_CERTTYPE_CMS_ATTRIBUTES
	CRYPT_CERTTYPE_RTCS_REQUEST
	CRYPT_CERTTYPE_RTCS_RESPONSE
	CRYPT_CERTTYPE_OCSP_REQUEST
	CRYPT_CERTTYPE_OCSP_RESPONSE
	CRYPT_CERTTYPE_PKIUSER
	CRYPT_CERTTYPE_LAST
end enum


enum CRYPT_FORMAT_TYPE
	CRYPT_FORMAT_NONE
	CRYPT_FORMAT_AUTO
	CRYPT_FORMAT_CRYPTLIB
	CRYPT_FORMAT_CMS
	CRYPT_FORMAT_PKCS7 = CRYPT_FORMAT_CMS
	CRYPT_FORMAT_SMIME
	CRYPT_FORMAT_PGP
	CRYPT_FORMAT_LAST
end enum


enum CRYPT_SESSION_TYPE
	CRYPT_SESSION_NONE
	CRYPT_SESSION_SSH
	CRYPT_SESSION_SSH_SERVER
	CRYPT_SESSION_SSL
	CRYPT_SESSION_SSL_SERVER
	CRYPT_SESSION_RTCS
	CRYPT_SESSION_RTCS_SERVER
	CRYPT_SESSION_OCSP
	CRYPT_SESSION_OCSP_SERVER
	CRYPT_SESSION_TSP
	CRYPT_SESSION_TSP_SERVER
	CRYPT_SESSION_CMP
	CRYPT_SESSION_CMP_SERVER
	CRYPT_SESSION_SCEP
	CRYPT_SESSION_SCEP_SERVER
	CRYPT_SESSION_LAST
end enum


enum CRYPT_USER_TYPE
	CRYPT_USER_NONE
	CRYPT_USER_NORMAL
	CRYPT_USER_SO
	CRYPT_USER_CA
	CRYPT_USER_LAST
end enum


enum CRYPT_ATTRIBUTE_TYPE
	CRYPT_ATTRIBUTE_NONE
	CRYPT_PROPERTY_FIRST
	CRYPT_PROPERTY_HIGHSECURITY
	CRYPT_PROPERTY_OWNER
	CRYPT_PROPERTY_FORWARDCOUNT
	CRYPT_PROPERTY_LOCKED
	CRYPT_PROPERTY_USAGECOUNT
	CRYPT_PROPERTY_NONEXPORTABLE
	CRYPT_PROPERTY_LAST
	CRYPT_GENERIC_FIRST
	CRYPT_ATTRIBUTE_ERRORTYPE
	CRYPT_ATTRIBUTE_ERRORLOCUS
	CRYPT_ATTRIBUTE_INT_ERRORCODE
	CRYPT_ATTRIBUTE_INT_ERRORMESSAGE
	CRYPT_ATTRIBUTE_BUFFERSIZE
	CRYPT_GENERIC_LAST
	CRYPT_OPTION_FIRST = 100
	CRYPT_OPTION_INFO_DESCRIPTION
	CRYPT_OPTION_INFO_COPYRIGHT
	CRYPT_OPTION_INFO_MAJORVERSION
	CRYPT_OPTION_INFO_MINORVERSION
	CRYPT_OPTION_INFO_STEPPING
	CRYPT_OPTION_ENCR_ALGO
	CRYPT_OPTION_ENCR_HASH
	CRYPT_OPTION_ENCR_MAC
	CRYPT_OPTION_PKC_ALGO
	CRYPT_OPTION_PKC_KEYSIZE
	CRYPT_OPTION_SIG_ALGO
	CRYPT_OPTION_SIG_KEYSIZE
	CRYPT_OPTION_KEYING_ALGO
	CRYPT_OPTION_KEYING_ITERATIONS
	CRYPT_OPTION_CERT_SIGNUNRECOGNISEDATTRIBUTES
	CRYPT_OPTION_CERT_VALIDITY
	CRYPT_OPTION_CERT_UPDATEINTERVAL
	CRYPT_OPTION_CERT_COMPLIANCELEVEL
	CRYPT_OPTION_CMS_DEFAULTATTRIBUTES
	CRYPT_OPTION_SMIME_DEFAULTATTRIBUTES = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES
	CRYPT_OPTION_KEYS_LDAP_OBJECTCLASS
	CRYPT_OPTION_KEYS_LDAP_OBJECTTYPE
	CRYPT_OPTION_KEYS_LDAP_FILTER
	CRYPT_OPTION_KEYS_LDAP_CACERTNAME
	CRYPT_OPTION_KEYS_LDAP_CERTNAME
	CRYPT_OPTION_KEYS_LDAP_CRLNAME
	CRYPT_OPTION_KEYS_LDAP_EMAILNAME
	CRYPT_OPTION_DEVICE_PKCS11_DVR01
	CRYPT_OPTION_DEVICE_PKCS11_DVR02
	CRYPT_OPTION_DEVICE_PKCS11_DVR03
	CRYPT_OPTION_DEVICE_PKCS11_DVR04
	CRYPT_OPTION_DEVICE_PKCS11_DVR05
	CRYPT_OPTION_DEVICE_PKCS11_HARDWAREONLY
	CRYPT_OPTION_NET_SOCKS_SERVER
	CRYPT_OPTION_NET_SOCKS_USERNAME
	CRYPT_OPTION_NET_HTTP_PROXY
	CRYPT_OPTION_NET_CONNECTTIMEOUT
	CRYPT_OPTION_NET_TIMEOUT
	CRYPT_OPTION_MISC_ASYNCINIT
	CRYPT_OPTION_MISC_SIDECHANNELPROTECTION
	CRYPT_OPTION_CONFIGCHANGED
	CRYPT_OPTION_SELFTESTOK
	CRYPT_OPTION_LAST
	CRYPT_CTXINFO_FIRST = 1000
	CRYPT_CTXINFO_ALGO
	CRYPT_CTXINFO_MODE
	CRYPT_CTXINFO_NAME_ALGO
	CRYPT_CTXINFO_NAME_MODE
	CRYPT_CTXINFO_KEYSIZE
	CRYPT_CTXINFO_BLOCKSIZE
	CRYPT_CTXINFO_IVSIZE
	CRYPT_CTXINFO_KEYING_ALGO
	CRYPT_CTXINFO_KEYING_ITERATIONS
	CRYPT_CTXINFO_KEYING_SALT
	CRYPT_CTXINFO_KEYING_VALUE
	CRYPT_CTXINFO_KEY
	CRYPT_CTXINFO_KEY_COMPONENTS
	CRYPT_CTXINFO_IV
	CRYPT_CTXINFO_HASHVALUE
	CRYPT_CTXINFO_LABEL
	CRYPT_CTXINFO_LAST
	CRYPT_CERTINFO_FIRST = 2000
	CRYPT_CERTINFO_SELFSIGNED
	CRYPT_CERTINFO_IMMUTABLE
	CRYPT_CERTINFO_XYZZY
	CRYPT_CERTINFO_CERTTYPE
	CRYPT_CERTINFO_FINGERPRINT
	CRYPT_CERTINFO_FINGERPRINT_MD5 = CRYPT_CERTINFO_FINGERPRINT
	CRYPT_CERTINFO_FINGERPRINT_SHA
	CRYPT_CERTINFO_CURRENT_CERTIFICATE
	CRYPT_CERTINFO_CURRENT_EXTENSION
	CRYPT_CERTINFO_CURRENT_FIELD
	CRYPT_CERTINFO_CURRENT_COMPONENT
	CRYPT_CERTINFO_TRUSTED_USAGE
	CRYPT_CERTINFO_TRUSTED_IMPLICIT
	CRYPT_CERTINFO_SIGNATURELEVEL
	CRYPT_CERTINFO_VERSION
	CRYPT_CERTINFO_SERIALNUMBER
	CRYPT_CERTINFO_SUBJECTPUBLICKEYINFO
	CRYPT_CERTINFO_CERTIFICATE
	CRYPT_CERTINFO_USERCERTIFICATE = CRYPT_CERTINFO_CERTIFICATE
	CRYPT_CERTINFO_CACERTIFICATE
	CRYPT_CERTINFO_ISSUERNAME
	CRYPT_CERTINFO_VALIDFROM
	CRYPT_CERTINFO_VALIDTO
	CRYPT_CERTINFO_SUBJECTNAME
	CRYPT_CERTINFO_ISSUERUNIQUEID
	CRYPT_CERTINFO_SUBJECTUNIQUEID
	CRYPT_CERTINFO_CERTREQUEST
	CRYPT_CERTINFO_THISUPDATE
	CRYPT_CERTINFO_NEXTUPDATE
	CRYPT_CERTINFO_REVOCATIONDATE
	CRYPT_CERTINFO_REVOCATIONSTATUS
	CRYPT_CERTINFO_CERTSTATUS
	CRYPT_CERTINFO_DN
	CRYPT_CERTINFO_PKIUSER_ID
	CRYPT_CERTINFO_PKIUSER_ISSUEPASSWORD
	CRYPT_CERTINFO_PKIUSER_REVPASSWORD
	CRYPT_CERTINFO_COUNTRYNAME = CRYPT_CERTINFO_FIRST+100
	CRYPT_CERTINFO_STATEORPROVINCENAME
	CRYPT_CERTINFO_LOCALITYNAME
	CRYPT_CERTINFO_ORGANIZATIONNAME
	CRYPT_CERTINFO_ORGANISATIONNAME = CRYPT_CERTINFO_ORGANIZATIONNAME
	CRYPT_CERTINFO_ORGANIZATIONALUNITNAME
	CRYPT_CERTINFO_ORGANISATIONALUNITNAME = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME
	CRYPT_CERTINFO_COMMONNAME
	CRYPT_CERTINFO_OTHERNAME_TYPEID
	CRYPT_CERTINFO_OTHERNAME_VALUE
	CRYPT_CERTINFO_RFC822NAME
	CRYPT_CERTINFO_EMAIL = CRYPT_CERTINFO_RFC822NAME
	CRYPT_CERTINFO_DNSNAME
	CRYPT_CERTINFO_DIRECTORYNAME
	CRYPT_CERTINFO_EDIPARTYNAME_NAMEASSIGNER
	CRYPT_CERTINFO_EDIPARTYNAME_PARTYNAME
	CRYPT_CERTINFO_UNIFORMRESOURCEIDENTIFIER
	CRYPT_CERTINFO_IPADDRESS
	CRYPT_CERTINFO_REGISTEREDID
	CRYPT_CERTINFO_CHALLENGEPASSWORD = CRYPT_CERTINFO_FIRST+200
	CRYPT_CERTINFO_CRLEXTREASON
	CRYPT_CERTINFO_KEYFEATURES
	CRYPT_CERTINFO_AUTHORITYINFOACCESS
	CRYPT_CERTINFO_AUTHORITYINFO_RTCS
	CRYPT_CERTINFO_AUTHORITYINFO_OCSP
	CRYPT_CERTINFO_AUTHORITYINFO_CAISSUERS
	CRYPT_CERTINFO_AUTHORITYINFO_TIMESTAMPING
	CRYPT_CERTINFO_OCSP_NONCE
	CRYPT_CERTINFO_OCSP_RESPONSE
	CRYPT_CERTINFO_OCSP_RESPONSE_OCSP
	CRYPT_CERTINFO_OCSP_NOCHECK
	CRYPT_CERTINFO_OCSP_ARCHIVECUTOFF
	CRYPT_CERTINFO_SUBJECTINFOACCESS
	CRYPT_CERTINFO_SUBJECTINFO_CAREPOSITORY
	CRYPT_CERTINFO_SUBJECTINFO_TIMESTAMPING
	CRYPT_CERTINFO_SIGG_DATEOFCERTGEN
	CRYPT_CERTINFO_SIGG_PROCURATION
	CRYPT_CERTINFO_SIGG_PROCURE_COUNTRY
	CRYPT_CERTINFO_SIGG_PROCURE_TYPEOFSUBSTITUTION
	CRYPT_CERTINFO_SIGG_PROCURE_SIGNINGFOR
	CRYPT_CERTINFO_SIGG_MONETARYLIMIT
	CRYPT_CERTINFO_SIGG_MONETARY_CURRENCY
	CRYPT_CERTINFO_SIGG_MONETARY_AMOUNT
	CRYPT_CERTINFO_SIGG_MONETARY_EXPONENT
	CRYPT_CERTINFO_SIGG_RESTRICTION
	CRYPT_CERTINFO_STRONGEXTRANET
	CRYPT_CERTINFO_STRONGEXTRANET_ZONE
	CRYPT_CERTINFO_STRONGEXTRANET_ID
	CRYPT_CERTINFO_SUBJECTDIRECTORYATTRIBUTES
	CRYPT_CERTINFO_SUBJECTDIR_TYPE
	CRYPT_CERTINFO_SUBJECTDIR_VALUES
	CRYPT_CERTINFO_SUBJECTKEYIDENTIFIER
	CRYPT_CERTINFO_KEYUSAGE
	CRYPT_CERTINFO_PRIVATEKEYUSAGEPERIOD
	CRYPT_CERTINFO_PRIVATEKEY_NOTBEFORE
	CRYPT_CERTINFO_PRIVATEKEY_NOTAFTER
	CRYPT_CERTINFO_SUBJECTALTNAME
	CRYPT_CERTINFO_ISSUERALTNAME
	CRYPT_CERTINFO_BASICCONSTRAINTS
	CRYPT_CERTINFO_CA
	CRYPT_CERTINFO_AUTHORITY = CRYPT_CERTINFO_CA
	CRYPT_CERTINFO_PATHLENCONSTRAINT
	CRYPT_CERTINFO_CRLNUMBER
	CRYPT_CERTINFO_CRLREASON
	CRYPT_CERTINFO_HOLDINSTRUCTIONCODE
	CRYPT_CERTINFO_INVALIDITYDATE
	CRYPT_CERTINFO_DELTACRLINDICATOR
	CRYPT_CERTINFO_ISSUINGDISTRIBUTIONPOINT
	CRYPT_CERTINFO_ISSUINGDIST_FULLNAME
	CRYPT_CERTINFO_ISSUINGDIST_USERCERTSONLY
	CRYPT_CERTINFO_ISSUINGDIST_CACERTSONLY
	CRYPT_CERTINFO_ISSUINGDIST_SOMEREASONSONLY
	CRYPT_CERTINFO_ISSUINGDIST_INDIRECTCRL
	CRYPT_CERTINFO_CERTIFICATEISSUER
	CRYPT_CERTINFO_NAMECONSTRAINTS
	CRYPT_CERTINFO_PERMITTEDSUBTREES
	CRYPT_CERTINFO_EXCLUDEDSUBTREES
	CRYPT_CERTINFO_CRLDISTRIBUTIONPOINT
	CRYPT_CERTINFO_CRLDIST_FULLNAME
	CRYPT_CERTINFO_CRLDIST_REASONS
	CRYPT_CERTINFO_CRLDIST_CRLISSUER
	CRYPT_CERTINFO_CERTIFICATEPOLICIES
	CRYPT_CERTINFO_CERTPOLICYID
	CRYPT_CERTINFO_CERTPOLICY_CPSURI
	CRYPT_CERTINFO_CERTPOLICY_ORGANIZATION
	CRYPT_CERTINFO_CERTPOLICY_NOTICENUMBERS
	CRYPT_CERTINFO_CERTPOLICY_EXPLICITTEXT
	CRYPT_CERTINFO_POLICYMAPPINGS
	CRYPT_CERTINFO_ISSUERDOMAINPOLICY
	CRYPT_CERTINFO_SUBJECTDOMAINPOLICY
	CRYPT_CERTINFO_AUTHORITYKEYIDENTIFIER
	CRYPT_CERTINFO_AUTHORITY_KEYIDENTIFIER
	CRYPT_CERTINFO_AUTHORITY_CERTISSUER
	CRYPT_CERTINFO_AUTHORITY_CERTSERIALNUMBER
	CRYPT_CERTINFO_POLICYCONSTRAINTS
	CRYPT_CERTINFO_REQUIREEXPLICITPOLICY
	CRYPT_CERTINFO_INHIBITPOLICYMAPPING
	CRYPT_CERTINFO_EXTKEYUSAGE
	CRYPT_CERTINFO_EXTKEY_MS_INDIVIDUALCODESIGNING
	CRYPT_CERTINFO_EXTKEY_MS_COMMERCIALCODESIGNING
	CRYPT_CERTINFO_EXTKEY_MS_CERTTRUSTLISTSIGNING
	CRYPT_CERTINFO_EXTKEY_MS_TIMESTAMPSIGNING
	CRYPT_CERTINFO_EXTKEY_MS_SERVERGATEDCRYPTO
	CRYPT_CERTINFO_EXTKEY_MS_ENCRYPTEDFILESYSTEM
	CRYPT_CERTINFO_EXTKEY_SERVERAUTH
	CRYPT_CERTINFO_EXTKEY_CLIENTAUTH
	CRYPT_CERTINFO_EXTKEY_CODESIGNING
	CRYPT_CERTINFO_EXTKEY_EMAILPROTECTION
	CRYPT_CERTINFO_EXTKEY_IPSECENDSYSTEM
	CRYPT_CERTINFO_EXTKEY_IPSECTUNNEL
	CRYPT_CERTINFO_EXTKEY_IPSECUSER
	CRYPT_CERTINFO_EXTKEY_TIMESTAMPING
	CRYPT_CERTINFO_EXTKEY_OCSPSIGNING
	CRYPT_CERTINFO_EXTKEY_DIRECTORYSERVICE
	CRYPT_CERTINFO_EXTKEY_NS_SERVERGATEDCRYPTO
	CRYPT_CERTINFO_EXTKEY_VS_SERVERGATEDCRYPTO_CA
	CRYPT_CERTINFO_FRESHESTCRL
	CRYPT_CERTINFO_FRESHESTCRL_FULLNAME
	CRYPT_CERTINFO_FRESHESTCRL_REASONS
	CRYPT_CERTINFO_FRESHESTCRL_CRLISSUER
	CRYPT_CERTINFO_INHIBITANYPOLICY
	CRYPT_CERTINFO_NS_CERTTYPE
	CRYPT_CERTINFO_NS_BASEURL
	CRYPT_CERTINFO_NS_REVOCATIONURL
	CRYPT_CERTINFO_NS_CAREVOCATIONURL
	CRYPT_CERTINFO_NS_CERTRENEWALURL
	CRYPT_CERTINFO_NS_CAPOLICYURL
	CRYPT_CERTINFO_NS_SSLSERVERNAME
	CRYPT_CERTINFO_NS_COMMENT
	CRYPT_CERTINFO_SET_HASHEDROOTKEY
	CRYPT_CERTINFO_SET_ROOTKEYTHUMBPRINT
	CRYPT_CERTINFO_SET_CERTIFICATETYPE
	CRYPT_CERTINFO_SET_MERCHANTDATA
	CRYPT_CERTINFO_SET_MERID
	CRYPT_CERTINFO_SET_MERACQUIRERBIN
	CRYPT_CERTINFO_SET_MERCHANTLANGUAGE
	CRYPT_CERTINFO_SET_MERCHANTNAME
	CRYPT_CERTINFO_SET_MERCHANTCITY
	CRYPT_CERTINFO_SET_MERCHANTSTATEPROVINCE
	CRYPT_CERTINFO_SET_MERCHANTPOSTALCODE
	CRYPT_CERTINFO_SET_MERCHANTCOUNTRYNAME
	CRYPT_CERTINFO_SET_MERCOUNTRY
	CRYPT_CERTINFO_SET_MERAUTHFLAG
	CRYPT_CERTINFO_SET_CERTCARDREQUIRED
	CRYPT_CERTINFO_SET_TUNNELING
	CRYPT_CERTINFO_SET_TUNNELLING = CRYPT_CERTINFO_SET_TUNNELING
	CRYPT_CERTINFO_SET_TUNNELINGFLAG
	CRYPT_CERTINFO_SET_TUNNELLINGFLAG = CRYPT_CERTINFO_SET_TUNNELINGFLAG
	CRYPT_CERTINFO_SET_TUNNELINGALGID
	CRYPT_CERTINFO_SET_TUNNELLINGALGID = CRYPT_CERTINFO_SET_TUNNELINGALGID
	CRYPT_CERTINFO_CMS_CONTENTTYPE = CRYPT_CERTINFO_FIRST+500
	CRYPT_CERTINFO_CMS_MESSAGEDIGEST
	CRYPT_CERTINFO_CMS_SIGNINGTIME
	CRYPT_CERTINFO_CMS_COUNTERSIGNATURE
	CRYPT_CERTINFO_CMS_SMIMECAPABILITIES
	CRYPT_CERTINFO_CMS_SMIMECAP_3DES
	CRYPT_CERTINFO_CMS_SMIMECAP_AES
	CRYPT_CERTINFO_CMS_SMIMECAP_CAST128
	CRYPT_CERTINFO_CMS_SMIMECAP_IDEA
	CRYPT_CERTINFO_CMS_SMIMECAP_RC2
	CRYPT_CERTINFO_CMS_SMIMECAP_RC5
	CRYPT_CERTINFO_CMS_SMIMECAP_SKIPJACK
	CRYPT_CERTINFO_CMS_SMIMECAP_DES
	CRYPT_CERTINFO_CMS_SMIMECAP_PREFERSIGNEDDATA
	CRYPT_CERTINFO_CMS_SMIMECAP_CANNOTDECRYPTANY
	CRYPT_CERTINFO_CMS_RECEIPTREQUEST
	CRYPT_CERTINFO_CMS_RECEIPT_CONTENTIDENTIFIER
	CRYPT_CERTINFO_CMS_RECEIPT_FROM
	CRYPT_CERTINFO_CMS_RECEIPT_TO
	CRYPT_CERTINFO_CMS_SECURITYLABEL
	CRYPT_CERTINFO_CMS_SECLABEL_CLASSIFICATION
	CRYPT_CERTINFO_CMS_SECLABEL_POLICY
	CRYPT_CERTINFO_CMS_SECLABEL_PRIVACYMARK
	CRYPT_CERTINFO_CMS_SECLABEL_CATTYPE
	CRYPT_CERTINFO_CMS_SECLABEL_CATVALUE
	CRYPT_CERTINFO_CMS_MLEXPANSIONHISTORY
	CRYPT_CERTINFO_CMS_MLEXP_ENTITYIDENTIFIER
	CRYPT_CERTINFO_CMS_MLEXP_TIME
	CRYPT_CERTINFO_CMS_MLEXP_NONE
	CRYPT_CERTINFO_CMS_MLEXP_INSTEADOF
	CRYPT_CERTINFO_CMS_MLEXP_INADDITIONTO
	CRYPT_CERTINFO_CMS_CONTENTHINTS
	CRYPT_CERTINFO_CMS_CONTENTHINT_DESCRIPTION
	CRYPT_CERTINFO_CMS_CONTENTHINT_TYPE
	CRYPT_CERTINFO_CMS_EQUIVALENTLABEL
	CRYPT_CERTINFO_CMS_EQVLABEL_POLICY
	CRYPT_CERTINFO_CMS_EQVLABEL_CLASSIFICATION
	CRYPT_CERTINFO_CMS_EQVLABEL_PRIVACYMARK
	CRYPT_CERTINFO_CMS_EQVLABEL_CATTYPE
	CRYPT_CERTINFO_CMS_EQVLABEL_CATVALUE
	CRYPT_CERTINFO_CMS_SIGNINGCERTIFICATE
	CRYPT_CERTINFO_CMS_SIGNINGCERT_ESSCERTID
	CRYPT_CERTINFO_CMS_SIGNINGCERT_POLICIES
	CRYPT_CERTINFO_CMS_SIGTYPEIDENTIFIER
	CRYPT_CERTINFO_CMS_SIGTYPEID_ORIGINATORSIG
	CRYPT_CERTINFO_CMS_SIGTYPEID_DOMAINSIG
	CRYPT_CERTINFO_CMS_SIGTYPEID_ADDITIONALATTRIBUTES
	CRYPT_CERTINFO_CMS_SIGTYPEID_REVIEWSIG
	CRYPT_CERTINFO_CMS_NONCE
	CRYPT_CERTINFO_SCEP_MESSAGETYPE
	CRYPT_CERTINFO_SCEP_PKISTATUS
	CRYPT_CERTINFO_SCEP_FAILINFO
	CRYPT_CERTINFO_SCEP_SENDERNONCE
	CRYPT_CERTINFO_SCEP_RECIPIENTNONCE
	CRYPT_CERTINFO_SCEP_TRANSACTIONID
	CRYPT_CERTINFO_CMS_SPCAGENCYINFO
	CRYPT_CERTINFO_CMS_SPCAGENCYURL
	CRYPT_CERTINFO_CMS_SPCSTATEMENTTYPE
	CRYPT_CERTINFO_CMS_SPCSTMT_INDIVIDUALCODESIGNING
	CRYPT_CERTINFO_CMS_SPCSTMT_COMMERCIALCODESIGNING
	CRYPT_CERTINFO_CMS_SPCOPUSINFO
	CRYPT_CERTINFO_CMS_SPCOPUSINFO_NAME
	CRYPT_CERTINFO_CMS_SPCOPUSINFO_URL
	CRYPT_CERTINFO_LAST
	CRYPT_KEYINFO_FIRST = 3000
	CRYPT_KEYINFO_QUERY
	CRYPT_KEYINFO_QUERY_REQUESTS
	CRYPT_KEYINFO_LAST
	CRYPT_DEVINFO_FIRST = 4000
	CRYPT_DEVINFO_INITIALISE
	CRYPT_DEVINFO_INITIALIZE = CRYPT_DEVINFO_INITIALISE
	CRYPT_DEVINFO_AUTHENT_USER
	CRYPT_DEVINFO_AUTHENT_SUPERVISOR
	CRYPT_DEVINFO_SET_AUTHENT_USER
	CRYPT_DEVINFO_SET_AUTHENT_SUPERVISOR
	CRYPT_DEVINFO_ZEROISE
	CRYPT_DEVINFO_ZEROIZE = CRYPT_DEVINFO_ZEROISE
	CRYPT_DEVINFO_LOGGEDIN
	CRYPT_DEVINFO_LABEL
	CRYPT_DEVINFO_LAST
	CRYPT_ENVINFO_FIRST = 5000
	CRYPT_ENVINFO_DATASIZE
	CRYPT_ENVINFO_COMPRESSION
	CRYPT_ENVINFO_CONTENTTYPE
	CRYPT_ENVINFO_DETACHEDSIGNATURE
	CRYPT_ENVINFO_SIGNATURE_RESULT
	CRYPT_ENVINFO_MAC
	CRYPT_ENVINFO_CURRENT_COMPONENT
	CRYPT_ENVINFO_PASSWORD
	CRYPT_ENVINFO_KEY
	CRYPT_ENVINFO_SIGNATURE
	CRYPT_ENVINFO_SIGNATURE_EXTRADATA
	CRYPT_ENVINFO_RECIPIENT
	CRYPT_ENVINFO_PUBLICKEY
	CRYPT_ENVINFO_PRIVATEKEY
	CRYPT_ENVINFO_PRIVATEKEY_LABEL
	CRYPT_ENVINFO_ORIGINATOR
	CRYPT_ENVINFO_SESSIONKEY
	CRYPT_ENVINFO_HASH
	CRYPT_ENVINFO_TIMESTAMP_AUTHORITY
	CRYPT_ENVINFO_KEYSET_SIGCHECK
	CRYPT_ENVINFO_KEYSET_ENCRYPT
	CRYPT_ENVINFO_KEYSET_DECRYPT
	CRYPT_ENVINFO_LAST
	CRYPT_SESSINFO_FIRST = 6000
	CRYPT_SESSINFO_ACTIVE
	CRYPT_SESSINFO_CONNECTIONACTIVE
	CRYPT_SESSINFO_USERNAME
	CRYPT_SESSINFO_PASSWORD
	CRYPT_SESSINFO_PRIVATEKEY
	CRYPT_SESSINFO_KEYSET
	CRYPT_SESSINFO_SERVER_NAME
	CRYPT_SESSINFO_SERVER_PORT
	CRYPT_SESSINFO_SERVER_FINGERPRINT
	CRYPT_SESSINFO_CLIENT_NAME
	CRYPT_SESSINFO_CLIENT_PORT
	CRYPT_SESSINFO_SESSION
	CRYPT_SESSINFO_NETWORKSOCKET
	CRYPT_SESSINFO_VERSION
	CRYPT_SESSINFO_REQUEST
	CRYPT_SESSINFO_RESPONSE
	CRYPT_SESSINFO_CACERTIFICATE
	CRYPT_SESSINFO_TSP_MSGIMPRINT
	CRYPT_SESSINFO_CMP_REQUESTTYPE
	CRYPT_SESSINFO_CMP_PKIBOOT
	CRYPT_SESSINFO_CMP_PRIVKEYSET
	CRYPT_SESSINFO_SSH_SUBSYSTEM
	CRYPT_SESSINFO_SSH_PORTFORWARD
	CRYPT_SESSINFO_LAST
	CRYPT_USERINFO_FIRST = 7000
	CRYPT_USERINFO_PASSWORD
	CRYPT_USERINFO_CAKEY_CERTSIGN
	CRYPT_USERINFO_CAKEY_CRLSIGN
	CRYPT_USERINFO_CAKEY_RTCSSIGN
	CRYPT_USERINFO_CAKEY_OCSPSIGN
	CRYPT_USERINFO_LAST
	CRYPT_ATTRIBUTE_LAST = CRYPT_USERINFO_LAST
end enum


#define CRYPT_KEYUSAGE_NONE &h000
#define CRYPT_KEYUSAGE_DIGITALSIGNATURE &h001
#define CRYPT_KEYUSAGE_NONREPUDIATION &h002
#define CRYPT_KEYUSAGE_KEYENCIPHERMENT &h004
#define CRYPT_KEYUSAGE_DATAENCIPHERMENT &h008
#define CRYPT_KEYUSAGE_KEYAGREEMENT &h010
#define CRYPT_KEYUSAGE_KEYCERTSIGN &h020
#define CRYPT_KEYUSAGE_CRLSIGN &h040
#define CRYPT_KEYUSAGE_ENCIPHERONLY &h080
#define CRYPT_KEYUSAGE_DECIPHERONLY &h100
#define CRYPT_KEYUSAGE_LAST &h200

enum 
	CRYPT_CRLREASON_UNSPECIFIED
	CRYPT_CRLREASON_KEYCOMPROMISE
	CRYPT_CRLREASON_CACOMPROMISE
	CRYPT_CRLREASON_AFFILIATIONCHANGED
	CRYPT_CRLREASON_SUPERSEDED
	CRYPT_CRLREASON_CESSATIONOFOPERATION
	CRYPT_CRLREASON_CERTIFICATEHOLD
	CRYPT_CRLREASON_REMOVEFROMCRL = 8
	CRYPT_CRLREASON_LAST
	CRYPT_CRLREASON_NEVERVALID = 10
	CRYPT_CRLEXTREASON_LAST
end enum

#define CRYPT_CRLREASONFLAG_UNUSED &h001
#define CRYPT_CRLREASONFLAG_KEYCOMPROMISE &h002
#define CRYPT_CRLREASONFLAG_CACOMPROMISE &h004
#define CRYPT_CRLREASONFLAG_AFFILIATIONCHANGED &h008
#define CRYPT_CRLREASONFLAG_SUPERSEDED &h010
#define CRYPT_CRLREASONFLAG_CESSATIONOFOPERATION &h020
#define CRYPT_CRLREASONFLAG_CERTIFICATEHOLD &h040
#define CRYPT_CRLREASONFLAG_LAST &h080

enum 
	CRYPT_HOLDINSTRUCTION_NONE
	CRYPT_HOLDINSTRUCTION_CALLISSUER
	CRYPT_HOLDINSTRUCTION_REJECT
	CRYPT_HOLDINSTRUCTION_PICKUPTOKEN
	CRYPT_HOLDINSTRUCTION_LAST
end enum

enum 
	CRYPT_COMPLIANCELEVEL_OBLIVIOUS
	CRYPT_COMPLIANCELEVEL_REDUCED
	CRYPT_COMPLIANCELEVEL_STANDARD
	CRYPT_COMPLIANCELEVEL_PKIX_PARTIAL
	CRYPT_COMPLIANCELEVEL_PKIX_FULL
	CRYPT_COMPLIANCELEVEL_LAST
end enum

#define CRYPT_NS_CERTTYPE_SSLCLIENT &h001
#define CRYPT_NS_CERTTYPE_SSLSERVER &h002
#define CRYPT_NS_CERTTYPE_SMIME &h004
#define CRYPT_NS_CERTTYPE_OBJECTSIGNING &h008
#define CRYPT_NS_CERTTYPE_RESERVED &h010
#define CRYPT_NS_CERTTYPE_SSLCA &h020
#define CRYPT_NS_CERTTYPE_SMIMECA &h040
#define CRYPT_NS_CERTTYPE_OBJECTSIGNINGCA &h080
#define CRYPT_NS_CERTTYPE_LAST &h100
#define CRYPT_SET_CERTTYPE_CARD &h001
#define CRYPT_SET_CERTTYPE_MER &h002
#define CRYPT_SET_CERTTYPE_PGWY &h004
#define CRYPT_SET_CERTTYPE_CCA &h008
#define CRYPT_SET_CERTTYPE_MCA &h010
#define CRYPT_SET_CERTTYPE_PCA &h020
#define CRYPT_SET_CERTTYPE_GCA &h040
#define CRYPT_SET_CERTTYPE_BCA &h080
#define CRYPT_SET_CERTTYPE_RCA &h100
#define CRYPT_SET_CERTTYPE_ACQ &h200
#define CRYPT_SET_CERTTYPE_LAST &h400

enum CRYPT_CONTENT_TYPE
	CRYPT_CONTENT_NONE
	CRYPT_CONTENT_DATA
	CRYPT_CONTENT_SIGNEDDATA
	CRYPT_CONTENT_ENVELOPEDDATA
	CRYPT_CONTENT_SIGNEDANDENVELOPEDDATA
	CRYPT_CONTENT_DIGESTEDDATA
	CRYPT_CONTENT_ENCRYPTEDDATA
	CRYPT_CONTENT_COMPRESSEDDATA
	CRYPT_CONTENT_TSTINFO
	CRYPT_CONTENT_SPCINDIRECTDATACONTEXT
	CRYPT_CONTENT_RTCSREQUEST
	CRYPT_CONTENT_RTCSRESPONSE
	CRYPT_CONTENT_RTCSRESPONSE_EXT
	CRYPT_CONTENT_LAST
end enum


enum 
	CRYPT_CLASSIFICATION_UNMARKED
	CRYPT_CLASSIFICATION_UNCLASSIFIED
	CRYPT_CLASSIFICATION_RESTRICTED
	CRYPT_CLASSIFICATION_CONFIDENTIAL
	CRYPT_CLASSIFICATION_SECRET
	CRYPT_CLASSIFICATION_TOP_SECRET
	CRYPT_CLASSIFICATION_LAST = 255
end enum

enum 
	CRYPT_CERTSTATUS_VALID
	CRYPT_CERTSTATUS_NOTVALID
	CRYPT_CERTSTATUS_NONAUTHORITATIVE
	CRYPT_CERTSTATUS_UNKNOWN
end enum

enum 
	CRYPT_OCSPSTATUS_NOTREVOKED
	CRYPT_OCSPSTATUS_REVOKED
	CRYPT_OCSPSTATUS_UNKNOWN
end enum

enum CRYPT_SIGNATURELEVEL_TYPE
	CRYPT_SIGNATURELEVEL_NONE
	CRYPT_SIGNATURELEVEL_SIGNERCERT
	CRYPT_SIGNATURELEVEL_ALL
	CRYPT_SIGNATURELEVEL_LAST
end enum


enum CRYPT_CERTFORMAT_TYPE
	CRYPT_CERTFORMAT_NONE
	CRYPT_CERTFORMAT_CERTIFICATE
	CRYPT_CERTFORMAT_CERTCHAIN
	CRYPT_CERTFORMAT_TEXT_CERTIFICATE
	CRYPT_CERTFORMAT_TEXT_CERTCHAIN
	CRYPT_CERTFORMAT_XML_CERTIFICATE
	CRYPT_CERTFORMAT_XML_CERTCHAIN
	CRYPT_CERTFORMAT_LAST
end enum


enum CRYPT_REQUESTTYPE_TYPE
	CRYPT_REQUESTTYPE_NONE
	CRYPT_REQUESTTYPE_INITIALISATION
	CRYPT_REQUESTTYPE_INITIALIZATION = CRYPT_REQUESTTYPE_INITIALISATION
	CRYPT_REQUESTTYPE_CERTIFICATE
	CRYPT_REQUESTTYPE_KEYUPDATE
	CRYPT_REQUESTTYPE_REVOCATION
	CRYPT_REQUESTTYPE_PKIBOOT
	CRYPT_REQUESTTYPE_LAST
end enum


enum CRYPT_KEYID_TYPE
	CRYPT_KEYID_NONE
	CRYPT_KEYID_NAME
	CRYPT_KEYID_EMAIL
	CRYPT_KEYID_LAST
end enum


enum CRYPT_OBJECT_TYPE
	CRYPT_OBJECT_NONE
	CRYPT_OBJECT_ENCRYPTED_KEY
	CRYPT_OBJECT_PKCENCRYPTED_KEY
	CRYPT_OBJECT_KEYAGREEMENT
	CRYPT_OBJECT_SIGNATURE
	CRYPT_OBJECT_LAST
end enum


enum CRYPT_ERRTYPE_TYPE
	CRYPT_ERRTYPE_NONE
	CRYPT_ERRTYPE_ATTR_SIZE
	CRYPT_ERRTYPE_ATTR_VALUE
	CRYPT_ERRTYPE_ATTR_ABSENT
	CRYPT_ERRTYPE_ATTR_PRESENT
	CRYPT_ERRTYPE_CONSTRAINT
	CRYPT_ERRTYPE_ISSUERCONSTRAINT
	CRYPT_ERRTYPE_LAST
end enum


enum CRYPT_CERTACTION_TYPE
	CRYPT_CERTACTION_NONE
	CRYPT_CERTACTION_CREATE
	CRYPT_CERTACTION_CONNECT
	CRYPT_CERTACTION_DISCONNECT
	CRYPT_CERTACTION_ERROR
	CRYPT_CERTACTION_ADDUSER
	CRYPT_CERTACTION_REQUEST_CERT
	CRYPT_CERTACTION_REQUEST_RENEWAL
	CRYPT_CERTACTION_REQUEST_REVOCATION
	CRYPT_CERTACTION_CERT_CREATION
	CRYPT_CERTACTION_CERT_CREATION_COMPLETE
	CRYPT_CERTACTION_CERT_CREATION_DROP
	CRYPT_CERTACTION_CERT_CREATION_REVERSE
	CRYPT_CERTACTION_RESTART_CLEANUP
	CRYPT_CERTACTION_RESTART_REVOKE_CERT
	CRYPT_CERTACTION_ISSUE_CERT
	CRYPT_CERTACTION_ISSUE_CRL
	CRYPT_CERTACTION_REVOKE_CERT
	CRYPT_CERTACTION_EXPIRE_CERT
	CRYPT_CERTACTION_CLEANUP
	CRYPT_CERTACTION_LAST
end enum


#define CRYPT_MAX_KEYSIZE 256
#define CRYPT_MAX_IVSIZE 32
#define CRYPT_MAX_PKCSIZE 512
#define CRYPT_MAX_HASHSIZE 32
#define CRYPT_MAX_TEXTSIZE 64
#define CRYPT_USE_DEFAULT -10
#define CRYPT_UNUSED -11
#define CRYPT_KEYTYPE_PRIVATE 0
#define CRYPT_KEYTYPE_PUBLIC 1
#define CRYPT_RANDOM_FASTPOLL -10
#define CRYPT_RANDOM_SLOWPOLL -11
#define CRYPT_CURSOR_FIRST -20
#define CRYPT_CURSOR_PREVIOUS -21
#define CRYPT_CURSOR_NEXT -22
#define CRYPT_CURSOR_LAST -23

enum CRYPT_KEYOPT_TYPE
	CRYPT_KEYOPT_NONE
	CRYPT_KEYOPT_READONLY
	CRYPT_KEYOPT_CREATE
	CRYPT_KEYOPT_LAST
end enum

type CRYPT_CERTIFICATE as integer
type CRYPT_CONTEXT as integer
type CRYPT_DEVICE as integer
type CRYPT_ENVELOPE as integer
type CRYPT_KEYSET as integer
type CRYPT_SESSION as integer
type CRYPT_USER as integer
type CRYPT_HANDLE as integer

type CRYPT_QUERY_INFO
	algoName as zstring * 64
	blockSize as integer
	minKeySize as integer
	keySize as integer
	maxKeySize as integer
end type

type CRYPT_OBJECT_INFO
	objectType as CRYPT_OBJECT_TYPE
	cryptAlgo as CRYPT_ALGO_TYPE
	cryptMode as CRYPT_MODE_TYPE
	hashAlgo as CRYPT_ALGO_TYPE
	salt(0 to 32-1) as ubyte
	saltSize as integer
end type

type CRYPT_PKCINFO_RSA
	isPublicKey as integer
	n(0 to 512-1) as ubyte
	nLen as integer
	e(0 to 512-1) as ubyte
	eLen as integer
	d(0 to 512-1) as ubyte
	dLen as integer
	p(0 to 512-1) as ubyte
	pLen as integer
	q(0 to 512-1) as ubyte
	qLen as integer
	u(0 to 512-1) as ubyte
	uLen as integer
	e1(0 to 512-1) as ubyte
	e1Len as integer
	e2(0 to 512-1) as ubyte
	e2Len as integer
end type

type CRYPT_PKCINFO_DLP
	isPublicKey as integer
	p(0 to 512-1) as ubyte
	pLen as integer
	q(0 to 512-1) as ubyte
	qLen as integer
	g(0 to 512-1) as ubyte
	gLen as integer
	y(0 to 512-1) as ubyte
	yLen as integer
	x(0 to 512-1) as ubyte
	xLen as integer
end type

#define CRYPT_OK 0
#define CRYPT_ERROR_PARAM1 -1
#define CRYPT_ERROR_PARAM2 -2
#define CRYPT_ERROR_PARAM3 -3
#define CRYPT_ERROR_PARAM4 -4
#define CRYPT_ERROR_PARAM5 -5
#define CRYPT_ERROR_PARAM6 -6
#define CRYPT_ERROR_PARAM7 -7
#define CRYPT_ERROR_MEMORY -10
#define CRYPT_ERROR_NOTINITED -11
#define CRYPT_ERROR_INITED -12
#define CRYPT_ERROR_NOSECURE -13
#define CRYPT_ERROR_RANDOM -14
#define CRYPT_ERROR_FAILED -15
#define CRYPT_ERROR_NOTAVAIL -20
#define CRYPT_ERROR_PERMISSION -21
#define CRYPT_ERROR_WRONGKEY -22
#define CRYPT_ERROR_INCOMPLETE -23
#define CRYPT_ERROR_COMPLETE -24
#define CRYPT_ERROR_TIMEOUT -25
#define CRYPT_ERROR_INVALID -26
#define CRYPT_ERROR_SIGNALLED -27
#define CRYPT_ERROR_OVERFLOW -30
#define CRYPT_ERROR_UNDERFLOW -31
#define CRYPT_ERROR_BADDATA -32
#define CRYPT_ERROR_SIGNATURE -33
#define CRYPT_ERROR_OPEN -40
#define CRYPT_ERROR_READ -41
#define CRYPT_ERROR_WRITE -42
#define CRYPT_ERROR_NOTFOUND -43
#define CRYPT_ERROR_DUPLICATE -44
#define CRYPT_ENVELOPE_RESOURCE -50

declare function cryptInit alias "cryptInit" () as integer
declare function cryptEnd alias "cryptEnd" () as integer
declare function cryptQueryCapability alias "cryptQueryCapability" (byval cryptAlgo as CRYPT_ALGO_TYPE, byval cryptQueryInfo as CRYPT_QUERY_INFO ptr) as integer
declare function cryptCreateContext alias "cryptCreateContext" (byval cryptContext as CRYPT_CONTEXT ptr, byval cryptUser as CRYPT_USER, byval cryptAlgo as CRYPT_ALGO_TYPE) as integer
declare function cryptDestroyContext alias "cryptDestroyContext" (byval cryptContext as CRYPT_CONTEXT) as integer
declare function cryptDestroyObject alias "cryptDestroyObject" (byval cryptObject as CRYPT_HANDLE) as integer
declare function cryptGenerateKey alias "cryptGenerateKey" (byval cryptContext as CRYPT_CONTEXT) as integer
declare function cryptGenerateKeyAsync alias "cryptGenerateKeyAsync" (byval cryptContext as CRYPT_CONTEXT) as integer
declare function cryptAsyncQuery alias "cryptAsyncQuery" (byval cryptObject as CRYPT_HANDLE) as integer
declare function cryptAsyncCancel alias "cryptAsyncCancel" (byval cryptObject as CRYPT_HANDLE) as integer
declare function cryptEncrypt alias "cryptEncrypt" (byval cryptContext as CRYPT_CONTEXT, byval buffer as any ptr, byval length as integer) as integer
declare function cryptDecrypt alias "cryptDecrypt" (byval cryptContext as CRYPT_CONTEXT, byval buffer as any ptr, byval length as integer) as integer
declare function cryptSetAttribute alias "cryptSetAttribute" (byval cryptHandle as CRYPT_HANDLE, byval attributeType as CRYPT_ATTRIBUTE_TYPE, byval value as integer) as integer
declare function cryptSetAttributeString alias "cryptSetAttributeString" (byval cryptHandle as CRYPT_HANDLE, byval attributeType as CRYPT_ATTRIBUTE_TYPE, byval value as any ptr, byval valueLength as integer) as integer
declare function cryptGetAttribute alias "cryptGetAttribute" (byval cryptHandle as CRYPT_HANDLE, byval attributeType as CRYPT_ATTRIBUTE_TYPE, byval value as integer ptr) as integer
declare function cryptGetAttributeString alias "cryptGetAttributeString" (byval cryptHandle as CRYPT_HANDLE, byval attributeType as CRYPT_ATTRIBUTE_TYPE, byval value as any ptr, byval valueLength as integer ptr) as integer
declare function cryptDeleteAttribute alias "cryptDeleteAttribute" (byval cryptHandle as CRYPT_HANDLE, byval attributeType as CRYPT_ATTRIBUTE_TYPE) as integer
declare function cryptAddRandom alias "cryptAddRandom" (byval randomData as any ptr, byval randomDataLength as integer) as integer
declare function cryptQueryObject alias "cryptQueryObject" (byval objectData as any ptr, byval cryptObjectInfo as CRYPT_OBJECT_INFO ptr) as integer
declare function cryptExportKey alias "cryptExportKey" (byval encryptedKey as any ptr, byval encryptedKeyLength as integer ptr, byval exportKey as CRYPT_HANDLE, byval sessionKeyContext as CRYPT_CONTEXT) as integer
declare function cryptExportKeyEx alias "cryptExportKeyEx" (byval encryptedKey as any ptr, byval encryptedKeyLength as integer ptr, byval formatType as CRYPT_FORMAT_TYPE, byval exportKey as CRYPT_HANDLE, byval sessionKeyContext as CRYPT_CONTEXT) as integer
declare function cryptImportKey alias "cryptImportKey" (byval encryptedKey as any ptr, byval importKey as CRYPT_CONTEXT, byval sessionKeyContext as CRYPT_CONTEXT) as integer
declare function cryptImportKeyEx alias "cryptImportKeyEx" (byval encryptedKey as any ptr, byval importKey as CRYPT_CONTEXT, byval sessionKeyContext as CRYPT_CONTEXT, byval returnedContext as CRYPT_CONTEXT ptr) as integer
declare function cryptCreateSignature alias "cryptCreateSignature" (byval signature as any ptr, byval signatureLength as integer ptr, byval signContext as CRYPT_CONTEXT, byval hashContext as CRYPT_CONTEXT) as integer
declare function cryptCreateSignatureEx alias "cryptCreateSignatureEx" (byval signature as any ptr, byval signatureLength as integer ptr, byval formatType as CRYPT_FORMAT_TYPE, byval signContext as CRYPT_CONTEXT, byval hashContext as CRYPT_CONTEXT, byval extraData as CRYPT_CERTIFICATE) as integer
declare function cryptCheckSignature alias "cryptCheckSignature" (byval signature as any ptr, byval sigCheckKey as CRYPT_HANDLE, byval hashContext as CRYPT_CONTEXT) as integer
declare function cryptCheckSignatureEx alias "cryptCheckSignatureEx" (byval signature as any ptr, byval sigCheckKey as CRYPT_HANDLE, byval hashContext as CRYPT_CONTEXT, byval extraData as CRYPT_HANDLE ptr) as integer
declare function cryptKeysetOpen alias "cryptKeysetOpen" (byval keyset as CRYPT_KEYSET ptr, byval cryptUser as CRYPT_USER, byval keysetType as CRYPT_KEYSET_TYPE, byval name as zstring ptr, byval options as CRYPT_KEYOPT_TYPE) as integer
declare function cryptKeysetClose alias "cryptKeysetClose" (byval keyset as CRYPT_KEYSET) as integer
declare function cryptGetPublicKey alias "cryptGetPublicKey" (byval keyset as CRYPT_KEYSET, byval cryptContext as CRYPT_CONTEXT ptr, byval keyIDtype as CRYPT_KEYID_TYPE, byval keyID as zstring ptr) as integer
declare function cryptGetPrivateKey alias "cryptGetPrivateKey" (byval keyset as CRYPT_KEYSET, byval cryptContext as CRYPT_CONTEXT ptr, byval keyIDtype as CRYPT_KEYID_TYPE, byval keyID as zstring ptr, byval password as zstring ptr) as integer
declare function cryptAddPublicKey alias "cryptAddPublicKey" (byval keyset as CRYPT_KEYSET, byval certificate as CRYPT_CERTIFICATE) as integer
declare function cryptAddPrivateKey alias "cryptAddPrivateKey" (byval keyset as CRYPT_KEYSET, byval cryptKey as CRYPT_HANDLE, byval password as zstring ptr) as integer
declare function cryptDeleteKey alias "cryptDeleteKey" (byval keyset as CRYPT_KEYSET, byval keyIDtype as CRYPT_KEYID_TYPE, byval keyID as zstring ptr) as integer
declare function cryptCreateCert alias "cryptCreateCert" (byval certificate as CRYPT_CERTIFICATE ptr, byval cryptUser as CRYPT_USER, byval certType as CRYPT_CERTTYPE_TYPE) as integer
declare function cryptDestroyCert alias "cryptDestroyCert" (byval certificate as CRYPT_CERTIFICATE) as integer
declare function cryptGetCertExtension alias "cryptGetCertExtension" (byval certificate as CRYPT_CERTIFICATE, byval oid as zstring ptr, byval criticalFlag as integer ptr, byval extension as any ptr, byval extensionLength as integer ptr) as integer
declare function cryptAddCertExtension alias "cryptAddCertExtension" (byval certificate as CRYPT_CERTIFICATE, byval oid as zstring ptr, byval criticalFlag as integer, byval extension as any ptr, byval extensionLength as integer) as integer
declare function cryptDeleteCertExtension alias "cryptDeleteCertExtension" (byval certificate as CRYPT_CERTIFICATE, byval oid as zstring ptr) as integer
declare function cryptSignCert alias "cryptSignCert" (byval certificate as CRYPT_CERTIFICATE, byval signContext as CRYPT_CONTEXT) as integer
declare function cryptCheckCert alias "cryptCheckCert" (byval certificate as CRYPT_CERTIFICATE, byval sigCheckKey as CRYPT_HANDLE) as integer
declare function cryptImportCert alias "cryptImportCert" (byval certObject as any ptr, byval certObjectLength as integer, byval cryptUser as CRYPT_USER, byval certificate as CRYPT_CERTIFICATE ptr) as integer
declare function cryptExportCert alias "cryptExportCert" (byval certObject as any ptr, byval certObjectLength as integer ptr, byval certFormatType as CRYPT_CERTFORMAT_TYPE, byval certificate as CRYPT_CERTIFICATE) as integer
declare function cryptCAAddItem alias "cryptCAAddItem" (byval keyset as CRYPT_KEYSET, byval certificate as CRYPT_CERTIFICATE) as integer
declare function cryptCAGetItem alias "cryptCAGetItem" (byval keyset as CRYPT_KEYSET, byval certificate as CRYPT_CERTIFICATE ptr, byval certType as CRYPT_CERTTYPE_TYPE, byval keyIDtype as CRYPT_KEYID_TYPE, byval keyID as zstring ptr) as integer
declare function cryptCADeleteItem alias "cryptCADeleteItem" (byval keyset as CRYPT_KEYSET, byval keyIDtype as CRYPT_KEYID_TYPE, byval keyID as zstring ptr) as integer
declare function cryptCACertManagement alias "cryptCACertManagement" (byval certificate as CRYPT_CERTIFICATE ptr, byval action as CRYPT_CERTACTION_TYPE, byval keyset as CRYPT_KEYSET, byval caKey as CRYPT_CONTEXT, byval certRequest as CRYPT_CERTIFICATE) as integer
declare function cryptCreateEnvelope alias "cryptCreateEnvelope" (byval envelope as CRYPT_ENVELOPE ptr, byval cryptUser as CRYPT_USER, byval formatType as CRYPT_FORMAT_TYPE) as integer
declare function cryptDestroyEnvelope alias "cryptDestroyEnvelope" (byval envelope as CRYPT_ENVELOPE) as integer
declare function cryptCreateSession alias "cryptCreateSession" (byval session as CRYPT_SESSION ptr, byval cryptUser as CRYPT_USER, byval formatType as CRYPT_SESSION_TYPE) as integer
declare function cryptDestroySession alias "cryptDestroySession" (byval session as CRYPT_SESSION) as integer
declare function cryptPushData alias "cryptPushData" (byval envelope as CRYPT_HANDLE, byval buffer as any ptr, byval length as integer, byval bytesCopied as integer ptr) as integer
declare function cryptFlushData alias "cryptFlushData" (byval envelope as CRYPT_HANDLE) as integer
declare function cryptPopData alias "cryptPopData" (byval envelope as CRYPT_HANDLE, byval buffer as any ptr, byval length as integer, byval bytesCopied as integer ptr) as integer
declare function cryptDeviceOpen alias "cryptDeviceOpen" (byval device as CRYPT_DEVICE ptr, byval cryptUser as CRYPT_USER, byval deviceType as CRYPT_DEVICE_TYPE, byval name as zstring ptr) as integer
declare function cryptDeviceClose alias "cryptDeviceClose" (byval device as CRYPT_DEVICE) as integer
declare function cryptDeviceQueryCapability alias "cryptDeviceQueryCapability" (byval device as CRYPT_DEVICE, byval cryptAlgo as CRYPT_ALGO_TYPE, byval cryptQueryInfo as CRYPT_QUERY_INFO ptr) as integer
declare function cryptDeviceCreateContext alias "cryptDeviceCreateContext" (byval device as CRYPT_DEVICE, byval cryptContext as CRYPT_CONTEXT ptr, byval cryptAlgo as CRYPT_ALGO_TYPE) as integer
declare function cryptLogin alias "cryptLogin" (byval user as CRYPT_USER ptr, byval name as zstring ptr, byval password as zstring ptr) as integer
declare function cryptLogout alias "cryptLogout" (byval user as CRYPT_USER) as integer

#endif
