#This challenge is about famous houses in the pretty town of Brigadoon

distances=c(51,65,175,196,197,125,10,56)	#distances of 8 houses from the town centre in m
bearings=c(10,8,210,25,74,128,235,335)		#bearings of the houses in degrees

#an important point about variables:
#a) always give them descriptive names ("x" is not very informative to someone else looking at your code)
#b) R allows different kinds of variables: scalars and vectors (aka. arrays)
#   scalars are single numbers e.g. x=3
#   vectors are many numbers in an ordered list, e.g. distances and bearings above, and the "c" bit at the start is required by R to tell it that a vector is in the brackets.

xpos=distances*sin(bearings*pi/180)		#in sin and cos the argument MUST be in radians
ypos=distances*cos(bearings*pi/180)		#nb. these are vector calculations - all numbers in distances and bearings are involved

plot(y=ypos,x=xpos,main="Famous Houses in Brigadoon",xlim=c(-200,200),ylim=c(-200,200),xlab="metres east",ylab="metres north")
abline(h=0,lty=1);abline(v=0,lty=1)

numpoints=length(distances)
if (numpoints!=length(bearings)) {stop("the number of bearings and distances don't match")}
nnd=rep(sqrt(2*400*400),times=numpoints)	#start with the maximum possible distance
for (i in 1:numpoints) {	
 for (j in 1:numpoints) {
  if (i!=j) {		#"!=" means "not equal to"
   diffx=abs(xpos[i]-xpos[j])
   diffy=abs(ypos[i]-ypos[j])
   nd=sqrt((diffx^2)+(diffy^2))
   if (nd<nnd[i]) {nnd[i]=nd}
  }
 }
}
cat("Here is the NND for each house in turn:\n")
print(data.frame(xpos,ypos,nnd))
