#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

#LCA (Latent Class Analysis) - model klas ukrytych
#Estymacja modelu z wykorzystaniem pakietu poLCA
#Dane symulacyjne - wartoci nominalnych (dychotomicznych) zmiennych obserwowanych 1 lub 2, wartoci zmiennych towarzyszcych o rozkadzie normalnym
#Cel analizy: wybr modelu na podstawie kryteriw informacyjnych AIC i BIC
library(poLCA)
options(OutDec=",")
#Generowanie danych, 6 zmiennych obserwowanych dychotomicznych Y1-Y6, 3 zmienne towarzyszce X1-X3
set.seed(1234)
probs<-list(matrix(c(0.1,0.9, 0.6,0.4, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.5,0.5, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.4,0.6, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.5,0.5, 0.8,0.2),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.4,0.6, 0.9,0.1),ncol=2,byrow=TRUE), 
            matrix(c(0.2,0.8, 0.5,0.5, 0.8,0.2),ncol=2,byrow=TRUE))
danesym1<-poLCA.simdata(N=100,probs,ndv=6,niv=3)
print(danesym1$dat[1:20,])
#Model 1 - zmienne obserwowane Y1-Y6, bez zmiennych towarzyszcych, 3 klasy
model1<-cbind(Y1,Y2,Y3,Y4,Y5,Y6)~1
lc3<-poLCA(model1,danesym1$dat,nclass=3,nrep=3,verbose=FALSE)
probs.start<-poLCA.reorder(lc3$probs.start,order(lc3$P,decreasing=FALSE))
lc3<-poLCA(model1,danesym1$dat,nclass=3,nrep=1,probs.start=probs.start,graph=FALSE,verbose=FALSE)
lc3m1<-c(lc3$llik,lc3$aic,lc3$bic)
p1<-cbind(lc3$probs$Y1[,1],lc3$probs$Y2[,1],lc3$probs$Y3[,1],lc3$probs$Y4[,1],lc3$probs$Y5[,1],lc3$probs$Y6[,1])
windows(width=8,height=8,pointsize=8)   #okno graficzne
par(mfrow=c(2,2),las=1)                 #4 wykresy
plot(c(1,6),c(0,1),xlab="Model (a), zmienne obserwowane (Y1-Y6)",ylab="Prawdopodobiestwa dla Y=1",type="n",col=1,yaxt="n",xaxt="n")
axis(1,at=seq(1,6,1),labels=seq(1,6,1),las=1)
axis(2,at=seq(0,1,0.2),labels=seq(0,1,.2),las=1)
for(k in 1:3){lines(c(1:6),p1[k,],col=k,lty=k)}
lines(c(1.0,1.5),c(0.6,0.6),col=1,lty=1)
text(2.0,0.6,"klasa 1")
lines(c(1.0,1.5),c(0.55,0.55),col=2,lty=2)
text(2.0,0.55,"klasa 2")
lines(c(1.0,1.5),c(0.5,0.5),col=3,lty=3)
text(2.0,0.50,"klasa 3")
#Model 2 - zmienne obserwowane Y1-Y6, 1 zmienna towarzyszca X1, 3 klasy
model2<-cbind(Y1,Y2,Y3,Y4,Y5,Y6)~X1
lc3<-poLCA(model2,danesym1$dat,nclass=3,nrep=3,verbose=FALSE)
probs.start<-poLCA.reorder(lc3$probs.start,order(lc3$P,decreasing=FALSE))
lc3<-poLCA(model2,danesym1$dat,nclass=3,nrep=1,probs.start=probs.start,graph=FALSE,verbose=FALSE)
lc3m2<-c(lc3$llik,lc3$aic,lc3$bic)
p1<-cbind(lc3$probs$Y1[,1],lc3$probs$Y2[,1],lc3$probs$Y3[,1],lc3$probs$Y4[,1],lc3$probs$Y5[,1],lc3$probs$Y6[,1])
plot(c(1,6),c(0,1),xlab="Model (b), zmienne: obserwowane (Y1-Y6), towarzyszca X1",ylab="Prawdopodobiestwa dla Y=1",type="n",col=1,yaxt="n",xaxt="n")
axis(1,at=seq(1,6,1),labels=seq(1,6,1),las=1)
axis(2,at=seq(0,1,0.2),labels=seq(0,1,0.2),las=1)
for(k in 1:3){lines(c(1:6),p1[k,],col=k,lty=k)}
lines(c(4.0,4.5),c(0.5,0.5),col=1,lty=1)
text(5.0,0.5,"klasa 1")
lines(c(4.0,4.5),c(0.45,0.45),col=2,lty=2)
text(5.0,0.45,"klasa 2")
lines(c(4.0,4.5),c(0.4,0.4),col=3,lty=3)
text(5.0,0.4,"klasa 3")
#Model 3 - zmienne obserwowane Y1-Y6, 2 zmienne towarzyszce X1, X2, 3 klasy
model3<-cbind(Y1,Y2,Y3,Y4,Y5,Y6)~X1+X2
lc3<-poLCA(model3,danesym1$dat,nclass=3,nrep=3,verbose=FALSE)
probs.start<-poLCA.reorder(lc3$probs.start,order(lc3$P, decreasing=FALSE))
lc3<-poLCA(model3,danesym1$dat,nclass=3,nrep=1,probs.start=probs.start,graph=FALSE,verbose=FALSE)
lc3m3<-c(lc3$llik,lc3$aic,lc3$bic)
p1<-cbind(lc3$probs$Y1[,1],lc3$probs$Y2[,1],lc3$probs$Y3[,1],lc3$probs$Y4[,1],lc3$probs$Y5[,1],lc3$probs$Y6[,1])
plot(c(1,6),c(0,1),xlab="Model (c), zmienne: obserwowane (Y1-Y6), towarzyszce X1, X2",ylab="Prawdopodobiestwa dla Y=1",type="n",col=1,yaxt="n",xaxt="n")
axis(1, at=seq(1,6,1),labels=seq(1,6,1),las=1)
axis(2, at=seq(0,1,0.2),labels=seq(0,1,0.2),las=1)
for(k in 1:3){lines(c(1:6),p1[k,],col=k,lty=k)}
lines(c(4.0,4.5),c(0.5,0.5),col=1,lty=1)
text(5.0,0.5,"klasa 1")
lines(c(4.0,4.5),c(0.45,0.45),col=2,lty=2)
text(5.0,0.45,"klasa 2")
lines(c(4.0,4.5),c(0.4,0.4),col=3,lty=3)
text(5.0,0.4,"klasa 3")
#Model 4 - zmienne obserwowane Y1-Y6, 3 zmienne towarzyszce X1, X2, X3, 3 klasy
model4<-cbind(Y1,Y2,Y3,Y4,Y5,Y6)~X1+X2+X3
lc3<-poLCA(model4,danesym1$dat,nclass=3,nrep=3,verbose=FALSE)
probs.start<-poLCA.reorder(lc3$probs.start,order(lc3$P,decreasing=FALSE))
lc3<-poLCA(model4,danesym1$dat,nclass=3,nrep=1,probs.start=probs.start,graph=FALSE,verbose=FALSE)
lc3m4<-c(lc3$llik,lc3$aic,lc3$bic)
p1<-cbind(lc3$probs$Y1[,1],lc3$probs$Y2[,1],lc3$probs$Y3[,1],lc3$probs$Y4[,1],lc3$probs$Y5[,1],lc3$probs$Y6[,1])
plot(c(1,6),c(0,1),xlab="Model (d), zmienne: obserwowane (Y1-Y6), towarzyszce X1, X2, X3",ylab="Prawdopodobiestwa dla Y=1",type="n",col=1,yaxt="n",xaxt="n")
axis(1,at=seq(1,6,1),labels=seq(1,6,1),las=1)
axis(2,at=seq(0,1,.2),labels=seq(0,1,0.2),las=1)
for(k in 1:3){lines(c(1:6),p1[k,],col=k,lty=k)}
lines(c(1.0,1.5),c(0.7,0.7),col=1,lty=1)
text(2.0,0.7,"klasa 1")
lines(c(1.0,1.5),c(0.65,0.65),col=2,lty=2)
text(2.0, 0.65,"klasa 2")
lines(c(1.0,1.5),c(0.6,0.6),col=3,lty=3)
text(2.0,0.6,"klasa 3")
#Wybr modelu
print("Wybr modelu")
wybmodel<-rbind(lc3m1,lc3m2,lc3m3,lc3m4)
dimnames(wybmodel)<-list(c("model 1","model 2","model 3","model 4"),c("LL","AIC","BIC"))
print(wybmodel)