#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Marek Walesiak     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************
library(clusterSim)
data(data_patternGDM2)
options(OutDec=",")
res<-pattern.GDM2(data_patternGDM2,
    performanceVariable=c("s","s","s","d","d","n"),
    nomOptValues=c(NA,NA,NA,NA,NA,3), weightsType="equal",weights=NULL,
    patternType="lower",patternCoordinates="manual",
    patternManual=c(1,1,1,4,2,"max"),
    nominalTransfMethod="symmetrical")
print("Dane po transformacji nominanty x6 na destymulant",quote=FALSE)
print(res$data)
print("Uporzdkowanie nieruchomoci od najlepszej do najgorszej wedug wartoci miary GDM2", quote=FALSE)
print(res$sortedDistances)
gdm_p<-res$distances
plot(cbind(gdm_p,gdm_p),xlim=c(max(gdm_p),min(gdm_p)),
    ylim=c(min(gdm_p),max(gdm_p)), xaxt="n",
    xlab="Uporzdkowanie nieruchomoci od najlepszej do najgorszej",
    ylab="Odlegoci GDM2 od obiektu wzorca",lwd=1.6,las=1)
axis(1,at=gdm_p,labels=names(gdm_p),cex.axis=0.5)