#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Funkcja do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

# fnw(a,x,y) - funkcja najwikszej wiarygodnoci dla warunkowego modelu logitowego (logarytm)
# Na podstawie: S. Jackman [2007] - Models for Unordered Outcomes, Political Science 150C/350C, Revision 134, April 30.
# a - wartoci startowe parametrw modelu
# x - wartoci atrybutw (zero-jedynkowe)
# y - zmienna objaniana o wartociach TRUE (wybrany profil) lub FALSE (nie wybrany profil)
# wywoanie - jako parametr funkcji optim{stats}
fnw<-function(a,x,y)
{
	mu<-x%*%a                #skadnik systematyczny reprezentujcy uyteczno profilw
	eta<-exp(mu)             #licznik
	suma<-tapply(eta,s,sum)  #mianownik (suma obserwacji na 1 respondenta (tu 9))
	pr<-eta[y]/suma          #prawdopodobiestwa wyboru profilw
	lnw<-sum(log(pr))        #suma logarytmw prawdopodobiestw
	lnw                      #logarytm funkcji najwikszej wiarygodnoci (zwracana warto funkcji)
}
